/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockCache;
import oracle.express.olapi.data.CursorBlockProvider;
import oracle.express.olapi.data.CursorTreeManager;

final class SecondaryCursorBlockProvider
extends CursorBlockProvider {
    private CursorBlockProvider _chainedCursorBlockProvider;
    private CursorBlockCache _cursorBlockCache;

    public SecondaryCursorBlockProvider(CursorBlockCache cursorBlockCache, CursorBlockProvider cursorBlockProvider) {
        super(cursorBlockProvider.getCursorBlockManager());
        this._cursorBlockCache = cursorBlockCache;
        this._chainedCursorBlockProvider = cursorBlockProvider;
    }

    public SecondaryCursorBlockProvider(CursorBlockCache cursorBlockCache, CursorBlockProvider cursorBlockProvider, CursorBlock cursorBlock) {
        this(cursorBlockCache, cursorBlockProvider);
        if (cursorBlock != null) {
            this.acceptCursorBlock(cursorBlock);
        }
    }

    @Override
    public final CursorBlock getCursorBlock(CursorTreeManager cursorTreeManager, Set set) {
        CursorBlock cursorBlock = null;
        ArrayList arrayList = new ArrayList();
        this._startRead();
        Iterator iterator = this._cursorBlockCache.getCacheIterator();
        while (iterator.hasNext()) {
            cursorBlock = (CursorBlock)iterator.next();
            if (!cursorTreeManager.validateWithBlock(cursorBlock, set)) continue;
            this._endRead();
            return cursorBlock;
        }
        this._endRead();
        set.addAll(arrayList);
        cursorBlock = this._chainedCursorBlockProvider.getCursorBlock(cursorTreeManager, set);
        this._startWrite();
        this._cursorBlockCache.acceptCursorBlock(cursorBlock);
        this._endWrite();
        return cursorBlock;
    }

    protected final void acceptCursorBlock(CursorBlock cursorBlock) {
        this._startWrite();
        this._cursorBlockCache.acceptCursorBlock(cursorBlock);
        this._endWrite();
    }

    @Override
    public final CursorBlock getAnyCursorBlock(CursorTreeManager cursorTreeManager) {
        this._startRead();
        CursorBlock cursorBlock = null;
        Iterator iterator = this._cursorBlockCache.getCacheIterator();
        cursorBlock = iterator.hasNext() ? (CursorBlock)iterator.next() : this._chainedCursorBlockProvider.getAnyCursorBlock(cursorTreeManager);
        this._endRead();
        return cursorBlock;
    }

    protected final void flush() {
        this._cursorBlockCache.flush();
    }

    public final void flush(CursorBlock cursorBlock) {
        this.flush();
        this.acceptCursorBlock(cursorBlock);
    }

    @Override
    public void die() {
        this.flush();
        this._chainedCursorBlockProvider.die();
    }
}

