/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class FloatHelper {
    private FloatHelper() {
    }

    public static float SQL2Java(InterfaceStub interfaceStub, Double d) {
        float f = d.floatValue();
        OlapiTracer.log("FloatHelper.SQL2Java: sqlfloat = " + d + ", jfloat = " + f);
        return f;
    }

    public static Double Java2SQL(InterfaceStub interfaceStub, float f) {
        Double d = new Double(f);
        OlapiTracer.log("FloatHelper.Java2SQL: jfloat = " + f + ", sqlfloat = " + d);
        return d;
    }

    public static float SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("FloatHelper.SQL2Java");
        float f = 0.0f;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            f = NUMBER.toFloat((byte[])byArray);
            OlapiTracer.log("jfloat = " + f);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("FloatHelper.SQL2Java");
        return f;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, float f) {
        OlapiTracer.enter("FloatHelper.Java2SQL");
        OlapiTracer.log("jfloat = " + f);
        try {
            byte[] byArray = NUMBER.toBytes((float)f);
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("FloatHelper.Java2SQL");
    }
}

