/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class ClobStream
implements OlapiStreamable {
    private boolean _valid;
    private CLOB _clob;
    private InputStream _is;
    private ByteArrayOutputStream _os;
    private Reader _reader;
    private StringWriter _writer;
    private long _wstringOffset;

    public ClobStream(Connection connection) {
        OlapiTracer.enter("ClobStream.constructor");
        try {
            this._clob = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            this._wstringOffset = 1L;
            this._is = null;
            this._os = new ByteArrayOutputStream();
            this._reader = null;
            this._writer = new StringWriter();
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.constructor");
    }

    public ClobStream(OracleCallableStatement oracleCallableStatement) {
        OlapiTracer.enter("ClobStream.constructor");
        try {
            this._wstringOffset = oracleCallableStatement.getNUMBER(1).longValue();
            this._wstringOffset = this._wstringOffset <= 0L ? 1L : this._wstringOffset;
            this._clob = oracleCallableStatement.getCLOB(2);
            this._is = this._clob.getAsciiStream();
            this._os = null;
            this._reader = this._clob.getCharacterStream(this._wstringOffset);
            this._writer = null;
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.constructor");
    }

    public ClobStream(CLOB cLOB) {
        this._clob = cLOB;
        this._wstringOffset = 1L;
        this._valid = true;
    }

    public boolean isValid() {
        return this._valid;
    }

    @Override
    public void setParams(OracleCallableStatement oracleCallableStatement) {
        OlapiTracer.enter("ClobStream.setParams");
        try {
            OlapiTracer.log("wstringOffset = " + this._wstringOffset);
            oracleCallableStatement.setNUMBER(1, new NUMBER(this._wstringOffset));
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setCLOB(2, this._clob);
            oracleCallableStatement.registerOutParameter(2, 2005);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.setParams");
    }

    public CLOB getCLOB() {
        return this._clob;
    }

    public long getWstringOffset() {
        return this._wstringOffset;
    }

    @Override
    public int read() {
        OlapiTracer.enter("ClobStream.read");
        int n = 0;
        try {
            n = this._is.read();
            OlapiTracer.log("byte read: " + n);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.read");
        return n;
    }

    @Override
    public void read(byte[] byArray) {
        OlapiTracer.enter("ClobStream.read");
        try {
            this._is.read(byArray);
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(" " + byArray[i]);
                }
                OlapiTracer.log("bytes(" + byArray.length + ") read: " + stringBuffer);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.read");
    }

    @Override
    public void read(char[] cArray) {
        OlapiTracer.enter("ClobStream.read");
        try {
            this._reader.read(cArray);
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("chars(" + cArray.length + ") read: " + cArray);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.read");
    }

    public String readAll() {
        OlapiTracer.enter("ClobStream.readAll");
        Reader reader = null;
        String string = null;
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            long l = this._clob.length();
            reader = this._clob.getCharacterStream();
            for (long i = 0L; i < l; i += (long)n) {
                n = reader.read(cArray);
                stringBuffer.append(cArray, 0, n);
            }
            string = stringBuffer.toString();
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("string(" + stringBuffer.length() + ") read: " + string);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        OlapiTracer.leave("ClobStream.readAll");
        return string;
    }

    @Override
    public void write(int n) {
        OlapiTracer.enter("ClobStream.write");
        Object var2_2 = null;
        try {
            this._os.write(n);
            OlapiTracer.log("byte written: " + n);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.write");
    }

    @Override
    public void write(byte[] byArray) {
        OlapiTracer.enter("ClobStream.write");
        try {
            this._os.write(byArray);
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(" " + byArray[i]);
                }
                OlapiTracer.log("bytes(" + byArray.length + ") written: " + stringBuffer);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.write");
    }

    @Override
    public void write(String string) {
        OlapiTracer.enter("ClobStream.write");
        try {
            this._writer.write(string);
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("string(" + string.length() + ") written: " + string);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.write");
    }

    public void writeAll(String string) {
        OlapiTracer.enter("ClobStream.writeAll");
        Writer writer = null;
        try {
            writer = this._clob.getCharacterOutputStream();
            writer.write(string);
            writer.flush();
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("string(" + string.length() + ") written: " + string);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
        OlapiTracer.leave("ClobStream.writeAll");
    }

    @Override
    public void write(byte[][] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i]);
        }
    }

    @Override
    public void write(StringBuffer[] stringBufferArray) {
        for (int i = 0; i < stringBufferArray.length; ++i) {
            this.write(new String(stringBufferArray[i]));
        }
    }

    @Override
    public void flush() {
        OlapiTracer.enter("ClobStream.flush");
        try {
            OutputStream outputStream = this._clob.getAsciiOutputStream();
            byte[] byArray = this._os.toByteArray();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            this._os.reset();
            this._wstringOffset = byArray.length + 1;
            Writer writer = this._clob.getCharacterOutputStream(this._wstringOffset);
            writer.write(this._writer.toString());
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("ClobStream.flush");
    }

    @Override
    public void close() {
        try {
            if (null != this._is) {
                this._is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._is = null;
        try {
            if (null != this._os) {
                this._os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._os = null;
        try {
            if (null != this._reader) {
                this._reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._reader = null;
        try {
            if (null != this._writer) {
                this._writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._writer = null;
        try {
            if (this._clob.isTemporary()) {
                CLOB.freeTemporary((CLOB)this._clob);
            } else {
                this._clob.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._clob = null;
        this._valid = false;
    }
}

