/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTExtractor;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitor;

public class RESTSQLVisitor
implements RESTVisitor {
    private StringBuilder call = new StringBuilder();

    public String getContents() {
        return this.call.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(RESTExtractor.ExportEntity entity) {
        List<RESTExtractor.Module> modules = entity.modules;
        if (modules.size() == 0) {
            if (entity.isRequestionAllModules) {
                this.call.append("No modules found in the current schema.");
            } else if (entity.isModulePath) {
                this.call.append("No module found for path: " + entity.moduleFilter);
            } else {
                this.call.append("No module named: " + entity.moduleFilter);
            }
            return;
        }
        this.call.append("declare\n  l_module_id number;\n  l_template_id number;\n  l_handler_id number;\n  l_parameter_id number;\nbegin\n");
        for (RESTExtractor.Module module : modules) {
            this.visit(module);
        }
        for (String key : entity.privileges.keySet()) {
            this.call.append("\n    declare\n");
            this.call.append("      l_modules owa.vc_arr;\n");
            this.call.append("      l_roles owa.vc_arr;\n");
            this.call.append("      l_patterns owa.vc_arr;\n");
            this.call.append("      l_priv_id number;\n");
            this.call.append("      l_role_id number;\n");
            this.call.append("    begin\n");
            RESTExtractor.Privilege priv = entity.privileges.get(key);
            int roleCounter = 1;
            for (String string : priv.getRoles()) {
                this.call.append("      l_role_id := ORDS_SERVICES.create_role('" + string + "');\n");
                this.call.append("      l_roles(" + roleCounter++ + ") := '" + string + "';\n");
            }
            int moduleCounter = 1;
            for (String module : priv.getModules()) {
                this.call.append("      l_modules(" + moduleCounter++ + ") := '" + module + "';\n");
            }
            boolean bl = true;
            for (String pattern : priv.getPatterns()) {
                void var8_9;
                this.call.append("      l_patterns(" + (int)(++var8_9) + ") := '" + pattern + "';\n");
            }
            this.call.append("      l_priv_id := ORDS_SERVICES.create_privilege(\n");
            this.call.append("        p_name => '" + priv.name + "',\n");
            this.call.append("        p_label => '" + priv.label + "',\n");
            this.call.append("        p_description => '" + priv.description + "',\n");
            this.call.append("        p_roles => l_roles,\n");
            this.call.append("        p_modules => l_modules,\n");
            this.call.append("        p_patterns => l_patterns,\n");
            this.call.append("        p_comments => '" + priv.comments + "');\n");
            this.call.append("    end;");
        }
        this.call.append("\ncommit;\n");
        this.call.append("end;\n/");
    }

    @Override
    public void visit(RESTExtractor.Module module) {
        this.call.append("\n  l_module_id := ORDS_METADATA.ORDS_SERVICES.create_module(");
        if (module.name != null) {
            this.call.append(" p_name => '" + module.name + "' ,");
        }
        if (module.prefix != null) {
            this.call.append(" p_uri_prefix => '" + module.prefix + "' ,");
        }
        if (module.items != null) {
            this.call.append(" p_items_per_page => " + module.items + " ,");
        }
        if (module.status != null) {
            this.call.append(" p_status => '" + module.status + "' ,");
        }
        if (module.comments != null) {
            this.call.append(" p_comments => '" + module.comments + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RESTExtractor.Template template : module.templates) {
            this.visit(template);
        }
        this.call.append("\n");
    }

    @Override
    public void visit(RESTExtractor.Template template) {
        this.call.append("\n  l_template_id := ORDS_METADATA.ORDS_SERVICES.add_template( p_module_id => l_module_id,");
        if (template.uriTemplate != null) {
            this.call.append(" p_uri_template => '" + template.uriTemplate + "' ,");
        }
        if (template.priority != null) {
            this.call.append(" p_priority => " + template.priority + " ,");
        }
        if (template.etagType != null) {
            this.call.append(" p_etag_type => '" + template.etagType + "' ,");
        }
        if (template.etagQuery != null) {
            this.call.append(" p_etag_query => '" + template.etagQuery + "' ,");
        }
        if (template.comments != null) {
            this.call.append(" p_comments => '" + template.comments + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RESTExtractor.Handler handler : template.handlers) {
            this.visit(handler);
        }
    }

    @Override
    public void visit(RESTExtractor.Handler handler) {
        this.call.append("\n");
        this.call.append("  l_handler_id := ORDS_METADATA.ORDS_SERVICES.add_handler( p_template_id => l_template_id,");
        if (handler.sourceType != null) {
            this.call.append(" p_source_type => '" + handler.sourceType + "' ,");
        }
        if (handler.method != null) {
            this.call.append(" p_method => '" + handler.method + "' ,");
        }
        if (handler.mimesAllowed != null) {
            this.call.append(" p_mimes_allowed => '" + handler.mimesAllowed + "' ,");
        }
        if (handler.itemsPerPage != null) {
            this.call.append(" p_items_per_page => " + handler.itemsPerPage + " ,");
        }
        if (handler.comments != null) {
            this.call.append(" p_comments => '" + handler.comments + "'");
        }
        if (handler.source != null) {
            this.call.append(" p_source => ");
            this.appendClob(handler.source);
            this.call.append(",");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RESTExtractor.Parameter parameter : handler.parameters) {
            this.visit(parameter);
        }
    }

    @Override
    public void visit(RESTExtractor.Parameter parameter) {
        this.call.append("\n");
        this.call.append("  l_parameter_id := ORDS_METADATA.ORDS_SERVICES.add_parameter( p_handler_id => l_handler_id,");
        if (parameter.name != null) {
            this.call.append(" p_name => '" + parameter.name + "' ,");
        }
        if (parameter.bindName != null) {
            this.call.append(" p_bind_variable_name => '" + parameter.bindName + "' ,");
        }
        if (parameter.sourceType != null) {
            this.call.append(" p_source_type => '" + parameter.sourceType + "' ,");
        }
        if (parameter.accessMethod != null) {
            this.call.append(" p_access_method => '" + parameter.accessMethod + "' ,");
        }
        if (parameter.paramType != null) {
            this.call.append(" p_param_type => '" + parameter.paramType + "'");
        }
        if (parameter.comments != null) {
            this.call.append(" p_comments => '" + parameter.comments + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
    }

    private void appendClob(InputStream in) {
        if (in == null) {
            this.call.append("null");
        }
        Integer bufferSize = 200;
        char[] buffer = new char[bufferSize.intValue()];
        String chunk = "";
        boolean isFirstChunk = true;
        String newLineReplacement = "' || unistr('\\000a')\n   || '";
        InputStreamReader clobStream = new InputStreamReader(in);
        boolean firstRead = true;
        while (true) {
            int readResult = -1;
            try {
                buffer = new char[bufferSize.intValue()];
                readResult = clobStream.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (readResult < 0) {
                if (!chunk.endsWith("' || unistr('\\000a')\n   || '")) break;
                this.call.replace(this.call.length() - 5, this.call.length() - 1, "");
                break;
            }
            chunk = this.trimNulls(buffer);
            chunk = chunk.replace("'", "''");
            chunk = "'" + chunk + "'";
            if (!firstRead) {
                chunk = "  ||  " + chunk;
            } else {
                firstRead = false;
            }
            chunk = chunk.replace("\n", "' || unistr('\\000a')\n   || '");
            if (isFirstChunk && chunk.startsWith("' || unistr('\\000a')\n   || '")) {
                chunk = chunk.replaceFirst("' || unistr('\\000a')\n   || '", "'' || unistr('\\000a')\n   || '");
            }
            isFirstChunk = false;
            this.call.append(chunk);
        }
    }

    private void appendRawClob(Clob clob, StringBuilder call) throws SQLException {
        if (clob == null || clob.length() == 0L) {
            call.append("null");
        }
        Integer bufferSize = 200;
        char[] buffer = new char[bufferSize.intValue()];
        String chunk = "";
        boolean isFirstChunk = true;
        String newLineReplacement = "' || unistr('\\000a')\n   || '";
        Reader clobStream = clob.getCharacterStream();
        boolean firstRead = true;
        while (true) {
            int readResult = -1;
            try {
                buffer = new char[bufferSize.intValue()];
                readResult = clobStream.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (readResult < 0) {
                if (!chunk.endsWith("' || unistr('\\000a')\n   || '")) break;
                call.replace(call.length() - 5, call.length() - 1, "");
                break;
            }
            chunk = this.trimNulls(buffer);
            chunk = chunk.replace("'", "''");
            chunk = "'" + chunk + "'";
            if (!firstRead) {
                chunk = "  ||  " + chunk;
            } else {
                firstRead = false;
            }
            chunk = chunk.replace("\n", "' || unistr('\\000a')\n   || '");
            if (isFirstChunk && chunk.startsWith("' || unistr('\\000a')\n   || '")) {
                chunk = chunk.replaceFirst("' || unistr('\\000a')\n   || '", "'' || unistr('\\000a')\n   || '");
            }
            isFirstChunk = false;
            call.append(chunk);
        }
    }

    private String trimNulls(char[] input) {
        int firstNullPosition = -1;
        String result = "";
        for (int i = 0; i < input.length; ++i) {
            int charValue = new Byte((byte)input[i]).intValue();
            if (charValue != 0) continue;
            firstNullPosition = i;
            break;
        }
        result = firstNullPosition > -1 ? new String(input, 0, firstNullPosition) : new String(input);
        return result;
    }
}

