/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitable;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitor;
import oracle.dbtools.util.StreamCopy;
import oracle.jdbc.driver.OracleConnection;

public class RESTExtractor {
    private static final String PRIVILEGES_QUERY = "select p.* from USER_ORDS_PRIVILEGE_MODULES pm, USER_ORDS_PRIVILEGES p where pm.module_name = ? and pm.privilege_id = p.id";
    private static final String LEGACY_PRIVILEGES_QUERY = "select p.* from USER_ORDS_PRIVILEGE_MODULES pm, USER_ORDS_PRIVILEGES p where pm.module_name = ? and pm.privilege_id = p.id".replace("USER_", "ALL_");
    private static final String EXTRACT_MODULES_QUERY = "select * from USER_ORDS_MODULES";
    private static final String PRIVILEGE_ROLES_QUERY = "select role_name from USER_ORDS_PRIVILEGE_ROLES where privilege_name = ?";
    private static final String LEGACY_PRIVILEGE_ROLES_QUERY = "select role_name from USER_ORDS_PRIVILEGE_ROLES where privilege_name = ?".replace("USER_", "ALL_");
    private static final String PATTERNED_PRIVILEGES_QUERY = "select p.*, m.pattern from USER_ORDS_PRIVILEGES p, USER_ORDS_PRIVILEGE_MAPPINGS m where  p.id = m.privilege_id and p.name <> 'oracle.soda.privilege.developer' order by p.id";
    private static final String LEGACY_PATTERNED_PRIVILEGES_QUERY = "select p.*, m.pattern from USER_ORDS_PRIVILEGES p, USER_ORDS_PRIVILEGE_MAPPINGS m where  p.id = m.privilege_id and p.name <> 'oracle.soda.privilege.developer' order by p.id".replace("USER_", "ALL_");

    public ExportEntity getExport(Connection conn, String moduleName) throws SQLException, IOException, ModuleNotFoundException {
        List<Module> modules = this.getModules(conn, moduleName);
        Map<String, Privilege> privileges = this.getPrivileges(conn, modules, false);
        boolean isRequestingAllModules = moduleName == null || "".equals(moduleName);
        boolean isModulePath = false;
        if (moduleName != null) {
            isModulePath = moduleName.startsWith("/");
        }
        ExportEntity entity = new ExportEntity();
        entity.modules = modules;
        entity.privileges = privileges;
        entity.isRequestionAllModules = isRequestingAllModules;
        entity.isModulePath = isModulePath;
        entity.moduleFilter = moduleName;
        return entity;
    }

    private String getCanonicalPath(String modulePath) {
        String res = modulePath;
        if (modulePath == null || "".equals(modulePath)) {
            return modulePath;
        }
        if ("/".equals(modulePath)) {
            return modulePath;
        }
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        if (!res.endsWith("/")) {
            res = res + "/";
        }
        return res;
    }

    private List<Module> getModules(Connection conn, String moduleName) throws SQLException, ModuleNotFoundException, IOException {
        List<Module> modules = null;
        try {
            modules = this.getModules(conn, moduleName, false);
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            // empty catch block
        }
        if (modules == null || modules.isEmpty()) {
            modules = this.getModules(conn, this.getCanonicalPath(moduleName), true);
        }
        return modules;
    }

    private List<Module> getModules(Connection conn, String moduleName, Boolean isPrefixSearch) throws SQLException, ModuleNotFoundException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        boolean isRequestingAllModules = moduleName == null || "".equals(moduleName);
        boolean isModulePath = false;
        if (isRequestingAllModules) {
            stmt = ocon.prepareStatement(EXTRACT_MODULES_QUERY);
        } else {
            String baseStatement = EXTRACT_MODULES_QUERY;
            isModulePath = isPrefixSearch;
            if (isModulePath) {
                if ("/".equals(moduleName)) {
                    baseStatement = baseStatement + " where uri_prefix is null";
                    stmt = ocon.prepareStatement(baseStatement);
                } else {
                    baseStatement = baseStatement + " where uri_prefix = ?";
                    baseStatement = baseStatement + " or uri_prefix = ?";
                    baseStatement = baseStatement + " or uri_prefix = ?";
                    baseStatement = baseStatement + " or uri_prefix = ?";
                    stmt = ocon.prepareStatement(baseStatement);
                    stmt.setString(1, moduleName);
                    stmt.setString(2, moduleName.substring(1, moduleName.length()));
                    stmt.setString(3, moduleName.substring(1, moduleName.length() - 1));
                    stmt.setString(4, moduleName.substring(0, moduleName.length() - 1));
                }
            } else {
                baseStatement = baseStatement + " where name = ?";
                stmt = ocon.prepareStatement(baseStatement);
                stmt.setString(1, moduleName);
            }
        }
        ResultSet result = stmt.executeQuery();
        ArrayList<Module> moduleList = new ArrayList<Module>();
        boolean hasModules = false;
        while (result.next()) {
            hasModules = true;
            String name = result.getString("NAME");
            String prefix = result.getString("URI_PREFIX");
            Integer items = result.getInt("ITEMS_PER_PAGE");
            String status = result.getString("STATUS");
            String comments = result.getString("COMMENTS");
            Integer moduleId = result.getInt("ID");
            Module module = new Module();
            module.name = name;
            module.prefix = prefix;
            module.items = items;
            module.status = status;
            module.comments = comments;
            module.id = moduleId;
            module.templates = this.getTemplates(conn, module.id);
            moduleList.add(module);
        }
        if (!hasModules && !isRequestingAllModules) {
            if (isModulePath) {
                throw new ModuleNotFoundException(ModuleSearchOrigin.PATH, moduleName);
            }
            throw new ModuleNotFoundException(ModuleSearchOrigin.NAME, moduleName);
        }
        if (!hasModules) {
            throw new ModuleNotFoundException(ModuleSearchOrigin.ALL);
        }
        return moduleList;
    }

    private Map<String, Privilege> getPrivileges(Connection conn, List<Module> modules, boolean legacy) throws SQLException {
        HashMap<String, Privilege> privs = new HashMap<String, Privilege>();
        if (modules == null) {
            return privs;
        }
        OracleConnection ocon = (OracleConnection)conn;
        for (Module module : modules) {
            String moduleName = module.name;
            PreparedStatement stmt = null;
            stmt = legacy ? ocon.prepareStatement(LEGACY_PRIVILEGES_QUERY) : ocon.prepareStatement(PRIVILEGES_QUERY);
            stmt.setString(1, moduleName);
            ResultSet result = null;
            try {
                result = stmt.executeQuery();
                while (result.next()) {
                    String name = result.getString("name");
                    if (privs.containsKey(name)) {
                        ((Privilege)privs.get(name)).modules.add(moduleName);
                        continue;
                    }
                    String label = result.getString("label");
                    String description = result.getString("description");
                    String comments = result.getString("comments");
                    List<String> roles = this.getPrivilegeRoles(conn, name, legacy);
                    ArrayList<String> privilegeModules = new ArrayList<String>();
                    ArrayList<String> patterns = new ArrayList<String>();
                    privilegeModules.add(moduleName);
                    Privilege priv = new PrivilegesBuilder().name(name).label(label).description(description).comments(comments).roles(roles).modules(privilegeModules).patterns(patterns).build();
                    privs.put(name, priv);
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 942 && !legacy) {
                    return this.getPrivileges(conn, modules, true);
                }
                throw e;
            }
        }
        PreparedStatement stmt = null;
        stmt = legacy ? ocon.prepareStatement(LEGACY_PATTERNED_PRIVILEGES_QUERY) : ocon.prepareStatement(PATTERNED_PRIVILEGES_QUERY);
        ResultSet result = null;
        try {
            result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString("name");
                String pattern = result.getString("pattern");
                if (privs.containsKey(name)) {
                    if (pattern == null || "".equals(pattern)) continue;
                    ((Privilege)privs.get(name)).patterns.add(pattern);
                    continue;
                }
                String label = result.getString("label");
                String description = result.getString("description");
                String comments = result.getString("comments");
                List<String> roles = this.getPrivilegeRoles(conn, name, legacy);
                ArrayList<String> privilegeModules = new ArrayList<String>();
                ArrayList<String> patterns = new ArrayList<String>();
                if (pattern != null && !"".equals(pattern)) {
                    patterns.add(pattern);
                }
                Privilege priv = new PrivilegesBuilder().name(name).label(label).description(description).comments(comments).roles(roles).modules(privilegeModules).patterns(patterns).build();
                privs.put(name, priv);
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942 && !legacy) {
                return this.getPrivileges(conn, modules, true);
            }
            throw e;
        }
        return privs;
    }

    private List<String> getPrivilegeRoles(Connection conn, String privilegeName, boolean legacy) throws SQLException {
        ArrayList<String> roles = new ArrayList<String>();
        if (privilegeName == null || privilegeName.equals("")) {
            return roles;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        stmt = legacy ? ocon.prepareStatement(LEGACY_PRIVILEGE_ROLES_QUERY) : ocon.prepareStatement(PRIVILEGE_ROLES_QUERY);
        stmt.setString(1, privilegeName);
        ResultSet result = null;
        try {
            result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString("role_name");
                roles.add(name);
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942 && !legacy) {
                return this.getPrivilegeRoles(conn, privilegeName, true);
            }
            throw e;
        }
        return roles;
    }

    private List<Template> getTemplates(Connection conn, Integer id) throws SQLException, IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        if (id == null) {
            return templates;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement("select * from USER_ORDS_TEMPLATES where module_id = ?");
        stmt.setInt(1, id);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String uriTemplate = result.getString("URI_TEMPLATE");
            Integer priority = result.getInt("PRIORITY");
            String etagType = result.getString("ETAG_TYPE");
            String etagQuery = result.getString("ETAG_QUERY");
            String comments = result.getString("COMMENTS");
            Integer templateId = result.getInt("ID");
            Template template = new Template();
            template.uriTemplate = uriTemplate;
            template.priority = priority;
            template.etagType = etagType;
            template.etagQuery = etagQuery;
            template.comments = comments;
            template.id = templateId;
            template.handlers = this.getHandlers(conn, template.id);
            templates.add(template);
        }
        return templates;
    }

    private List<Handler> getHandlers(Connection conn, Integer id) throws SQLException, IOException {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        if (id == null) {
            return handlers;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement("select * from USER_ORDS_HANDLERS where template_id = ?");
        stmt.setInt(1, id);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String sourceType = result.getString("SOURCE_TYPE");
            String method = result.getString("METHOD");
            String mimesAllowed = result.getString("MIMES_ALLOWED");
            Integer itemsPerPage = result.getInt("ITEMS_PER_PAGE");
            Clob source = result.getClob("SOURCE");
            String comments = result.getString("COMMENTS");
            StringBuilder ce = new StringBuilder();
            StreamCopy.drain(source.getCharacterStream(), ce);
            InputStream clob = StreamCopy.toInputStream(ce.toString());
            Handler handler = new Handler();
            handler.sourceType = sourceType;
            handler.method = method;
            handler.mimesAllowed = mimesAllowed;
            handler.itemsPerPage = itemsPerPage;
            handler.comments = comments;
            handler.source = clob;
            Integer handlerId = result.getInt("ID");
            handler.parameters = this.getParameters(conn, handlerId);
            handlers.add(handler);
        }
        return handlers;
    }

    private List<Parameter> getParameters(Connection conn, Integer id) throws SQLException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (id == null) {
            return parameters;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement("select * from USER_ORDS_PARAMETERS where handler_id = ?");
        stmt.setInt(1, id);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String name = result.getString("NAME");
            String bindName = result.getString("BIND_VARIABLE_NAME");
            String sourceType = result.getString("SOURCE_TYPE");
            String accessMethod = result.getString("ACCESS_METHOD");
            String paramType = result.getString("PARAM_TYPE");
            String comments = result.getString("COMMENTS");
            Parameter parameter = new Parameter();
            parameter.name = name;
            parameter.bindName = bindName;
            parameter.sourceType = sourceType;
            parameter.accessMethod = accessMethod;
            parameter.paramType = paramType;
            parameter.comments = comments;
            parameters.add(parameter);
        }
        return parameters;
    }

    class PrivilegesBuilder {
        private String name;
        private String label;
        private String description;
        private String comments;
        private List<String> roles;
        private List<String> modules;
        private List<String> patterns;

        PrivilegesBuilder() {
        }

        public PrivilegesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PrivilegesBuilder label(String label) {
            this.label = label;
            return this;
        }

        public PrivilegesBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PrivilegesBuilder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Privilege build() {
            return new Privilege(this);
        }

        public PrivilegesBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public PrivilegesBuilder modules(List<String> modules) {
            this.modules = modules;
            return this;
        }

        public PrivilegesBuilder patterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }
    }

    class Privilege {
        String name;
        String label;
        String description;
        String comments;
        private List<String> roles = new ArrayList<String>();
        private List<String> modules = new ArrayList<String>();
        private List<String> patterns = new ArrayList<String>();

        public Privilege(PrivilegesBuilder builder) {
            this.name = builder.name;
            this.label = builder.label;
            this.description = builder.description;
            this.comments = builder.comments;
            if (builder.roles != null) {
                this.roles = builder.roles;
            }
            if (builder.modules != null) {
                this.modules = builder.modules;
            }
            if (builder.patterns != null) {
                this.patterns = builder.patterns;
            }
        }

        public List<String> getPatterns() {
            return this.patterns;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public List<String> getModules() {
            return this.modules;
        }
    }

    class Parameter
    implements RESTVisitable {
        String name;
        String bindName;
        String sourceType;
        String accessMethod;
        String paramType;
        String comments;

        Parameter() {
        }

        @Override
        public void accept(RESTVisitor visitor) {
            visitor.visit(this);
        }
    }

    class Handler
    implements RESTVisitable {
        String sourceType;
        String method;
        String mimesAllowed;
        Integer itemsPerPage;
        InputStream source;
        String comments;
        List<Parameter> parameters;

        Handler() {
        }

        @Override
        public void accept(RESTVisitor visitor) {
            visitor.visit(this);
        }
    }

    class Template
    implements RESTVisitable {
        public Integer id;
        String uriTemplate;
        Integer priority;
        String etagType;
        String etagQuery;
        String comments;
        List<Handler> handlers;

        Template() {
        }

        @Override
        public void accept(RESTVisitor visitor) {
            visitor.visit(this);
        }
    }

    class Module
    implements RESTVisitable {
        String name;
        String prefix;
        Integer items;
        String status;
        String comments;
        Integer id;
        List<Template> templates;

        Module() {
        }

        @Override
        public void accept(RESTVisitor visitor) {
            visitor.visit(this);
        }
    }

    class ExportEntity
    implements RESTVisitable {
        public String moduleFilter;
        public boolean isModulePath;
        public boolean isRequestionAllModules;
        List<Module> modules;
        Map<String, Privilege> privileges;

        ExportEntity() {
        }

        @Override
        public void accept(RESTVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static enum ModuleSearchOrigin {
        NAME,
        PATH,
        ALL;

    }

    class ModuleNotFoundException
    extends Throwable {
        private static final long serialVersionUID = 1548710029851198208L;
        private ModuleSearchOrigin origin;
        private String moduleName;
        private String modulePath;

        ModuleNotFoundException(ModuleSearchOrigin origin) {
            this.origin = null;
            this.moduleName = null;
            this.modulePath = null;
            this.origin = origin;
        }

        ModuleNotFoundException(ModuleSearchOrigin origin, String originName) {
            this(origin, originName, null);
        }

        ModuleNotFoundException(ModuleSearchOrigin origin, String originName, Throwable t) {
            super(t);
            this.origin = null;
            this.moduleName = null;
            this.modulePath = null;
            this.origin = origin;
            if (ModuleSearchOrigin.NAME.equals((Object)origin)) {
                this.moduleName = originName;
            }
            if (ModuleSearchOrigin.PATH.equals((Object)origin)) {
                this.modulePath = originName;
            }
        }

        public ModuleSearchOrigin getOrigin() {
            return this.origin;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModulePath() {
            return this.modulePath;
        }
    }
}

