/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTExtractor;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTSQLVisitor;
import oracle.dbtools.util.Logger;
import oracle.jdbc.driver.OracleConnection;

public class RESTCommand
extends CommandListener
implements IHelp {
    private static final String ALL_PRIVS_QUERY = "select NAME, LABEL, DESCRIPTION, COMMENTS from USER_ORDS_PRIVILEGES where schema_id > 1000";
    private static final String ALL_SCHEMAS_QUERY = "select PARSING_SCHEMA NAME from USER_ORDS_SCHEMAS";
    private static final String ALL_MODULES_QUERY = "select NAME, URI_PREFIX PREFIX, STATUS, ITEMS_PER_PAGE from USER_ORDS_MODULES";
    private static final String CMD = "REST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (conn == null) return false;
        if (!(conn instanceof OracleConnection)) {
            return false;
        }
        OracleConnection ocon = (OracleConnection)conn;
        String sql = cmd.getSql();
        ArrayList<String> cmds = new ArrayList<String>();
        this.splitArgs(sql, cmds);
        if (cmds.size() == 0) return false;
        if (cmds.size() > 0 && !"rest".equalsIgnoreCase(cmds.get(0))) {
            return false;
        }
        String option = null;
        String module = null;
        if (cmds.size() < 2 || cmds.size() >= 4) {
            ctx.write(this.getHelp());
            return true;
        }
        if (cmds.size() >= 2) {
            option = cmds.get(1);
        }
        if (cmds.size() >= 3) {
            module = cmds.get(2);
        }
        try {
            if (ocon != null && (ctx.getProperty("script.runner.PRELIM_AUTH") == null || Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE)).booleanValue())) {
                if (!DBUtil.isOracleConnectionAlive(ocon)) {
                    ctx.write(Messages.getString("ApexCmd.7"));
                    return true;
                }
                boolean amILocked = LockManager.lock(ocon);
                try {
                    if (!amILocked) return true;
                    if ("modules".equalsIgnoreCase(option)) {
                        this.listAllModules(ocon, ctx);
                        return true;
                    }
                    if ("export".equalsIgnoreCase(option)) {
                        RESTExtractor caller = new RESTExtractor();
                        RESTExtractor.ExportEntity result = caller.getExport(ocon, module);
                        RESTSQLVisitor v = new RESTSQLVisitor();
                        v.visit(result);
                        ctx.write(v.getContents());
                        return true;
                    }
                    if ("privileges".equalsIgnoreCase(option)) {
                        this.listAllPrivs(ocon, ctx);
                        return true;
                    }
                    if ("schemas".equalsIgnoreCase(option)) {
                        this.listAllSchemas(ocon, ctx);
                        return true;
                    }
                    ctx.write(this.getHelp());
                    boolean caller = true;
                    return caller;
                }
                finally {
                    if (amILocked) {
                        LockManager.unlock(ocon);
                    }
                }
            }
            ctx.write(Messages.getString("ApexCmd.7"));
            return true;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                System.err.println("ORDS is not installed in the current schema.");
                return true;
            }
            Logger.finest(this.getClass(), e.getLocalizedMessage(), e);
            ctx.write(e.getLocalizedMessage() + "\n");
            return true;
        }
        catch (IOException f) {
            Logger.finest(this.getClass(), f.getLocalizedMessage(), f);
            return true;
        }
        catch (RESTExtractor.ModuleNotFoundException g) {
            RESTExtractor.ModuleSearchOrigin origin = g.getOrigin();
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.ALL.name())) {
                System.err.println("No modules found in the current schema.");
                return true;
            }
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.NAME.name())) {
                System.err.println("No module named: " + g.getModuleName());
                return true;
            }
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.PATH.name())) {
                if ("/".equals(g.getModulePath())) {
                    System.err.println("No module found with an empty prefix");
                    return true;
                } else {
                    System.err.println("No module found with the name or path specified.");
                }
                return true;
            }
            System.err.println("Unknown module origin");
            return true;
        }
    }

    private void listAllModules(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement(ALL_MODULES_QUERY);
        this.executeGenericCall(ctx, stmt);
    }

    private void listAllSchemas(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement(ALL_SCHEMAS_QUERY);
        this.executeGenericCall(ctx, stmt);
    }

    private void listAllPrivs(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement(ALL_PRIVS_QUERY);
        this.executeGenericCall(ctx, stmt);
    }

    private void executeGenericCall(ScriptRunnerContext ctx, PreparedStatement statement) throws SQLException, IOException {
        ResultSet result = statement.executeQuery();
        SQLPLUSCmdFormatter formatter = new SQLPLUSCmdFormatter(ctx);
        formatter.rset2sqlplusShrinkToSize(result, ctx.getBaseConnection(), ctx.getOutputStream());
    }

    protected boolean splitArgs(String commandline, ArrayList<String> args) {
        int lineLength = commandline.length();
        int terminalIndex = lineLength - 1;
        boolean nullChar = false;
        StringBuilder arg = new StringBuilder();
        StringBuilder quoted = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < lineLength; ++i) {
            char ch = commandline.charAt(i);
            if (quoteChar != '\u0000') {
                quoted.append(ch);
                if (ch == quoteChar) {
                    arg.append((CharSequence)quoted);
                    quoted = new StringBuilder();
                    quoteChar = '\u0000';
                }
            } else if (ch == '\"' || ch == '\'') {
                quoted.append(ch);
                quoteChar = ch;
            } else if (Character.isWhitespace(ch)) {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg = new StringBuilder();
                }
            } else {
                arg.append(ch);
            }
            if (i != terminalIndex || quoteChar == '\u0000') continue;
            arg.append(quoteChar);
            i -= quoted.length() - 1;
            quoted = new StringBuilder();
            quoteChar = '\u0000';
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
    }
}

