/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.sql.Connection;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class DelCommand
extends CommandListener
implements IHelp {
    private static final String DEL = "DEL";
    private static final String CMD = "del";
    private static final String STAR = "*";
    private static final String LAST = "last";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = sqlpcmd.split("\\s+");
        if (cmds.length >= 1 && cmds[0].matches(CMD) && ctx.getSQLPlusBuffer() != null) {
            IBuffer buffer = ctx.getSQLPlusBuffer();
            if (cmds.length == 1) {
                ctx.write(buffer.getBufferSafe().delete());
            } else if (cmds.length == 2) {
                String delOption = cmds[1];
                int x = 0;
                if (delOption.equals(STAR)) {
                    ctx.write(buffer.getBufferSafe().deleteStar());
                } else if (delOption.toLowerCase().startsWith("la")) {
                    ctx.write(buffer.getBufferSafe().deleteLast());
                } else {
                    try {
                        x = Integer.parseInt(delOption);
                        ctx.write(buffer.getBufferSafe().delete(x));
                    }
                    catch (NumberFormatException e) {
                        ctx.write(this.getHelp());
                    }
                }
            } else if (cmds.length == 3) {
                String delOption1 = cmds[1];
                String delOption2 = cmds[2];
                if (delOption1.equals(STAR) || delOption2.equals(STAR)) {
                    if (delOption1.equals(STAR)) {
                        if (this.isAnInteger(delOption2)) {
                            ctx.write(buffer.getBufferSafe().deleteStarN(Integer.parseInt(delOption2)));
                        } else if (delOption2.toLowerCase().startsWith("l")) {
                            ctx.write(buffer.getBufferSafe().deleteStarN(buffer.getBufferSafe().size()));
                        }
                    } else if (delOption2.equals(STAR) && this.isAnInteger(delOption1)) {
                        ctx.write(buffer.getBufferSafe().deleteNStar(Integer.parseInt(delOption1)));
                    }
                } else if (this.isAnInteger(delOption1)) {
                    if (this.isAnInteger(delOption2)) {
                        ctx.write(buffer.getBufferSafe().delete(Integer.parseInt(delOption1), Integer.parseInt(delOption2)));
                    } else if (delOption2.toLowerCase().startsWith("l")) {
                        ctx.write(buffer.getBufferSafe().delete(Integer.parseInt(delOption1), buffer.getBufferSafe().size()));
                    } else {
                        ctx.write(Messages.getString("ListCommand.1"));
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnInteger(String delOption) {
        try {
            Integer.parseInt(delOption);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return DEL;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(DEL);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

