/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.sql.Connection;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class ChangeCommand
extends CommandListener {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean amIChange;
        boolean bl = amIChange = cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CHANGE);
        if (amIChange) {
            try {
                if (ctx.getSQLPlusBuffer() != null) {
                    String baseString = cmd.getSQLOrig();
                    String findString = null;
                    String replaceString = null;
                    StringTokenizer st = new StringTokenizer(baseString, StringUtils.getFirstNonAlpha(baseString) != null ? StringUtils.getFirstNonAlpha(baseString) : "/");
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        findString = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        replaceString = st.nextToken();
                    }
                    if (findString != null & replaceString != null) {
                        ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().change(findString, replaceString));
                        ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().listStar(false));
                        return true;
                    }
                    if (findString != null) {
                        ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().change(findString));
                        ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().listStar(false));
                        return true;
                    }
                    if (findString == null) {
                        ctx.write(Messages.getString("ChangeCommand.1"));
                        return true;
                    }
                }
            }
            catch (PatternSyntaxException e) {
                ctx.write(Messages.getString("ChangeCommand.1"));
                return true;
            }
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

