/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetSQLPlusCompatability
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"SQLPLUSCOMPAT", "SQLPLUSCOMPATIBILITY"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.set_sqlpluscompat") != null) {
            String x = (String)ctx.getProperty("script.runner.set_sqlpluscompat");
            int numberofDots = x.split("\\.").length - 1;
            if (numberofDots == 1) {
                x = x + ".0";
            }
            if (numberofDots == 0 || numberofDots > 2) {
                ctx.write("Usage: SET SQLPLUSCOMPAT[IBILITY] version.release.[update]" + LINE_SEPARATOR);
            } else {
                ctx.write(MessageFormat.format("sqlpluscompatibility {0}" + LINE_SEPARATOR, x));
            }
        } else {
            String[] ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn)).toString().split("\\.");
            ctx.write(MessageFormat.format("sqlpluscompatibility {0}" + LINE_SEPARATOR, ver[0] + "." + ver[1] + "." + ver[2]));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write("");
        } else {
            String token;
            String input = token = tokens[2];
            String regex = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(input);
            if (matcher.matches()) {
                ctx.putProperty("script.runner.set_sqlpluscompat", token);
            } else {
                ctx.write("Usage: SET SQLPLUSCOMPAT[IBILITY] version.release.[update]" + LINE_SEPARATOR);
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

