/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetEditFile
extends CommandListener
implements IShowCommand,
IStoreCommand {
    private String[] aliases = new String[]{"editf", "editfile"};

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] tokens = cmd.getSql().split("\\s+");
        if (tokens.length != 3) {
            ctx.write("Usage: SET EDITF[ILE] filename[.ext]\n");
        } else {
            String filename = tokens[2];
            ctx.putProperty("script.runner.file.editfile", filename);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(MessageFormat.format("editfile \"{0}\"\n", ctx.getProperty("script.runner.file.editfile")));
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("editfile", MessageFormat.format("\"{0}\"", String.valueOf(ctx.getProperty("script.runner.file.editfile"))));
    }
}

