/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleReader;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetClearScreen
extends CommandListener
implements IShowCommand {
    @Override
    public String[] getShowAliases() {
        return new String[]{"CLEAR"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(MessageFormat.format(Messages.getString("SetClearScreenMode.1"), ctx.getProperty("sqlcl.clear.screen").toString()));
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] cmds = cmd.getSQLOrig().split("\\s+");
        IConsoleReader reader = ctx.getSQLPlusConsoleReader();
        if (cmds.length == 3 && cmds[2].toLowerCase().equals("top")) {
            ctx.putProperty("sqlcl.clear.screen", "top");
            if (reader != null) {
                ((DbtoolsConsoleReader)((Object)reader)).setClearScreenMode("top");
            }
        } else if (cmds.length == 3 && cmds[2].toLowerCase().equals("bottom")) {
            ctx.putProperty("sqlcl.clear.screen", "bottom");
            if (reader != null) {
                ((DbtoolsConsoleReader)((Object)reader)).setClearScreenMode("bottom");
            }
        } else if (cmds.length == 3 && cmds[2].toLowerCase().equals("same")) {
            ctx.putProperty("sqlcl.clear.screen", "same");
            if (reader != null) {
                ((DbtoolsConsoleReader)((Object)reader)).setClearScreenMode("same");
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

