/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetClassicMode
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"classic", "classicmode", "_12.1_pdb", "_12.1_longident"};

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            ctx.write("SQL*Plus mode: ON\n");
        } else if (ctx != null && ctx.getProperty("sqlplus.classic.mode") != null && !Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            ctx.write("SQL*Plus mode: OFF\n");
        } else {
            ctx.write("SQL*Plus mode: OFF\n");
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().split("\\s+").length == 3 && (cmd.getSql().split("\\s+")[2].toLowerCase().equals("on") || cmd.getSql().split("\\s+")[2].toLowerCase().equals("off"))) {
            if (cmd.getSql().split("\\s+")[2].toLowerCase().equals("on")) {
                ctx.putProperty("sqlplus.classic.mode", Boolean.TRUE);
            } else {
                ctx.putProperty("sqlplus.classic.mode", Boolean.FALSE);
            }
        } else {
            ctx.write("Invalid SQL*Plus classic mode. \"Classic mode\" can be 'on' or 'off'\n");
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

