/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class HistoryCommand
extends CommandListener
implements IHelp {
    private static final String USAGE = Messages.getString("HistoryCommand.0");
    private static final String TIME = "time";
    private static final String FAILS = "fails";
    private static final String FULL = "full";
    private static final String CLEAR = "clear";
    private static final String SESSION = "session";
    private static final String SCRIPT = "script";
    private static final String REMOVE = "remove";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static boolean showFails = false;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] cmds = cmd.getSQLOrig().split("\\s+");
        if (cmds.length > 3) {
            ctx.write(Messages.getString("HistoryCommand.8"));
            ctx.write(Messages.getString("HistoryCommand.9"));
            return true;
        }
        if ((cmd.getSQLOrig().startsWith("his") || cmd.getSQLOrig().startsWith("h")) && cmds.length == 2 | cmds.length == 3) {
            if (cmds[1].toLowerCase().equals(USAGE)) {
                ctx.write(MultiLineHistory.getInstance().listHistory(true, false, false, false, showFails));
                return true;
            }
            if (cmds[1].toLowerCase().equals(FULL)) {
                ctx.write(MultiLineHistory.getInstance().listHistory(false, true, false, false, showFails));
                return true;
            }
            if (cmds[1].toLowerCase().equals(REMOVE)) {
                int i;
                String[] lines = cmds[2].split(",");
                ArrayList<Integer> lint = new ArrayList<Integer>();
                for (i = 0; i < lines.length; ++i) {
                    try {
                        int mint = Integer.parseInt(lines[i]);
                        lint.add(mint);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Collections.sort(lint);
                for (i = lint.size(); i >= 0; --i) {
                    if (i > MultiLineHistory.getInstance().getSize() || i < 0) continue;
                    MultiLineHistory.getInstance().remove(i);
                }
            } else if (cmds[1].toLowerCase().equals(SCRIPT)) {
                ctx.write(MultiLineHistory.getInstance().listHistory(false, true, false, true, showFails));
            } else if (cmds[1].toLowerCase().equals(CLEAR)) {
                if (ctx.getProperty("script.runner.jline") != null) {
                    MultiLineHistory history = MultiLineHistory.getInstance();
                    if (cmds.length > 2 && cmds[2].toLowerCase().equals(SESSION)) {
                        for (HistoryItem hi : history.getHistory()) {
                            hi.setIsCurrentSession(false);
                        }
                    } else {
                        history.clear();
                    }
                    ctx.write(Messages.getString("HistoryCommand.13"));
                }
            } else {
                if (cmds[1].toLowerCase().equals(SAVE)) {
                    if (ctx.getProperty("script.runner.jline") != null) {
                        MultiLineHistory history = MultiLineHistory.getInstance();
                        history.save();
                    } else {
                        ctx.write(Messages.getString("HistoryCommand.14"));
                    }
                    return true;
                }
                if (cmds[1].toLowerCase().equals(LOAD)) {
                    if (ctx.getProperty("script.runner.jline") != null) {
                        MultiLineHistory history = MultiLineHistory.getInstance();
                        history.load();
                    } else {
                        ctx.write(Messages.getString("HistoryCommand.15"));
                    }
                    return true;
                }
                if (cmds[1].toLowerCase().equals(TIME)) {
                    ctx.write(MultiLineHistory.getInstance().listHistory(false, false, true, false, showFails));
                    return true;
                }
                if (cmds[1].toLowerCase().equals(FAILS)) {
                    if (cmds.length != 3) {
                        ctx.write("HIST-010: Invalid arguaments to failure command.\n");
                    } else if (cmds[2].toLowerCase().equals("on")) {
                        showFails = true;
                    } else if (cmds[2].toLowerCase().equals("off")) {
                        showFails = false;
                    } else {
                        ctx.write("HIST-010: Invalid arguaments to failure command.\n");
                    }
                    String x = "no";
                    if (showFails) {
                        x = "";
                    }
                    ctx.write(MessageFormat.format("History will show {0} failures.\n", x));
                } else {
                    try {
                        int a = Integer.parseInt(cmds[1]);
                        if (a > 0 && a <= MultiLineHistory.getInstance().getHistory().size()) {
                            ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(MultiLineHistory.getInstance().getItem(a));
                            ctx.getSQLPlusBuffer().resetBuffer(MultiLineHistory.getInstance().getItem(a));
                            ctx.write(ctx.getSQLPlusBuffer().list(false));
                            return true;
                        }
                        ctx.write(Messages.getString("HistoryCommand.16"));
                        return false;
                    }
                    catch (Exception e) {
                        ctx.write(Messages.getString("HistoryCommand.17"));
                    }
                }
            }
        } else if ((cmd.getSQLOrig().startsWith("his") || cmd.getSQLOrig().startsWith("h")) && cmds.length == 1) {
            if (MultiLineHistory.getInstance().getSize() > 0) {
                ctx.write("History: \n");
                ctx.write(MultiLineHistory.getInstance().listHistory(false, false, false, false, showFails));
            } else {
                ctx.write("History empty\n");
            }
        } else if (cmd.getSQLOrig().startsWith("h") && cmds.length == 1) {
            String item = cmd.getSQLOrig().trim().substring(1);
            int a = Integer.parseInt(item);
            if (a > 0 && a <= MultiLineHistory.getInstance().getHistory().size()) {
                ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(MultiLineHistory.getInstance().getItem(a));
                ctx.getSQLPlusBuffer().resetBuffer(MultiLineHistory.getInstance().getItem(a));
                ctx.write(ctx.getSQLPlusBuffer().list(false));
                return true;
            }
            ctx.write(Messages.getString("HistoryCommand.21"));
            return false;
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "HISTORY";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }
}

