/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.clone;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jline.internal.Log;
import oracle.dbtools.raptor.console.clone.KeyMap;
import oracle.dbtools.raptor.console.clone.Operation;

public class DbtoolsNonBlockingInputStream
extends InputStream
implements Runnable {
    private InputStream _in = null;
    private ArrayList<Integer> _inputBuffer = new ArrayList();
    private boolean _shutdown = false;
    private static DbtoolsNonBlockingInputStream _instance = null;
    private boolean _nonBlockingEnabled = true;
    private boolean _pause = false;
    private KeyMap _keymap = null;
    private boolean _waiting = true;

    public static DbtoolsNonBlockingInputStream getInstance(InputStream in, boolean nonBlockingEnabled) {
        if (_instance == null) {
            _instance = new DbtoolsNonBlockingInputStream(in, nonBlockingEnabled);
        }
        return _instance;
    }

    private DbtoolsNonBlockingInputStream(InputStream in, boolean nonBlockingEnabled) {
        this._in = in;
        this._nonBlockingEnabled = nonBlockingEnabled;
        if (this._nonBlockingEnabled) {
            Thread t = new Thread(this);
            t.setName("DBtoolsNonBlockingInputStreamThread");
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void run() {
        Log.debug("DBtoolsNonBlockingInputStream start");
        int charRead = -2;
        while (!this._shutdown && charRead != -1) {
            if (this.isNewLine(charRead)) {
                this.pauseTillNextRead();
            }
            charRead = -2;
            try {
                charRead = this._in.read();
                this.addToBuffer(charRead);
            }
            catch (IOException iOException) {}
        }
        Log.debug("DbtoolsNonBlockingInputStream shutdown");
    }

    private boolean isNewLine(int charRead) {
        block8: {
            try {
                if (this._keymap != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.appendCodePoint(charRead);
                        Object o = this._keymap.getBound(sb);
                        if (o instanceof Operation && (Operation)((Object)o) == Operation.ACCEPT_LINE) {
                            return true;
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        if (charRead == 13) {
                            return true;
                        }
                        break block8;
                    }
                }
                if (charRead == 13) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void pauseTillNextRead() {
        try {
            DbtoolsNonBlockingInputStream dbtoolsNonBlockingInputStream = this;
            synchronized (dbtoolsNonBlockingInputStream) {
                this._waiting = true;
                this.wait(0L);
                this._waiting = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(0L, false);
    }

    public int read(long timeout) throws IOException {
        return this.read(timeout, false);
    }

    private synchronized int read(long timeout, boolean isPeek) throws IOException {
        if (!this._nonBlockingEnabled) {
            return this._in.read();
        }
        if (this._waiting && this.getBufferSize() == 0) {
            if (isPeek) {
                return -2;
            }
            this.notify();
        }
        if (this.getBufferSize() == 0) {
            try {
                if (timeout == 0L) {
                    while (this.getBufferSize() == 0) {
                        this.wait(10L);
                    }
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getBufferSize() == 0) {
            return -2;
        }
        int chr = this.getFirstCharFromBuffer();
        if (!isPeek && chr != -1) {
            this.removeFirstCharFromBuffer();
        }
        return chr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBuffer(int charRead) {
        ArrayList<Integer> arrayList = this._inputBuffer;
        synchronized (arrayList) {
            if (charRead != -1 || this._inputBuffer.isEmpty() || this._inputBuffer.get(this._inputBuffer.size() - 1) != -1) {
                this._inputBuffer.add(charRead);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFirstCharFromBuffer() {
        ArrayList<Integer> arrayList = this._inputBuffer;
        synchronized (arrayList) {
            this._inputBuffer.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFirstCharFromBuffer() {
        ArrayList<Integer> arrayList = this._inputBuffer;
        synchronized (arrayList) {
            return this._inputBuffer.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBufferSize() {
        ArrayList<Integer> arrayList = this._inputBuffer;
        synchronized (arrayList) {
            return this._inputBuffer.size();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read(0L);
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        return 1;
    }

    public int peek(long timeout) throws IOException {
        return this.read(timeout, true);
    }

    public synchronized ArrayList<Integer> fullPeek() throws IOException {
        try {
            this.wait(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList inputBufferClone = null;
        if (this._waiting && !this._pause && this.getBufferSize() == 0) {
            this.notify();
        }
        inputBufferClone = (ArrayList)this._inputBuffer.clone();
        return inputBufferClone;
    }

    public String fullRead(boolean waitTillStable) throws IOException {
        if (!waitTillStable) {
            return this.fullRead();
        }
        boolean stable = false;
        while (!stable) {
            ArrayList<Integer> peek2;
            ArrayList<Integer> peek1 = this.fullPeek();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!peek1.equals(peek2 = this.fullPeek())) continue;
            stable = true;
        }
        return this.fullRead();
    }

    private synchronized String fullRead() throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean addMinusOne = false;
        for (Integer currentInt : this._inputBuffer) {
            if (currentInt != -1) {
                sb.appendCodePoint(currentInt);
                continue;
            }
            addMinusOne = true;
        }
        this.resetBuffer();
        if (addMinusOne) {
            this._inputBuffer.add(-1);
        }
        return sb.toString();
    }

    public boolean isNonBlockingEnabled() {
        return this._nonBlockingEnabled;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
        this.shutdown();
    }

    public synchronized void shutdown() {
        this._shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer() {
        ArrayList<Integer> arrayList = this._inputBuffer;
        synchronized (arrayList) {
            this._inputBuffer.clear();
        }
    }

    public void pause(boolean pause) {
        this._pause = pause;
    }

    public void setKeyMap(KeyMap keymap) {
        this._keymap = keymap;
    }
}

