/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.history.History;
import jline.internal.Preconditions;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.HistoryParser;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.IndexBuilder;
import org.w3c.dom.Node;

public class MultiLineHistory
implements IHelp,
History,
ICommandHistory {
    private static final String HISTORY = "history.xml";
    public static final String CONFIGFILE = File.separator + "history.xml";
    public static final String CONFIGBACK = File.separator + "history.xml" + "~";
    private static MultiLineHistory INSTANCE;
    private ArrayList<HistoryItem> history = new ArrayList();
    public static final int DEFAULT_MAX_ITEMS = 100;
    public static final int DEFAULT_MAX_FAILS = 100;
    private int maxItems = 100;
    private int maxFails = 100;
    private int offset = 0;
    private int index = 0;
    private int maxTimeLength = 0;
    private int maxTimesUsed = 0;
    private int terminalWidth = 80;
    private String noHistory;
    private String baseBlacklist = "";
    private boolean nofails = false;

    public int getSize() {
        return this.history.size();
    }

    public String getBaseBlackList() {
        return this.baseBlacklist;
    }

    public void setBaseBlackList(String blacklist) {
        this.baseBlacklist = blacklist;
    }

    public static String getBase() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sqlcl" : null;
        }
        return storage;
    }

    public ArrayList<HistoryItem> getHistory() {
        return this.history;
    }

    public void setHistory(ArrayList<HistoryItem> history) {
        this.history = history;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public MultiLineHistory(String stoargeDir) {
        File h;
        File f = new File(stoargeDir);
        if (f.exists() && (h = new File(stoargeDir + File.pathSeparator + HISTORY)).exists()) {
            this.load(h);
        }
        INSTANCE = this;
    }

    private void load(File history) {
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void addItem(String item, long duration, boolean fail) {
        if (item != null && item.length() > 0) {
            Iterator<HistoryItem> it = this.history.iterator();
            HistoryItem hi = null;
            boolean found = false;
            while (it.hasNext()) {
                hi = it.next();
                if (!hi.getData().equals(item)) continue;
                hi.dingTimesUsed();
                if (hi.getTimesUsed() > this.maxTimesUsed) {
                    this.maxTimesUsed = hi.getTimesUsed();
                }
                found = true;
                break;
            }
            if (!found) {
                if (this.history.size() >= this.maxItems) {
                    this.history.remove(0);
                }
                if (!this.nohistory(item)) {
                    hi = new HistoryItem(item);
                    hi.setTiming(duration);
                    hi.setFail(fail);
                    if (MultiLineHistory.getTimingString(duration).length() > this.maxTimeLength) {
                        this.maxTimeLength = MultiLineHistory.getTimingString(duration).length();
                    }
                    this.history.add(hi);
                    this.maybeResize();
                }
            } else if (item != null) {
                this.history.remove(hi);
                this.history.add(hi);
            }
            this.index = this.history.size();
        }
    }

    public void addItem(String item, long duration) {
        this.addItem(item, duration, false);
    }

    private boolean nohistory(String item) {
        if (item.length() > 0) {
            String command = "";
            if (this.getNoHistory() != null) {
                String[] cmds = this.getNoHistory().split(",");
                command = item.contains(" ") ? item.split("\\s+")[0] : item;
                for (String cmd : cmds) {
                    if (!cmd.toLowerCase().equals(command.toLowerCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addItem(String item) {
        this.addItem(item, 0L);
    }

    public void setTermWidth(int width) {
        this.terminalWidth = width;
    }

    public String listHistory(boolean timesExec, boolean fullList, boolean duration, boolean script, boolean showFails) {
        Iterator<HistoryItem> it = this.history.iterator();
        int i = 1;
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            HistoryItem hi = it.next();
            if (!showFails && hi.isFail() || script && (!script || !hi.inCurrentSession())) continue;
            String lineItem = IndexBuilder.getIndex(i, -1);
            if (timesExec) {
                String format = "";
                if (this.maxTimesUsed >= 0 && this.maxTimesUsed < 10) {
                    format = "%d";
                } else if (this.maxTimesUsed >= 10 && this.maxTimesUsed < 100) {
                    format = "%2d";
                } else if (this.maxTimesUsed > 100) {
                    format = "%3d";
                }
                lineItem = lineItem + MessageFormat.format("({0}) ", String.format(format, hi.getTimesUsed()));
            }
            if (duration) {
                String durationPad = "";
                if (hi.getTiming() > 0L) {
                    String durAct = MessageFormat.format("({0}) ", MultiLineHistory.getTimingString(hi.getTiming()));
                    int padSize = this.maxTimeLength - durAct.length();
                    if (padSize > 0) {
                        durationPad = new String(new char[padSize + 2]).replace('\u0000', ' ');
                    }
                    lineItem = lineItem + durationPad + durAct;
                } else {
                    durationPad = new String(new char[this.maxTimeLength + 3]).replace('\u0000', ' ');
                    lineItem = lineItem + durationPad;
                }
            }
            StringBuilder result = new StringBuilder();
            int indexLength = lineItem.length();
            String pad = new String(new char[indexLength]).replace('\u0000', ' ');
            pad = pad.substring(0, pad.length() - 3) + ">" + pad.substring(pad.length() - 2);
            if (fullList) {
                Iterator<String> hit = hi.getBuffer().iterator();
                boolean firstLine = true;
                while (hit.hasNext()) {
                    String historyItem = hit.next();
                    if (script) {
                        sb.append(historyItem + "\n");
                        continue;
                    }
                    if (firstLine) {
                        sb.append(lineItem + historyItem + "\n");
                        firstLine = false;
                        continue;
                    }
                    sb.append(pad + historyItem + "\n");
                }
                if (script) {
                    sb.deleteCharAt(sb.length() - 1);
                    String terminator = sb.toString().endsWith(";") ? "\n/" : ";";
                    sb.append(terminator + "\n");
                }
            } else {
                String x = lineItem + hi.getData().replace("\n", " ").replace("\r", " ");
                if (x.length() >= this.terminalWidth) {
                    x = x.substring(0, this.terminalWidth - 1);
                }
                result.append(x);
            }
            sb.append(result.toString() + "\n");
            ++i;
        }
        return sb.toString();
    }

    public List<String> getItem(int item) {
        if (item < 1) {
            item = 1;
        }
        if (item > this.history.size()) {
            item = this.history.size();
        }
        HistoryItem hi = this.history.get(item - 1);
        return hi.getBuffer();
    }

    public static void main(String[] args) {
        MultiLineHistory history = MultiLineHistory.getInstance();
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n2\nfrom\ndual where 1\n=1");
        history.addItem("select\n3\nfrom\ndual where 1\n=1");
        history.addItem("select\n4\nfrom\ndual where 1\n=1");
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n2\nfrom\ndual where 1\n=1");
        history.addItem("select\n3\nfrom\ndual where 1\n=1");
        history.addItem("select\n4\nfrom\ndual where 1\n=1");
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n1\nfrom\ndual where 1\n=1");
        history.addItem("select\n2\nfrom\ndual where 1\n=1");
        history.addItem("select\n3\nfrom\ndual where 1\n=1");
        history.addItem("select\n4\nfrom\ndual where 1\n=1");
        System.out.println(history.listHistory(true, true, true, true, true));
    }

    public static MultiLineHistory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiLineHistory(System.getProperty("user.name") + File.separator + ".sqlplus");
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void addHistoryItem(Node child) {
    }

    @Override
    public String getCommand() {
        return "HISTORY";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public int size() {
        return this.history.size();
    }

    @Override
    public boolean isEmpty() {
        return this.history == null || this.history != null && this.history.size() == 0;
    }

    @Override
    public int index() {
        return this.offset + this.index;
    }

    @Override
    public void clear() {
        this.history.clear();
        this.index = 0;
        this.maxTimeLength = 0;
        this.maxTimesUsed = 0;
    }

    @Override
    public CharSequence get(int index) {
        if (this.history.isEmpty()) {
            return "";
        }
        Buffer tmp = new Buffer();
        tmp.resetBuffer(this.getItem(index));
        return tmp.getBuffer();
    }

    @Override
    public void add(CharSequence item) {
        Preconditions.checkNotNull(item);
        if (this.isAutoTrim()) {
            item = String.valueOf(item).trim();
        }
        if (this.isIgnoreDuplicates() && !this.history.isEmpty() && item.equals(this.history.get(this.history.size()))) {
            return;
        }
        this.internalAdd(item);
    }

    protected void internalAdd(CharSequence item) {
        this.addItem(item.toString());
        this.maybeResize();
    }

    @Override
    public void set(int index, CharSequence item) {
        this.history.set(index - this.offset, new HistoryItem(item.toString()));
    }

    @Override
    public CharSequence remove(int i) {
        Preconditions.checkNotNull(this.history);
        Preconditions.checkNotNull(i);
        HistoryItem item = this.history.get(i);
        this.history.remove(i);
        return item.getData();
    }

    @Override
    public CharSequence removeFirst() {
        ListIterator<HistoryItem> it = this.history.listIterator();
        String seq = it.next().getData();
        it.remove();
        return seq;
    }

    @Override
    public CharSequence removeLast() {
        HistoryItem item = this.history.get(this.history.size());
        this.history.remove(this.history.size());
        return item.getData();
    }

    @Override
    public void replace(CharSequence item) {
        this.removeLast();
        this.add(item);
    }

    @Override
    public ListIterator<History.Entry> entries(int index) {
        return new EntriesIterator(index - this.offset);
    }

    @Override
    public ListIterator<History.Entry> entries() {
        return this.entries(this.offset);
    }

    @Override
    public Iterator<History.Entry> iterator() {
        return this.entries();
    }

    @Override
    public CharSequence current() {
        if (this.index >= this.size()) {
            return "";
        }
        return this.history.get(this.index).getData();
    }

    @Override
    public boolean previous() {
        if (this.index <= 0) {
            return false;
        }
        --this.index;
        return true;
    }

    @Override
    public boolean next() {
        if (this.index >= this.size()) {
            return false;
        }
        ++this.index;
        return true;
    }

    @Override
    public boolean moveToFirst() {
        if (this.size() > 0 && this.index != 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToLast() {
        int lastEntry = this.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.index) {
            this.index = this.size() - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(int index) {
        if ((index -= this.offset) >= 0 && index < this.size()) {
            this.index = index;
            return true;
        }
        return false;
    }

    @Override
    public void moveToEnd() {
        this.index = this.history.size();
    }

    public void setMaxFailSize(int maxSize) {
        this.maxFails = maxSize;
        this.maybeResize();
    }

    public void setMaxSize(int maxSize) {
        this.maxItems = maxSize;
        this.maybeResize();
    }

    private void maybeResize() {
        while (this.size() > this.getMaxSize()) {
            this.removeFirst();
            ++this.offset;
        }
        this.index = this.size();
    }

    public int getMaxSize() {
        return this.maxItems;
    }

    public boolean isIgnoreDuplicates() {
        return true;
    }

    public void setIgnoreDuplicates(boolean flag) {
    }

    public boolean isAutoTrim() {
        return false;
    }

    public void setAutoTrim(boolean flag) {
    }

    public void save() {
        HistoryParser parser = new HistoryParser();
        try {
            String base = MultiLineHistory.getBase();
            if (base == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HIST-013 APPDATA is null");
            }
            if (base != null && !new File(base).exists() && !new File(base).mkdirs()) {
                throw new Exception("HIST-009 " + base + " Directory did not create");
            }
            if (base != null & new File(base + CONFIGFILE).exists()) {
                if (new File(base + CONFIGBACK).exists() && !new File(base + CONFIGBACK).delete()) {
                    throw new Exception("HIST-011 " + base + CONFIGBACK + " could not be deleted ");
                }
                if (!new File(base + CONFIGFILE).renameTo(new File(base + CONFIGBACK))) {
                    throw new Exception("HIST-010 " + base + CONFIGFILE + " could not be renamed to " + base + CONFIGBACK);
                }
            }
            if (base != null) {
                parser.putXML(new File(base + CONFIGFILE), this.history);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void load() {
        HistoryParser parser = new HistoryParser();
        try {
            String base = MultiLineHistory.getBase();
            if (base == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HIST-013 APPDATA is null");
            }
            if (base != null && new File(base + CONFIGFILE).canRead()) {
                URL u = new File(base + CONFIGFILE).toURI().toURL();
                if (new File(base + CONFIGFILE).exists()) {
                    ArrayList<HistoryItem> filealiases = parser.processXML(u);
                    for (HistoryItem a : filealiases) {
                        if (MultiLineHistory.getTimingString(a.getTiming()).length() > this.maxTimeLength) {
                            this.maxTimeLength = MultiLineHistory.getTimingString(a.getTiming()).length();
                        }
                        if (a.getTimesUsed() > this.maxTimesUsed) {
                            this.maxTimesUsed = a.getTimesUsed();
                        }
                        if (this.historyContains(a.getData())) continue;
                        this.history.add(a);
                    }
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HIST-012 " + base + CONFIGFILE + " could not be read.");
                }
            }
            this.moveToEnd();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private boolean historyContains(String data) {
        for (HistoryItem hi : this.history) {
            if (!hi.getData().contains(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveCommand(ISQLCommand cmd) {
        if (!((cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_RUN) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SLASH) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DEL_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CHANGE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_HELP) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SAVE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_STORE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_GET) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_LIST) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_APPEND) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EDIT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_FORMAT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_COMMENT_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_HISTORY) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DOC_PLUS)) && !cmd.getSQLOrig().trim().toLowerCase().startsWith("repeat") || cmd.getdepth() != 0)) {
            MultiLineHistory.getInstance().addItem(cmd.getSQLOrigWithTerminator(), cmd.getTiming(), cmd.isFail());
        }
    }

    public static String getTimingString(long durationMilliSecs) {
        long mins;
        String x = "";
        long hrs = durationMilliSecs / 3600000L % 24L;
        if (hrs > 0L) {
            durationMilliSecs -= hrs * 1000L * 60L * 60L;
            x = x + String.format("%02d", hrs) + ":";
        }
        if ((mins = durationMilliSecs / 60000L % 60L) > 0L) {
            durationMilliSecs -= mins * 1000L * 60L;
            x = x + String.format("%02d", mins) + ":";
        }
        long secs = durationMilliSecs / 1000L % 60L;
        x = x + String.format("%02d", secs) + ".";
        if ((durationMilliSecs -= secs * 1000L) > 0L) {
            x = x + String.format("%03d", durationMilliSecs);
        }
        return x;
    }

    public final String getNoHistory() {
        return this.noHistory;
    }

    public final void setBlackList(String blacklist) {
        this.noHistory = blacklist;
    }

    @Override
    public void allowFailures(boolean value) {
        this.nofails = value;
    }

    public boolean showFailures() {
        return this.nofails;
    }

    private static class EntryImpl
    implements History.Entry {
        private final int index;
        private final CharSequence value;

        public EntryImpl(int index, CharSequence value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public CharSequence value() {
            return this.value;
        }

        public String toString() {
            return String.format("%d: %s", this.index, this.value);
        }
    }

    private class EntriesIterator
    implements ListIterator<History.Entry> {
        private final ListIterator<CharSequence> source;
        private LinkedList<CharSequence> ll;

        private EntriesIterator(int index) {
            ListIterator it = MultiLineHistory.this.history.listIterator(index);
            if (this.ll == null) {
                this.ll = new LinkedList();
                while (it.hasNext()) {
                    this.ll.add(((HistoryItem)it.next()).getData());
                }
            }
            this.source = this.ll.listIterator();
        }

        @Override
        public History.Entry next() {
            if (!this.source.hasNext()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MultiLineHistory.this.offset + this.source.nextIndex(), this.source.next());
        }

        @Override
        public History.Entry previous() {
            if (!this.source.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MultiLineHistory.this.offset + this.source.previousIndex(), this.source.previous());
        }

        @Override
        public int nextIndex() {
            return MultiLineHistory.this.offset + this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return MultiLineHistory.this.offset + this.source.previousIndex();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(History.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(History.Entry entry) {
            throw new UnsupportedOperationException();
        }
    }
}

