/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jline.console.completer.Completer;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;

public class SqlclCompleter
extends SqlCompleter
implements Completer {
    private static final String color32 = "\u001b[32m";
    private static final String color1 = "\u001b[1m";
    private static final String color0 = "\u001b[0m";
    static SqlEarley earley = SqlEarley.partialRecognizer(new String[]{"sql_statements"});
    static int approximateIndex = -1;
    static IProgram programInstance = null;
    private ScriptRunnerContext _ctx;

    public SqlclCompleter(ScriptRunnerContext ctx) {
        super(null);
        this._ctx = ctx;
    }

    private static void lookupHistory(List<CharSequence> candidates, String prefix) {
        prefix = prefix.trim();
        ArrayList<HistoryItem> history = MultiLineHistory.getInstance().getHistory();
        int cnt = 0;
        for (HistoryItem item : history) {
            String newSuggestion;
            if (7 < cnt) break;
            List<String> buffer = item.getBuffer();
            StringBuilder suggestion = new StringBuilder();
            for (String line : buffer) {
                suggestion.append(line);
                if (150 >= suggestion.length()) continue;
                suggestion = null;
                break;
            }
            if (suggestion == null || !(newSuggestion = suggestion.toString()).toLowerCase().startsWith(prefix.toLowerCase()) || SqlclCompleter.contains(candidates, newSuggestion)) continue;
            candidates.add(newSuggestion);
            ++cnt;
        }
    }

    private static boolean contains(List<CharSequence> candidates, String entry) {
        for (CharSequence tmp : candidates) {
            if (!((String)tmp).toUpperCase().trim().equals(entry.toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int complete(String lastLine, int cursor, List<CharSequence> candidates) {
        String colCompleteKey = "coloredComplete";
        String colComplete = HiddenParameters.parameters.get("coloredComplete");
        if (colComplete == null && this._ctx != null) {
            if ("ON".equals(this._ctx.getProperty("script.runner.color.coding"))) {
                colComplete = "true";
                HiddenParameters.parameters.put("coloredComplete", colComplete);
            }
        }
        try {
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println(color32);
                System.out.println("lastLine=" + lastLine + "");
                System.out.println("cursor=" + cursor);
            }
            String line = "";
            int pos = cursor;
            if (this._ctx != null) {
                line = this._ctx.getSQLPlusBuffer().getBufferString();
                pos = this._ctx.getSQLPlusBuffer().getBufferCursor(this._ctx.getSQLPlusBuffer().getCurrentLine(), cursor);
            } else {
                line = lastLine;
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("line=" + line);
                System.out.println("pos=" + pos);
            }
            CompletionList insight = this.complete(line, pos);
            for (CompletionItem item : insight.entries) {
                candidates.add(item.entry);
            }
            if (candidates.size() == 1 && 0 < candidates.get(0).toString().indexOf(32)) {
                return 0;
            }
            if (candidates.size() == 1) {
                String cleaned = null;
                for (CharSequence c : candidates) {
                    cleaned = c.toString();
                    cleaned = SqlclCompleter.discolor(cleaned);
                }
                candidates.clear();
                candidates.add(cleaned);
            }
            int ret = cursor;
            if (insight.prefix != null) {
                ret = cursor - insight.prefix.content.length();
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("return=" + ret + color0);
            }
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace(color0, "");
        cleaned = cleaned.replace(color1, "");
        cleaned = cleaned.replace(color32, "");
        return cleaned;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        conn = this._ctx != null ? this._ctx.getBaseConnection() : DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "hr", "hr");
        return conn;
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        public IProgram(String arboriProgram) throws IOException {
            super(arboriProgram);
        }
    }
}

