/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.snippet.InsertSnippetCommand;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetAddin;
import oracle.dbtools.raptor.snippet.SnippetRenderer;
import oracle.dbtools.raptor.snippet.SnippetWindow;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;

public class SnippetPanel
extends JPanel
implements ItemListener,
ChangeListener,
MouseListener,
KeyListener {
    private JComboBox _categories;
    protected JList _snippets;
    private DefaultListModel _snippetListModel;
    private DefaultComboBoxModel _categoryModel;
    private String _language = "PLSQL";
    private long _lastFileProcessed = 0L;
    private Toolbar _toolbar;
    private boolean _init = false;
    private SnippetWindow _window;

    public SnippetPanel(SnippetWindow snippetWindow) {
        super(new GridBagLayout());
        this._window = snippetWindow;
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
            snippetAddin.addChangeListener(this);
            this._categoryModel = new DefaultComboBoxModel();
            this._categories = new JComboBox(this._categoryModel);
            this._categories.addItemListener(this);
            this._snippetListModel = new DefaultListModel();
            this._snippets = new JList(this._snippetListModel);
            this._snippets.setDragEnabled(true);
            this._snippets.setSelectionMode(0);
            this._snippets.setCellRenderer(new SnippetRenderer());
            this._snippets.addMouseListener(this);
            this._snippets.addKeyListener(this);
            JScrollPane jScrollPane = new JScrollPane(this._snippets);
            this._toolbar = new Toolbar();
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._categories, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.fillCategories();
            if (this._categoryModel.getSize() > 0) {
                this._categories.setSelectedIndex(0);
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_dbsnippets_html");
        }
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void fillCategories() {
        SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
        String[] stringArray = snippetAddin.getCategories(this._language);
        if (this._lastFileProcessed < snippetAddin.lastFileLoad() && this._categoryModel != null) {
            this._categoryModel.removeAllElements();
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this._categoryModel.addElement(string);
            }
            this._lastFileProcessed = snippetAddin.lastFileLoad();
        }
    }

    private static SnippetAddin getSnippetAddin() {
        AddinManager addinManager = AddinManager.getAddinManager();
        SnippetAddin snippetAddin = (SnippetAddin)addinManager.getAddin(SnippetAddin.class);
        return snippetAddin;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this._categories.equals(object)) {
            this.whenCategoryChanged();
        }
    }

    private void whenCategoryChanged() {
        this._snippetListModel.removeAllElements();
        String string = (String)this._categories.getSelectedItem();
        ArrayList<Snippet> arrayList = new ArrayList<Snippet>();
        if (string != null) {
            SnippetAddin snippetAddin = SnippetPanel.getSnippetAddin();
            List<Snippet> object = snippetAddin.getSnippets(this._language, string);
            for (int i = 0; i < object.size(); ++i) {
                Snippet snippet = object.get(i);
                arrayList.add(snippet);
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Snippet)object).getName().compareTo(((Snippet)object2).getName());
            }
        });
        for (Snippet snippet : arrayList) {
            this._snippetListModel.addElement(snippet);
        }
    }

    public void setLanguage(String string) {
        this._language = string;
        this.fillCategories();
    }

    protected void insertSelectedSnippet() {
        CodeEditor codeEditor;
        Context context;
        Node node;
        EditorManager editorManager;
        Editor editor;
        Snippet snippet = (Snippet)this._snippets.getSelectedValue();
        if (snippet != null && (editor = (editorManager = EditorManager.getEditorManager()).getCurrentEditor()) instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)editor).getContext()).getNode()) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            int n = codeEditor.getCaretPosition();
            InsertSnippetCommand insertSnippetCommand = new InsertSnippetCommand(context, textNode, n, snippet.getCode());
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                commandProcessor.invoke((Command)insertSnippetCommand);
                editorManager.openEditor(new OpenEditorOptions(context));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SnippetAddin snippetAddin;
        Object object = changeEvent.getSource();
        if (object == (snippetAddin = SnippetPanel.getSnippetAddin())) {
            String string = String.valueOf(this._categories.getSelectedItem());
            Snippet snippet = (Snippet)this._snippets.getSelectedValue();
            this.fillCategories();
            this._categories.setSelectedItem(string);
            if (snippet != null) {
                String string2 = snippet.getName();
                int n = this._snippetListModel.getSize();
                for (int i = 0; i < n; ++i) {
                    Snippet snippet2 = (Snippet)this._snippetListModel.getElementAt(i);
                    if (!string2.equals(snippet2.getName())) continue;
                    this._snippets.setSelectedValue(snippet2, true);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.insertSelectedSnippet();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._window.getContextMenu().show(this._window.getContext(mouseEvent));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._window.getContextMenu().show(this._window.getContext(mouseEvent));
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.insertSelectedSnippet();
        }
    }
}

