/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.snippet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaResource;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.snippet.Messages;
import oracle.dbtools.raptor.snippet.SaxHandler;
import oracle.dbtools.raptor.snippet.Snippet;
import oracle.dbtools.raptor.snippet.SnippetPanel;
import oracle.dbtools.raptor.snippet.SnippetWindow;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.model.Node;
import oracle.javatools.data.HashStructure;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class SnippetAddin
implements Addin {
    private static Logger LOGGER = Logger.getLogger(SnippetAddin.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-snippet";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-snippet", "sqldev-snippet-hook");
    private static final String ENTRY_ELEMENT = "snippet";
    private static final String PACKAGE_ATTR = "package";
    private static final String FILE_ATTR = "file";
    static final String VIEW_TYPE = "SNIPPET_VIEW_TYPE";
    private Map<String, Map<String, List<Snippet>>> _languages;
    private final List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();
    private Map<String, Long> _modifed = new HashMap<String, Long>();
    private SAXParser parser;
    private long _lastFileChanged;
    private boolean _reloadBase = true;
    private boolean _loadingInProgress = false;
    private static List<MetaURLReference> _registeredMetaSnippets = new ArrayList<MetaURLReference>();
    public static final String encoding = "UTF-8";
    private static SnippetListener s_snippetListener;

    protected static synchronized void registerSnippet(MetaURLReference metaURLReference) {
        _registeredMetaSnippets.add(metaURLReference);
    }

    protected static synchronized void registerSnippet(URL uRL, ClassLoader classLoader) {
        SnippetAddin.registerSnippet(MetaURLReference.createURLReference((URL)uRL, (ClassLoader)classLoader));
    }

    private static synchronized void initListener() {
        if (s_snippetListener == null) {
            s_snippetListener = new SnippetListener();
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)s_snippetListener);
        }
    }

    public void initialize() {
        try {
            SnippetAddin.initListener();
            EditorManager.getEditorManager().addEditorListener((EditorListener)new EditorL());
        }
        catch (Exception exception) {
            System.err.print(Messages.getString("SnippetAddin.3"));
        }
    }

    public long lastFileLoad() {
        return this._lastFileChanged;
    }

    public String[] getCategories(String string) {
        this.load();
        Map<String, List<Snippet>> map = this._languages.get(string);
        Set<Object> set = map != null ? map.keySet() : Collections.emptySet();
        return set.toArray(new String[set.size()]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    private void load(File file, boolean bl) {
        if (bl || this._modifed.get(file.getAbsolutePath()) == null || file.lastModified() != this._modifed.get(file.getAbsolutePath()).longValue()) {
            this._lastFileChanged = System.currentTimeMillis();
            this._modifed.put(file.getAbsolutePath(), file.lastModified());
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encoding);
                this.load(inputStreamReader);
                this._reloadBase = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void load(Reader reader) {
        try {
            if (this.parser == null) {
                this.parser = new SAXParser();
            }
            SaxHandler saxHandler = new SaxHandler(this._languages, SnippetAddin.getXliff());
            this.parser.setValidationMode(0);
            this.parser.setContentHandler((ContentHandler)saxHandler);
            this.parser.setEntityResolver((EntityResolver)saxHandler);
            this.parser.setDTDHandler((DTDHandler)saxHandler);
            this.parser.setErrorHandler((ErrorHandler)saxHandler);
            this.parser.setPreserveWhitespace(false);
            this.parser.parse(reader);
            this._lastFileChanged = System.currentTimeMillis();
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load() {
        this.load(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean bl) {
        if (!this._loadingInProgress) {
            Object object;
            Object object3;
            this._loadingInProgress = true;
            if (this._languages == null || bl) {
                object3 = new HashMap<String, Map<String, List<Snippet>>>();
                this._languages = object3;
            }
            if (System.getProperty("raptor.user.snippets") != null) {
                char c = ':';
                if (System.getProperty("os.name").startsWith("Windows")) {
                    c = ';';
                }
                String[] object22 = System.getProperty("raptor.user.snippets").split("[" + c + "]");
                object = null;
                for (int fileNotFoundException = 0; fileNotFoundException < object22.length; ++fileNotFoundException) {
                    object = new File(object22[fileNotFoundException]);
                    if (!((File)object).exists()) continue;
                    this.load((File)object, bl);
                }
            }
            if (this._reloadBase || bl) {
                try {
                    try {
                        for (MetaURLReference metaURLReference : _registeredMetaSnippets) {
                            URL uRL;
                            object = null;
                            try {
                                InputStream throwable = metaURLReference.openInputStream();
                                object = new InputStreamReader(throwable, encoding);
                                this.load((Reader)object);
                                ((InputStreamReader)object).close();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                uRL = metaURLReference.getURL();
                                LOGGER.info(Messages.getString("SnippetAddin.17") + uRL.toString());
                            }
                            catch (Exception exception) {
                                uRL = metaURLReference.getURL();
                                String string = uRL.getHost();
                                if (string != null && string.indexOf("www.oracle.com") == -1) {
                                    LOGGER.severe(Messages.getString("SnippetAddin.17") + uRL.toString());
                                    continue;
                                }
                                LOGGER.info(Messages.getString("SnippetAddin.17") + uRL.toString());
                            }
                            finally {
                                if (object == null) continue;
                                try {
                                    ((InputStreamReader)object).close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.severe(Messages.getString("SnippetAddin.18") + "\n" + throwable.getMessage());
                    }
                    object3 = Resource.getResourceAsStream(this.getClass(), (String)"snippets.xml");
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object3, encoding);
                    this.load(inputStreamReader);
                    inputStreamReader.close();
                    this._reloadBase = false;
                }
                catch (Exception exception) {
                    System.err.print(Messages.getString("SnippetAddin.13") + exception.getMessage());
                }
                this.fireChangeEvent();
            }
            this._loadingInProgress = false;
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListenerArray = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            try {
                changeListener.stateChanged(changeEvent);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public List<Snippet> getSnippets(String string, String string2) {
        Map<String, List<Snippet>> map = this._languages.get(string);
        List<Snippet> list = map.get(string2);
        return new ArrayList<Snippet>(list);
    }

    private static XLIFFHelper getXliff() {
        return new XLIFFHelper(SnippetAddin.class.getClassLoader(), "/oracle/dbtools/raptor/snippet/snippets.xml");
    }

    private static class SnippetListener
    implements HashStructureHookListener {
        private SnippetListener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHooks(HashStructure hashStructure) {
            List list = hashStructure.getAsList(SnippetAddin.ENTRY_ELEMENT);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    LazyResourceAdapter lazyResourceAdapter = LazyResourceAdapter.getInstance((HashStructure)hashStructure2);
                    MetaResource metaResource = lazyResourceAdapter.getMetaResource(SnippetAddin.PACKAGE_ATTR);
                    metaResource = lazyResourceAdapter.getMetaResource(SnippetAddin.FILE_ATTR);
                    if (metaResource == null) continue;
                    SnippetAddin.registerSnippet(MetaURLReference.createURLReference((MetaResource)metaResource));
                }
            }
        }
    }

    private class EditorL
    implements EditorListener {
        private EditorL() {
        }

        public void editorOpened(Editor editor) {
        }

        public void editorActivated(Editor editor) {
            CodeEditor codeEditor;
            Context context;
            Node node;
            if (editor instanceof CodeEditor && (node = (context = (codeEditor = (CodeEditor)editor).getContext()).getNode()) instanceof PlSqlNode) {
                SnippetPanel snippetPanel = (SnippetPanel)SnippetWindow.getInstance().getGUI();
                snippetPanel.setLanguage("PLSQL");
            }
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    }
}

