/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DatabaseFeature;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DatabaseFeatureRegistryImpl
implements DatabaseFeatureRegistry {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-feature";
    private static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-feature", "sqldev-feature-hook");
    private static final String CLASSNAME_ELEMENT = "classname";
    private static final String QUERIES_ELEMENT = "queries";
    private static final String ID_ATTR = "id";
    private static final String FEATURE_ELEMENT = "feature";
    private static final String TEXT = "#text";
    private static final String FEATURE_DESCRIPTOR = "feature-descriptor";
    private static final Object LOCK = new Object();
    private static DatabaseFeatureRegistryImpl INSTANCE;
    protected Map<String, DatabaseFeature> m_knownFeatures;
    private Listener m_listener;
    protected Map<Connection, Map<String, Boolean>> m_features = new WeakHashMap<Connection, Map<String, Boolean>>();
    private static Map<String, DatabaseFeature> classnameMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseFeatureRegistryImpl getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new DatabaseFeatureRegistryImpl();
            }
        }
        return INSTANCE;
    }

    public boolean isFeatureEnabled(Connection connection, String string) {
        Map<String, Boolean> map = this.m_features.get(connection);
        Boolean bl = map != null && map.get(string) != false;
        return bl != null && bl != false;
    }

    private Map<String, DatabaseFeature> getFeatures() {
        this.initListener();
        return Collections.unmodifiableMap(this.m_knownFeatures);
    }

    private synchronized void initListener() {
        if (this.m_listener == null) {
            this.m_knownFeatures = new HashMap<String, DatabaseFeature>();
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.m_listener = new Listener();
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)this.m_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, DatabaseFeature> processURL(MetaResource metaResource) {
        HashMap<String, DatabaseFeature> hashMap = new HashMap<String, DatabaseFeature>();
        InputStream inputStream = null;
        URL uRL = metaResource.toURL();
        try {
            XMLNode[] xMLNodeArray;
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            inputStream = uRL.openStream();
            dOMParser.parse(inputStream);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)FEATURE_ELEMENT)) {
                String string = XMLHelper.getAttributeNode((Node)xMLNode, (String)ID_ATTR);
                Node node2 = XMLHelper.getChildNode((Node)xMLNode, (String)QUERIES_ELEMENT);
                if (node2 != null) {
                    if (!(node2 instanceof XMLNode)) continue;
                    hashMap.put(string, new QueryFeature((XMLNode)node2));
                    continue;
                }
                node2 = XMLHelper.getChildNode((Node)xMLNode, (String)CLASSNAME_ELEMENT);
                if (node2 == null) continue;
                String string2 = null;
                Node node3 = node2.getFirstChild();
                if (node3 instanceof Text) {
                    string2 = node3.getTextContent();
                }
                if (!ModelUtil.hasLength(string2)) continue;
                DatabaseFeature databaseFeature = classnameMap.get(string2);
                if (databaseFeature == null) {
                    Class<DatabaseFeature> clazz = metaResource.getClassLoader().loadClass(string2).asSubclass(DatabaseFeature.class);
                    databaseFeature = clazz.newInstance();
                    classnameMap.put(string2, databaseFeature);
                }
                hashMap.put(string, databaseFeature);
            }
        }
        catch (Exception exception) {
            Logger.severe(DatabaseFeatureRegistryImpl.class, (String)("Error parsing file " + uRL.toString()), (Throwable)exception);
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    public void initializeFeatures(Connection connection) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, DatabaseFeature> entry : this.getFeatures().entrySet()) {
            String string = entry.getKey();
            DatabaseFeature databaseFeature = entry.getValue();
            hashMap.put(string, databaseFeature.isFeatureEnabled(connection, string));
        }
        this.m_features.put(connection, hashMap);
    }

    public void cleanupFeatures(Connection connection) {
        this.m_features.remove(connection);
    }

    static {
        classnameMap = new HashMap<String, DatabaseFeature>();
    }

    private static class QueryFeature
    implements DatabaseFeature {
        private ObjectQueries m_queries;

        QueryFeature(XMLNode xMLNode) {
            this.m_queries = new ObjectQueries(xMLNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFeatureEnabled(Connection connection, String string) {
            Query query = this.m_queries.getQuery(connection);
            if (query != null) {
                String string2 = query.getSql();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                try {
                    boolean bl = dBUtil.executeReturnOneCol(string2) != null;
                    return bl;
                }
                finally {
                    SQLException sQLException = dBUtil.getLastException();
                    if (sQLException != null) {
                        Logger.fine(DatabaseFeatureRegistryImpl.class, (Throwable)sQLException);
                    }
                }
            }
            return false;
        }
    }

    private final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHooks(HashStructure hashStructure) {
            List list = hashStructure.getAsList(DatabaseFeatureRegistryImpl.FEATURE_DESCRIPTOR);
            if (list != null) {
                for (Object e : list) {
                    HashStructure hashStructure2 = (HashStructure)e;
                    MetaResource metaResource = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(DatabaseFeatureRegistryImpl.TEXT);
                    DatabaseFeatureRegistryImpl.this.m_knownFeatures.putAll(DatabaseFeatureRegistryImpl.processURL(metaResource));
                }
            }
        }
    }
}

