/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.ide.util.MetaResource;
import oracle.dbtools.util.Resource;

public abstract class MetaURLReference {
    private ClassLoader m_loader;

    MetaURLReference(ClassLoader classLoader) {
        this.m_loader = classLoader;
    }

    public ClassLoader getReferenceClassLoader() {
        return this.m_loader;
    }

    public abstract URL getURL();

    public abstract InputStream openInputStream() throws IOException;

    public static MetaURLReference createURLReference(URL uRL, ClassLoader classLoader) {
        return new U(uRL, classLoader);
    }

    public static MetaURLReference createURLReference(MetaResource metaResource) {
        return new MR(metaResource);
    }

    public static MetaURLReference createURLReference(File file, ClassLoader classLoader) {
        return new F(file, classLoader);
    }

    public static MetaURLReference createURLReference(Class<?> clazz, String string) {
        return new R(clazz, string);
    }

    private static final class R
    extends MetaURLReference {
        private Class<?> m_clsRef;
        private String m_fname;

        R(Class<?> clazz, String string) {
            super(clazz.getClassLoader());
            this.m_clsRef = clazz;
            this.m_fname = string;
        }

        @Override
        public URL getURL() {
            return this.m_clsRef.getResource(this.m_fname);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Resource.getResourceAsStream(this.m_clsRef, this.m_fname);
        }
    }

    private static final class F
    extends MetaURLReference {
        private File m_file;

        F(File file, ClassLoader classLoader) {
            super(classLoader);
            this.m_file = file;
        }

        @Override
        public URL getURL() {
            return null;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.m_file);
        }
    }

    private static final class U
    extends MetaURLReference {
        private URL m_url;

        U(URL uRL, ClassLoader classLoader) {
            super(classLoader);
            this.m_url = uRL;
        }

        @Override
        public URL getURL() {
            return this.m_url;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.m_url.openStream();
        }
    }

    private static final class MR
    extends MetaURLReference {
        private MetaResource m_resource;

        MR(MetaResource metaResource) {
            super(null);
            this.m_resource = metaResource;
        }

        @Override
        public ClassLoader getReferenceClassLoader() {
            return this.m_resource.getClassLoader();
        }

        @Override
        public URL getURL() {
            return this.m_resource.toURL();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.m_resource.getInputStream();
        }
    }
}

