/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;

public final class HostConnection {
    private Session mSession;
    private final HostDescriptor mDescriptor;
    private final Client mClient;
    private Map<String, Tunnel> mTunnels = new HashMap<String, Tunnel>();

    HostConnection(Client client, Session session, HostDescriptor hostDescriptor) {
        this.mClient = client;
        this.mSession = session;
        this.mDescriptor = hostDescriptor;
    }

    public HostDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public Session getSession() {
        return this.mSession;
    }

    public boolean isConnected() {
        return this.mSession != null && this.mSession.isConnected();
    }

    void disconnect() {
        for (Tunnel tunnel : this.mTunnels.values()) {
            try {
                tunnel.disconnect();
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
            this.mClient.fireTunnelClosed(tunnel);
        }
        this.mTunnels.clear();
        this.mSession.disconnect();
        this.mSession = null;
    }

    Tunnel openTunnel(TunnelDescriptor tunnelDescriptor) throws JSchException {
        if (this.mSession == null) {
            throw new JSchException("Closed Session", (Throwable)new IllegalStateException("Closed Session"));
        }
        String string = tunnelDescriptor.getName();
        Tunnel tunnel = this.mTunnels.get(string);
        if (tunnel == null) {
            tunnel = new Tunnel(this, tunnelDescriptor);
            tunnel.connect();
            this.mClient.fireTunnelOpened(tunnel);
            this.mTunnels.put(string, tunnel);
        }
        return tunnel;
    }

    boolean isTunnelOpen(TunnelDescriptor tunnelDescriptor) {
        return this.mTunnels.containsKey(tunnelDescriptor.getName());
    }

    void closeTunnel(TunnelDescriptor tunnelDescriptor) throws JSchException {
        String string = tunnelDescriptor.getName();
        Tunnel tunnel = this.mTunnels.remove(string);
        if (tunnel != null) {
            tunnel.disconnect();
            this.mClient.fireTunnelClosed(tunnel);
        }
    }
}

