/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.util.Pair;

public class SortShuttlePanel
extends ShuttlePanel<GridColumn> {
    private JRadioButton _rdbAscending;
    private JRadioButton _rdbDescending;
    private JCheckBox _cbxNullFirst;
    private JCheckBox _cbxNullLast;
    private JList _historyList;
    private HyperlinkButton _historyDeleteButton;
    private HyperlinkButton _historyDeleteAllButton;
    private HyperlinkButton _historySelectButton;
    private List<GridColumn> _gridCols;
    private static final long serialVersionUID = 1L;

    public SortShuttlePanel(String string, String string2, String string3, final RaptorGridTable raptorGridTable) {
        super(string, string2, string3);
        ArrayList<ArrayList<Pair<GridColumn, GridColumnSortParameter>>> arrayList;
        RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.loadPersistedSettings(raptorGridTable.getGridUniqueName());
        ArrayList<String> arrayList2 = null;
        DefaultListModel<ArrayList<Pair<GridColumn, GridColumnSortParameter>>> defaultListModel = new DefaultListModel<ArrayList<Pair<GridColumn, GridColumnSortParameter>>>();
        if (raptorGridPersistedSettings != null) {
            arrayList2 = raptorGridPersistedSettings.getSortClauses();
        }
        if ((arrayList = GridSorter.getSorts(arrayList2, raptorGridTable.getGridModel().getGridColumns())) != null) {
            for (ArrayList<Pair<GridColumn, GridColumnSortParameter>> arrayList3 : arrayList) {
                defaultListModel.addElement(arrayList3);
            }
        }
        this._historyList.setModel(defaultListModel);
        this._historyList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setText(SortShuttlePanel.this.getSortString((ArrayList)object, true));
                return jLabel;
            }
        });
        this._historyList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SortShuttlePanel.this.applyPrevSort(raptorGridTable.getGridModel().getGridColumns());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SortShuttlePanel.this.applyPrevSort(raptorGridTable.getGridModel().getGridColumns());
                }
            }
        });
        this._historySelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SortShuttlePanel.this.applyPrevSort(raptorGridTable.getGridModel().getGridColumns());
            }
        });
        this._historyDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = SortShuttlePanel.this._historyList.getSelectedValues();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object : objectArray) {
                    ArrayList arrayList2 = (ArrayList)object;
                    arrayList.add(SortShuttlePanel.this.getSortString(arrayList2, false));
                    ((DefaultListModel)SortShuttlePanel.this._historyList.getModel()).removeElement(object);
                }
                RaptorGridPersistedSettings.deletePersistentSettings(raptorGridTable, RaptorGridPersistedSettings.GridSettings.SORT_CLAUSES, arrayList);
                if (SortShuttlePanel.this._historyList.getModel().getSize() == 0) {
                    for (GridColumn gridColumn : raptorGridTable.getGridModel().getGridColumns()) {
                        gridColumn.setSortParameter(null);
                    }
                    SortShuttlePanel.this.init(raptorGridTable.getGridModel().getGridColumns());
                }
            }
        });
        this._historyDeleteAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                int n2 = SortShuttlePanel.this._historyList.getModel().getSize() - 1;
                if (n2 >= 0) {
                    SortShuttlePanel.this._historyList.setSelectionInterval(n, n2);
                    Object[] objectArray = SortShuttlePanel.this._historyList.getSelectedValues();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Object object : objectArray) {
                        ArrayList arrayList2 = (ArrayList)object;
                        arrayList.add(SortShuttlePanel.this.getSortString(arrayList2, false));
                        ((DefaultListModel)SortShuttlePanel.this._historyList.getModel()).removeElement(object);
                    }
                    RaptorGridPersistedSettings.deletePersistentSettings(raptorGridTable, RaptorGridPersistedSettings.GridSettings.SORT_CLAUSES, arrayList);
                    if (SortShuttlePanel.this._historyList.getModel().getSize() == 0) {
                        for (GridColumn gridColumn : raptorGridTable.getGridModel().getGridColumns()) {
                            gridColumn.setSortParameter(null);
                        }
                        SortShuttlePanel.this.init(raptorGridTable.getGridModel().getGridColumns());
                    }
                }
            }
        });
    }

    private String getSortString(ArrayList<Pair<GridColumn, GridColumnSortParameter>> arrayList, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<GridColumn, GridColumnSortParameter> pair : arrayList) {
            GridColumn gridColumn = (GridColumn)pair.getFirst();
            GridColumnSortParameter gridColumnSortParameter = (GridColumnSortParameter)pair.getSecond();
            if (bl) {
                stringBuilder.append(gridColumn.getOriginal() + " ");
            } else {
                stringBuilder.append(this._gridCols.indexOf(gridColumn) + 1 + " ");
            }
            stringBuilder.append(gridColumnSortParameter.getSortDir().toString());
            if (gridColumnSortParameter.getNullsOption() != GridColumnSortParameter.NullsOption.NONE) {
                stringBuilder.append(" " + gridColumnSortParameter.getNullsOption().toString());
            }
            stringBuilder.append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2).toString();
    }

    @Override
    protected void createGUI() throws Exception {
        super.createGUI();
        this._rdbAscending = new JRadioButton();
        this._rdbAscending.setSelected(true);
        this._rdbDescending = new JRadioButton();
        this._cbxNullFirst = new JCheckBox();
        this._cbxNullLast = new JCheckBox();
        this._rdbAscending.setText(Messages.getString("SortShuttlePanel.0"));
        this._rdbDescending.setText(Messages.getString("SortShuttlePanel.1"));
        this._cbxNullFirst.setText(Messages.getString("SortShuttlePanel.2"));
        this._cbxNullLast.setText(Messages.getString("SortShuttlePanel.3"));
        MyActionListener myActionListener = new MyActionListener();
        this._rdbAscending.addActionListener(myActionListener);
        this._rdbDescending.addActionListener(myActionListener);
        this._cbxNullFirst.addActionListener(myActionListener);
        this._cbxNullLast.addActionListener(myActionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rdbAscending);
        buttonGroup.add(this._rdbDescending);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._rdbAscending, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._rdbDescending, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._cbxNullFirst, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._cbxNullLast, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(25, 5, 5, 5), 0, 0));
        this._historyList = new JList();
        this._historyList.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JScrollPane jScrollPane = new JScrollPane(this._historyList, 20, 30);
        HeaderPanel headerPanel = new HeaderPanel((JComponent)jScrollPane, true);
        Header header = headerPanel.getHeader();
        header.setText(Messages.getString("SortShuttlePanel.8"));
        header.setLevel(Header.Level.SUB);
        header.setExpanded(false);
        this._historyDeleteButton = new HyperlinkButton(Messages.getString("SortShuttlePanel.9"));
        this._historyDeleteAllButton = new HyperlinkButton(Messages.getString("SortShuttlePanel.10"));
        this._historySelectButton = new HyperlinkButton(Messages.getString("SortShuttlePanel.11"));
        header.addActionControl((Component)this._historyDeleteButton);
        header.addActionControl((Component)this._historyDeleteAllButton);
        header.addActionControl((Component)this._historySelectButton);
        this.add((Component)headerPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void init(List<GridColumn> list) {
        if (list != null) {
            this._gridCols = list;
            this.mdlFrom.removeAllElements();
            this.mdlTo.removeAllElements();
            ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
            for (GridColumn gridColumn : list) {
                if (!gridColumn.isSortable()) continue;
                if (gridColumn.getSortParameter() != null) {
                    arrayList.add(gridColumn);
                    continue;
                }
                this.mdlFrom.addElement(gridColumn);
            }
            Collections.sort(arrayList);
            for (GridColumn<Object> gridColumn : arrayList) {
                this.mdlTo.addElement(gridColumn);
            }
            this.lstFrom.setModel(this.mdlFrom);
            this.lstTo.setModel(this.mdlTo);
            this.lstTo.setSelectedIndex(0);
            this.shuttle.setEnabled(true);
            this.lstFrom.setEnabled(true);
            this.lstTo.setEnabled(true);
            this.shuttle.validate();
            this.shuttle.addShuttleListener((ShuttleListener)new MyShuttleListener());
            this.lstTo.addListSelectionListener(new MyListSelectionListener());
        }
    }

    private void removeSortParam() {
        List list = this.getFromList();
        for (GridColumn gridColumn : list) {
            gridColumn.setSortParameter(null);
        }
    }

    private void assignSortOrder() {
        List list = this.getToList();
        for (int i = 0; i < list.size(); ++i) {
            GridColumnSortParameter gridColumnSortParameter = ((GridColumn)list.get(i)).getSortParameter();
            if (gridColumnSortParameter != null) {
                gridColumnSortParameter.setSortOrder(i + 1);
                continue;
            }
            ((GridColumn)list.get(i)).setSortParameter(new GridColumnSortParameter(i + 1, this._rdbAscending.isSelected() ? GridColumnSortParameter.SortDir.ASCENDING : GridColumnSortParameter.SortDir.DESCENDING, this.getNullsOption()));
        }
    }

    public void supportsOrderingNulls(boolean bl) {
        this._cbxNullFirst.setEnabled(bl);
        this._cbxNullLast.setEnabled(bl);
    }

    private void setButtonState() {
        if (this.lstTo.getSelectedIndex() != -1) {
            GridColumn gridColumn = (GridColumn)this.mdlTo.get(this.lstTo.getSelectedIndex());
            boolean bl = gridColumn.getSortParameter().getSortDir() == GridColumnSortParameter.SortDir.ASCENDING;
            this._rdbAscending.setSelected(bl);
            this._rdbDescending.setSelected(!bl);
            GridColumnSortParameter.NullsOption nullsOption = gridColumn.getSortParameter().getNullsOption();
            if (nullsOption == GridColumnSortParameter.NullsOption.FIRST) {
                this._cbxNullFirst.setSelected(true);
                this._cbxNullFirst.setEnabled(true);
                this._cbxNullLast.setEnabled(false);
                this._cbxNullLast.setSelected(false);
            } else if (nullsOption == GridColumnSortParameter.NullsOption.LAST) {
                this._cbxNullLast.setSelected(true);
                this._cbxNullLast.setEnabled(true);
                this._cbxNullFirst.setEnabled(false);
                this._cbxNullFirst.setSelected(false);
            } else if (nullsOption == GridColumnSortParameter.NullsOption.NONE) {
                this._cbxNullLast.setSelected(false);
                this._cbxNullFirst.setSelected(false);
                this._cbxNullLast.setEnabled(true);
                this._cbxNullFirst.setEnabled(true);
            }
        }
    }

    private GridColumnSortParameter.NullsOption getNullsOption() {
        boolean bl = this._cbxNullFirst.isEnabled() && this._cbxNullFirst.isSelected();
        boolean bl2 = this._cbxNullLast.isEnabled() && this._cbxNullLast.isSelected();
        GridColumnSortParameter.NullsOption nullsOption = null;
        nullsOption = bl ? GridColumnSortParameter.NullsOption.FIRST : (bl2 ? GridColumnSortParameter.NullsOption.LAST : GridColumnSortParameter.NullsOption.NONE);
        return nullsOption;
    }

    private void applyPrevSort(List<GridColumn> list) {
        ArrayList arrayList = (ArrayList)this._historyList.getSelectedValue();
        if (arrayList != null) {
            for (GridColumn gridColumn : list) {
                gridColumn.setSortParameter(null);
            }
            for (GridColumn gridColumn : arrayList) {
                GridColumn gridColumn2 = (GridColumn)gridColumn.getFirst();
                GridColumnSortParameter gridColumnSortParameter = (GridColumnSortParameter)gridColumn.getSecond();
                gridColumn2.setSortParameter(gridColumnSortParameter);
            }
            this.init(list);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SortShuttlePanel.this.lstTo.getSelectedIndex() != -1 && !listSelectionEvent.getValueIsAdjusting()) {
                SortShuttlePanel.this.setButtonState();
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            Object object = actionEvent.getSource();
            if (actionEvent.getSource() == SortShuttlePanel.this._cbxNullFirst) {
                SortShuttlePanel.this._cbxNullLast.setEnabled(!SortShuttlePanel.this._cbxNullFirst.isSelected());
                if (SortShuttlePanel.this._cbxNullFirst.isSelected()) {
                    SortShuttlePanel.this._cbxNullLast.setSelected(false);
                }
            }
            if (actionEvent.getSource() == SortShuttlePanel.this._cbxNullLast) {
                SortShuttlePanel.this._cbxNullFirst.setEnabled(!SortShuttlePanel.this._cbxNullLast.isSelected());
                if (SortShuttlePanel.this._cbxNullLast.isSelected()) {
                    SortShuttlePanel.this._cbxNullFirst.setSelected(false);
                }
            }
            for (int n : nArray = SortShuttlePanel.this.lstTo.getSelectedIndices()) {
                if (n == -1) continue;
                GridColumn gridColumn = (GridColumn)SortShuttlePanel.this.mdlTo.get(n);
                GridColumnSortParameter.SortDir sortDir = SortShuttlePanel.this._rdbAscending.isSelected() ? GridColumnSortParameter.SortDir.ASCENDING : GridColumnSortParameter.SortDir.DESCENDING;
                gridColumn.getSortParameter().setSortDir(sortDir);
                GridColumnSortParameter.NullsOption nullsOption = SortShuttlePanel.this.getNullsOption();
                gridColumn.getSortParameter().setNullsOption(nullsOption);
                SortShuttlePanel.this.lstTo.repaint();
            }
        }
    }

    private class MyShuttleListener
    implements ShuttleListener {
        private MyShuttleListener() {
        }

        public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
            SortShuttlePanel.this.assignSortOrder();
            SortShuttlePanel.this.setButtonState();
        }

        public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
            SortShuttlePanel.this.removeSortParam();
        }

        public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
            SortShuttlePanel.this.assignSortOrder();
            SortShuttlePanel.this.setButtonState();
        }
    }
}

