/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridSearchParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Element;

public class RaptorGridPersistedSettings {
    private String m_uniqueName;
    private int[] m_columnWidths;
    private ArrayList<String> sortClauses;
    private List<Object> m_columnPositions;
    private List<RaptorGridSearchParameter> m_searchParams;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"Table-attributes");
    private static final String ROOT_TAG = "TableSettings";

    public String getUniqueName() {
        return this.m_uniqueName;
    }

    public void setUniqueName(String string) {
        this.m_uniqueName = string;
    }

    public void setColumnPositions(List<Object> list) {
        this.m_columnPositions = list;
    }

    public List<Object> getColumnPositions() {
        return this.m_columnPositions;
    }

    public void setSearchParams(List<RaptorGridSearchParameter> list) {
        this.m_searchParams = list;
    }

    public List<RaptorGridSearchParameter> getSearchParams() {
        return this.m_searchParams;
    }

    public int[] getColumnWidths() {
        return this.m_columnWidths;
    }

    public void setColumnWidths(int[] nArray) {
        this.m_columnWidths = nArray;
    }

    public ArrayList<String> getSortClauses() {
        return this.sortClauses;
    }

    public void setSortClauses(ArrayList<String> arrayList) {
        this.sortClauses = arrayList;
    }

    public static URL getPersistedSettingsURL(String string) {
        ExtensionRegistry extensionRegistry;
        URL uRL = null;
        if (ModelUtil.hasLength((String)string) && (extensionRegistry = ExtensionRegistry.getExtensionRegistry()).findExtension("oracle.sqldeveloper") != null) {
            URL uRL2 = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
            uRL = URLFactory.newURL((URL)uRL2, (String)(string.hashCode() + "GridSettings.xml"));
        }
        return uRL;
    }

    public static RaptorGridPersistedSettings loadPersistedSettings(String string) {
        RaptorGridPersistedSettings raptorGridPersistedSettings = null;
        try {
            URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(string);
            if (uRL != null) {
                Object2Dom object2Dom = Object2Dom.newInstance();
                raptorGridPersistedSettings = (RaptorGridPersistedSettings)object2Dom.toObject(uRL, RaptorGridPersistedSettings.class, RaptorGridPersistedSettings.class.getClassLoader());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.0"));
        }
        return raptorGridPersistedSettings;
    }

    public static void savePersistentSettings(RaptorGridTable raptorGridTable) {
        RaptorGridPersistedSettings.savePersistentSettings(raptorGridTable, true);
    }

    public static void savePersistentSettings(RaptorGridTable raptorGridTable, boolean bl) {
        RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.getPersistentSettings(raptorGridTable);
        RaptorGridPersistedSettings.savePersistentSettings(raptorGridTable, bl, raptorGridPersistedSettings);
    }

    public static void savePersistentSettings(RaptorGridTable raptorGridTable, boolean bl, RaptorGridPersistedSettings raptorGridPersistedSettings) {
        RaptorGridPersistedSettings.savePersistentSettings(raptorGridTable.getGridUniqueName(), bl, raptorGridPersistedSettings);
    }

    public static void savePersistentSettings(String string, boolean bl, final RaptorGridPersistedSettings raptorGridPersistedSettings) {
        final URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(string);
        final Object2Dom object2Dom = Object2Dom.newInstance();
        object2Dom.setNamespaceURI(NAMESPACE_URI);
        Thread thread = new Thread("Grid Settings Saver"){

            @Override
            public void run() {
                try {
                    if (uRL != null) {
                        object2Dom.toDocument((Object)raptorGridPersistedSettings, RaptorGridPersistedSettings.ROOT_TAG, uRL);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.1"));
                }
            }
        };
        if (bl) {
            thread.start();
        } else {
            thread.run();
        }
    }

    public static boolean deletePersistentSettings(RaptorGridTable raptorGridTable) {
        return RaptorGridPersistedSettings.deletePersistentSettings(raptorGridTable.getGridUniqueName());
    }

    public static boolean deletePersistentSettings(String string) {
        URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(string);
        if (uRL != null) {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                if (file.exists()) {
                    return file.delete();
                }
                Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.2"));
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean deletePersistentSorts(String string) {
        URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(string);
        if (uRL != null) {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                if (file.exists()) {
                    RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.loadPersistedSettings(string);
                    ArrayList<String> arrayList = raptorGridPersistedSettings.getSortClauses();
                    arrayList.clear();
                    RaptorGridPersistedSettings.savePersistentSettings(string, false, raptorGridPersistedSettings);
                    return true;
                }
                Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.2"));
            }
        }
        return false;
    }

    public static boolean removeLastSort(String string) {
        URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(string);
        if (uRL != null) {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                if (file.exists()) {
                    RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.loadPersistedSettings(string);
                    if (raptorGridPersistedSettings != null) {
                        ArrayList<String> arrayList = raptorGridPersistedSettings.getSortClauses();
                        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) != null) {
                            int n = arrayList.indexOf(null);
                            if (n > -1) {
                                arrayList.remove(n);
                            }
                            arrayList.add(0, null);
                        }
                        RaptorGridPersistedSettings.savePersistentSettings(string, false, raptorGridPersistedSettings);
                        return true;
                    }
                } else {
                    Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.2"));
                }
            }
        }
        return false;
    }

    public static boolean deletePersistentSettings(RaptorGridTable raptorGridTable, GridSettings gridSettings, List list) {
        URL uRL = RaptorGridPersistedSettings.getPersistedSettingsURL(raptorGridTable.getGridUniqueName());
        if (uRL != null) {
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                if (file.exists()) {
                    if (gridSettings == GridSettings.ALL) {
                        return file.delete();
                    }
                    if (gridSettings == GridSettings.SORT_CLAUSES) {
                        RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.getPersistentSettings(raptorGridTable);
                        ArrayList<String> arrayList = raptorGridPersistedSettings.getSortClauses();
                        if (list != null) {
                            for (Object e : list) {
                                arrayList.remove(e.toString());
                            }
                            RaptorGridPersistedSettings.savePersistentSettings(raptorGridTable, false, raptorGridPersistedSettings);
                        }
                    }
                } else {
                    Logger.getLogger(RaptorGridPersistedSettings.class.getClass().getName()).info(Messages.getString("RaptorGridPersistedSettings.2"));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected static RaptorGridPersistedSettings getPersistentSettings(RaptorGridTable raptorGridTable) {
        String string;
        ArrayList<String> arrayList;
        int n;
        RaptorGridPersistedSettings raptorGridPersistedSettings = new RaptorGridPersistedSettings();
        raptorGridPersistedSettings.setUniqueName(raptorGridTable.getGridUniqueName());
        int[] nArray = new int[raptorGridTable.getModel().getColumnCount()];
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < raptorGridTable.getModel().getColumnCount(); ++n) {
            int n2 = raptorGridTable.convertColumnIndexToView(n);
            arrayList = null;
            if (n2 != -1) {
                arrayList = raptorGridTable.getTableHeader().getColumnModel().getColumn(n2);
            }
            nArray[n] = arrayList == null ? 0 : ((TableColumn)((Object)arrayList)).getPreferredWidth();
        }
        for (n = 0; n < raptorGridTable.getColumnModel().getColumnCount(); ++n) {
            TableColumn tableColumn = raptorGridTable.getColumnModel().getColumn(n);
            arrayList = tableColumn.getIdentifier();
            arrayList2.add(arrayList);
        }
        raptorGridPersistedSettings.setColumnWidths(nArray);
        raptorGridPersistedSettings.setColumnPositions(arrayList2);
        raptorGridPersistedSettings.setSearchParams(raptorGridTable.getSearchParams(true));
        ArrayList<String> arrayList3 = new ArrayList<String>();
        RaptorGridPersistedSettings raptorGridPersistedSettings2 = RaptorGridPersistedSettings.loadPersistedSettings(raptorGridTable.getGridUniqueName());
        arrayList = null;
        if (raptorGridPersistedSettings2 != null) {
            arrayList = raptorGridPersistedSettings2.getSortClauses();
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3.contains(string = raptorGridTable.getSortString())) {
            arrayList3.remove(string);
        }
        arrayList3.add(0, string);
        raptorGridPersistedSettings.setSortClauses(arrayList3);
        return raptorGridPersistedSettings;
    }

    protected static void setPersistentSettings(RaptorGridTable raptorGridTable, RaptorGridPersistedSettings raptorGridPersistedSettings) {
        int n;
        List<Object> list = raptorGridPersistedSettings.getColumnPositions();
        try {
            if (list != null) {
                Enumeration<TableColumn> enumeration = raptorGridTable.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    tableColumn.getIdentifier();
                }
                for (n = 0; n < list.size(); ++n) {
                    int n2 = raptorGridTable.getColumnModel().getColumnIndex(list.get(n));
                    if (n2 == n) continue;
                    raptorGridTable.getColumnModel().moveColumn(n2, n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < raptorGridPersistedSettings.getColumnWidths().length; ++i) {
            n = raptorGridTable.convertColumnIndexToView(i);
            TableColumn tableColumn = null;
            if (n != -1) {
                tableColumn = raptorGridTable.getTableHeader().getColumnModel().getColumn(n);
            }
            if (tableColumn == null) continue;
            int n3 = raptorGridPersistedSettings.getColumnWidths()[i];
            if (n3 <= 15) {
                n3 = ColumnAutoSizer.getMaxColumnWidth(raptorGridTable, tableColumn, ColumnAutoSizer.AUTO_FIT_ON_HEADER, 1);
            }
            tableColumn.setPreferredWidth(n3);
        }
        List<RaptorGridSearchParameter> list2 = raptorGridPersistedSettings.getSearchParams();
        if (list2 != null) {
            for (RaptorGridSearchParameter raptorGridSearchParameter : list2) {
                raptorGridTable.addHighLightParam(raptorGridSearchParameter);
            }
        }
    }

    public static void applyPersistentSettings(RaptorGridTable raptorGridTable) {
        RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.loadPersistedSettings(raptorGridTable.getGridUniqueName());
        if (raptorGridPersistedSettings != null) {
            RaptorGridPersistedSettings.setPersistentSettings(raptorGridTable, raptorGridPersistedSettings);
        } else {
            RaptorGridPersistedSettings.applyDefaultSettings(raptorGridTable);
        }
    }

    protected static void applyDefaultSettings(RaptorGridTable raptorGridTable) {
        ColumnAutoSizer.autoResizeTable(raptorGridTable, ColumnAutoSizer.AUTO_FIT_OPTIMUM);
    }

    public static void main(String[] stringArray) {
        URL uRL = null;
        try {
            uRL = new File("c:/gridsettings.xml").toURI().toURL();
            RaptorGridPersistedSettings raptorGridPersistedSettings = new RaptorGridPersistedSettings();
            RaptorGridSearchParameter raptorGridSearchParameter = new RaptorGridSearchParameter();
            raptorGridSearchParameter.setColor(Color.RED);
            raptorGridSearchParameter.setSearchString("raghu");
            raptorGridPersistedSettings.setSearchParams(Arrays.asList(raptorGridSearchParameter));
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            try {
                object2Dom.toDocument((Object)raptorGridPersistedSettings, ROOT_TAG, uRL);
                raptorGridPersistedSettings = (RaptorGridPersistedSettings)object2Dom.toObject(uRL);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static {
        Object2Dom.registerConverter((ToDomConverter)new ColorConverter());
    }

    public static enum GridSettings {
        COL_WIDTHS,
        COL_ORDER,
        SORT_CLAUSES,
        SEARCH_PARAM,
        ALL;

    }

    private static class ColorConverter
    implements ToDomConverter {
        private ColorConverter() {
        }

        public boolean toElement(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
            if (Color.class.isAssignableFrom(clazz)) {
                String string = String.valueOf(((Color)objectWrapper.getObject()).getRGB());
                element.appendChild(element.getOwnerDocument().createTextNode(string));
                return true;
            }
            return false;
        }

        public boolean toObject(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
            if (Color.class.isAssignableFrom(clazz)) {
                String string = element.getFirstChild().getNodeValue();
                objectWrapper.setObject((Object)new Color(Integer.parseInt(string), true));
                return true;
            }
            return false;
        }
    }
}

