/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class TextAutoCompleter {
    protected JList list = new JList();
    protected JPopupMenu popup = new JPopupMenu();
    protected JTextComponent textComp;
    protected static final String TEXTAUTOCOMPLETER = "TEXTAUTOCOMPLETER";
    static Action acceptAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TextAutoCompleter textAutoCompleter = (TextAutoCompleter)jComponent.getClientProperty(TextAutoCompleter.TEXTAUTOCOMPLETER);
            textAutoCompleter.popup.setVisible(false);
            textAutoCompleter.acceptListItem(textAutoCompleter.list.getSelectedValue());
            textAutoCompleter.popup.setVisible(false);
        }
    };
    DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (TextAutoCompleter.this.textComp.hasFocus()) {
                TextAutoCompleter.this.showPopup();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (TextAutoCompleter.this.textComp.hasFocus()) {
                TextAutoCompleter.this.showPopup();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    static Action showAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TextAutoCompleter textAutoCompleter = (TextAutoCompleter)jComponent.getClientProperty(TextAutoCompleter.TEXTAUTOCOMPLETER);
            if (jComponent.isEnabled()) {
                if (textAutoCompleter.popup.isVisible()) {
                    textAutoCompleter.selectNextPossibleValue();
                } else {
                    textAutoCompleter.showPopup();
                }
            }
        }
    };
    static Action upAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TextAutoCompleter textAutoCompleter = (TextAutoCompleter)jComponent.getClientProperty(TextAutoCompleter.TEXTAUTOCOMPLETER);
            if (jComponent.isEnabled() && textAutoCompleter.popup.isVisible()) {
                textAutoCompleter.selectPreviousPossibleValue();
            }
        }
    };
    static Action hidePopupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TextAutoCompleter textAutoCompleter = (TextAutoCompleter)jComponent.getClientProperty(TextAutoCompleter.TEXTAUTOCOMPLETER);
            if (jComponent.isEnabled()) {
                textAutoCompleter.popup.setVisible(false);
            }
        }
    };

    public TextAutoCompleter(JTextComponent jTextComponent) {
        this.textComp = jTextComponent;
        this.textComp.putClientProperty(TEXTAUTOCOMPLETER, this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(null);
        this.list.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(jScrollPane);
        if (this.textComp instanceof JTextField) {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.textComp.getDocument().addDocumentListener(this.documentListener);
        } else {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(32, 2), 0);
        }
        this.textComp.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textComp.registerKeyboardAction(hidePopupAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                TextAutoCompleter.this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TextAutoCompleter.this.popup.setVisible(false);
                TextAutoCompleter.this.acceptListItem(TextAutoCompleter.this.list.getSelectedValue());
                TextAutoCompleter.this.popup.setVisible(false);
            }
        });
        this.list.setRequestFocusEnabled(false);
    }

    private void showPopup() {
        this.popup.setVisible(false);
        if (this.textComp.isEnabled() && this.updateListData() && this.list.getModel().getSize() != 0) {
            if (!(this.textComp instanceof JTextField)) {
                this.textComp.getDocument().addDocumentListener(this.documentListener);
            }
            this.textComp.registerKeyboardAction(acceptAction, KeyStroke.getKeyStroke(10, 0), 0);
            int n = this.list.getModel().getSize();
            this.list.setVisibleRowCount(n < 10 ? n : 10);
            int n2 = 0;
            try {
                int n3 = Math.min(this.textComp.getCaret().getDot(), this.textComp.getCaret().getMark());
                n2 = this.textComp.getUI().modelToView((JTextComponent)this.textComp, (int)n3).x;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.popup.show(this.textComp, n2, this.textComp.getHeight());
        } else {
            this.popup.setVisible(false);
        }
        this.textComp.requestFocusInWindow();
    }

    protected void selectNextPossibleValue() {
        int n = this.list.getSelectedIndex();
        if (n < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(n + 1);
            this.list.ensureIndexIsVisible(n + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    protected abstract boolean updateListData();

    protected abstract void acceptListItem(Object var1);

    protected abstract Object[] getPullDownList();
}

