/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.structured;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.structured.MutableStructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StructuredMetadataUtils {
    public static final StructuredMetadataBean createStructuredMetadata(Element element) {
        return StructuredMetadataUtils.createStructuredMetadata(element, null);
    }

    public static final StructuredMetadataBean createStructuredMetadata(Element element, XmlKey ownerNSKey) {
        String textContent;
        MutableStructuredMetadataBean bean = new MutableStructuredMetadataBean(element.getNamespaceURI(), DomUtils.getLocalName(element));
        bean.setOwnerNS(ownerNSKey);
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null) {
            int numAttrs = attrMap.getLength();
            for (int i = 0; i < numAttrs; ++i) {
                String value;
                Attr attr = (Attr)attrMap.item(i);
                if (attr == null || (value = attr.getValue()) == null) continue;
                bean.addProperty(attr.getNamespaceURI(), DomUtils.getLocalName(attr), value.trim());
            }
        }
        if ((textContent = element.getTextContent()) != null) {
            bean.setValue(textContent.trim());
        }
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!DomUtils.isElement(currentChild)) continue;
            Element childElement = (Element)currentChild;
            bean.addChild(StructuredMetadataUtils.createStructuredMetadata(childElement, ownerNSKey));
        }
        return bean;
    }
}

