/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneMetadataManager {
    private HashMap<String, List<URL>> _urlMap = new HashMap();
    private HashMap<String, SoftReference<MetadataProvider>> _providerMap = new HashMap();
    private static StandaloneMetadataManager _singleton = null;
    private static Object _mapLock = new Object();

    public static StandaloneMetadataManager getInstance() {
        if (_singleton == null) {
            _singleton = new StandaloneMetadataManager();
        }
        return _singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStandaloneMetadataURLs(String id, List<URL> urls) {
        Object object = _mapLock;
        synchronized (object) {
            this._urlMap.put(id, urls);
            if (this._providerMap.containsKey(id)) {
                this._providerMap.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataProvider getMetadataProvider(String id) {
        MetadataProvider provider = null;
        Object object = _mapLock;
        synchronized (object) {
            if (this._providerMap.containsKey(id)) {
                SoftReference<MetadataProvider> softRef = this._providerMap.get(id);
                provider = softRef.get();
            }
            if (provider == null && this._urlMap.containsKey(id)) {
                try {
                    List<URL> urls = this._urlMap.get(id);
                    provider = StandaloneMetadataProvider.create(urls);
                    SoftReference<MetadataProvider> softRef = new SoftReference<MetadataProvider>(provider);
                    this._providerMap.put(id, softRef);
                }
                catch (StandaloneMetadataFileException smfe) {
                    smfe.printStackTrace();
                }
            }
        }
        return provider;
    }

    private StandaloneMetadataManager() {
    }
}

