/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileListener;

public class StandaloneMetadataFileRegistry {
    private HashMap _standaloneMetadataFileMap = new HashMap();
    private ListenerManager _listeners = new ListenerManager();

    public void clearRegistry() {
        this._standaloneMetadataFileMap.clear();
    }

    public void addStandaloneMetadataFile(StandaloneMetadataFile standaloneMetadataFile) throws StandaloneMetadataFileException {
        if (standaloneMetadataFile != null) {
            String targetNamespace = standaloneMetadataFile.getTargetNamespace();
            if (!this._standaloneMetadataFileMap.containsKey(targetNamespace)) {
                this._standaloneMetadataFileMap.put(targetNamespace, standaloneMetadataFile);
                Enumeration listeners = this._listeners.getListeners();
                if (listeners != null) {
                    while (listeners.hasMoreElements()) {
                        StandaloneMetadataFileListener l = (StandaloneMetadataFileListener)listeners.nextElement();
                        l.fileAdded(standaloneMetadataFile);
                    }
                }
            } else {
                StandaloneMetadataFile file = (StandaloneMetadataFile)this._standaloneMetadataFileMap.get(targetNamespace);
                throw new StandaloneMetadataFileException("StandaloneMetadataFileRegistry:: Unable to register StandaloneMetadataFile " + standaloneMetadataFile.getLocation() + " because StandaloneMetadataFile " + file.getLocation() + " is already regsitered for namespace " + targetNamespace);
            }
        }
    }

    public void removeStandaloneMetadataFile(StandaloneMetadataFile standaloneMetadataFile) throws StandaloneMetadataFileException {
        if (standaloneMetadataFile != null) {
            String targetNamespace = standaloneMetadataFile.getTargetNamespace();
            if (this._standaloneMetadataFileMap.containsKey(targetNamespace)) {
                this._standaloneMetadataFileMap.remove(targetNamespace);
                Enumeration listeners = this._listeners.getListeners();
                while (listeners.hasMoreElements()) {
                    StandaloneMetadataFileListener l = (StandaloneMetadataFileListener)listeners.nextElement();
                    l.fileRemoved(standaloneMetadataFile);
                }
            } else {
                throw new StandaloneMetadataFileException("StandaloneMetadataFileRegistry:: The StandaloneMetadataFile was not registered " + targetNamespace);
            }
        }
    }

    public StandaloneMetadataFile getStandaloneMetadataFileForNamespace(String targetNamespace) {
        StandaloneMetadataFile result = (StandaloneMetadataFile)this._standaloneMetadataFileMap.get(targetNamespace);
        return result;
    }

    public StandaloneMetadataFile[] getStandaloneMetadataFiles() {
        Object[] array;
        Collection c = this._standaloneMetadataFileMap.values();
        Object[] objectArray = array = c == null ? null : c.toArray();
        if (array == null) {
            return null;
        }
        StandaloneMetadataFile[] standaloneMetadataFiles = new StandaloneMetadataFile[array.length];
        System.arraycopy(array, 0, standaloneMetadataFiles, 0, array.length);
        return standaloneMetadataFiles;
    }

    public void addFileListener(StandaloneMetadataFileListener l) {
        this._listeners.addListener((EventListener)l);
    }

    public void removeFileListener(StandaloneMetadataFileListener l) {
        this._listeners.removeListener((EventListener)l);
    }
}

