/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.standalone.AttributeMetadata;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.MetadataComponent;
import oracle.bali.xml.metadata.standalone.MetadataGroup;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import oracle.bali.xml.metadata.util.PseudoXmlKeyUtil;
import oracle.bali.xml.util.XmlNameUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementMetadata
implements MetadataComponent {
    private static final String _INCLUDE_GROUP_NAME = "includeGroup";
    private static final String _FIXED_ATTRIBUTE_NAME = "fixedAttribute";
    private static final String _PSEUDO_XML_KEYS_NAME = "pseudoXmlKeys";
    private static final String _ELEMENT_NAME_ATTR = "elementName";
    private static final String _ELEMENT_NAMESPACE_ATTR = "elementNamespace";
    private static final String _NAME_ATTR = "name";
    private String _targetNamespace;
    private String _elementLocalName;
    private QualifiedName _elementQualifiedName;
    private GrammarMetadata _grammarMetadata;
    private HashMap _metadataMap;
    private HashMap<QualifiedName, ElementMetadata> _elementMetadataMap = new HashMap();
    private HashMap<QualifiedName, AttributeMetadata> _attributeMetadataMap = new HashMap();
    private Map _fixedAttributeMetadata = Collections.EMPTY_MAP;
    private LinkedHashSet<String> _includedGroupNames = new LinkedHashSet(2);
    private PseudoXmlKeyUtil _pxku;
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata");
    private static final String _ERROR_LOCAL_NAME = "error";
    public static final String ELEMENT_METADATA_NAME = "elementMetadata";

    public ElementMetadata(String targetNamespace, Node elementMetadataNode, GrammarMetadata grammarMetadata) {
        this._targetNamespace = targetNamespace;
        this._grammarMetadata = grammarMetadata;
        this._metadataMap = new HashMap(grammarMetadata.getSharedElementMetadata());
        this._buildMetadataMaps(elementMetadataNode);
    }

    public ElementMetadata getElementMetadataByName(String elementLocalName) {
        return this.getElementMetadataByName(QualifiedName.getQualifiedName(this._targetNamespace, elementLocalName));
    }

    public ElementMetadata getElementMetadataByName(QualifiedName elementName) {
        ElementMetadata elementMetadata;
        block1: {
            MetadataGroup group;
            elementMetadata = this._elementMetadataMap.get(elementName);
            if (elementMetadata != null) break block1;
            Iterator<MetadataGroup> iterator = this.getMetadataGroups().iterator();
            while (iterator.hasNext() && (elementMetadata = (group = iterator.next()).getElementMetadataByName(elementName)) == null) {
            }
        }
        return elementMetadata;
    }

    public AttributeMetadata getAttributeMetadataByName(String attributeLocalName) {
        return this.getAttributeMetadataByName(QualifiedName.getQualifiedName(null, attributeLocalName));
    }

    public AttributeMetadata getAttributeMetadataByName(QualifiedName attributeName) {
        AttributeMetadata attributeMetadata;
        block1: {
            MetadataGroup group;
            attributeMetadata = this._attributeMetadataMap.get(attributeName);
            if (attributeMetadata != null) break block1;
            Iterator<MetadataGroup> iterator = this.getMetadataGroups().iterator();
            while (iterator.hasNext() && (attributeMetadata = (group = iterator.next()).getAttributeMetadataByName(attributeName)) == null) {
            }
        }
        return attributeMetadata;
    }

    public Map<QualifiedName, ElementMetadata> getElementMetadataMap() {
        return this._elementMetadataMap;
    }

    public Map<QualifiedName, AttributeMetadata> getAttributeMetadataMap() {
        return this._attributeMetadataMap;
    }

    public List<MetadataGroup> getMetadataGroups() {
        LinkedList<MetadataGroup> metadataGroups = new LinkedList<MetadataGroup>();
        for (String name : this._includedGroupNames) {
            MetadataGroup group = this._grammarMetadata.getMetadataGroupByName(name);
            if (group == null) continue;
            metadataGroups.add(group);
        }
        return metadataGroups;
    }

    @Override
    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    @Override
    public Map getMetadataMap() {
        return this._metadataMap;
    }

    public String getElementName() {
        return this._elementLocalName;
    }

    public QualifiedName getElementQualifiedName() {
        return this._elementQualifiedName;
    }

    public Map getFixedAttributeMetadataMap(String attrNamespace, String attrName, String attrValue) {
        QualifiedName attrQName;
        Map valueMap;
        Map metadataMap = Collections.EMPTY_MAP;
        if (attrName != null && attrValue != null && (valueMap = (Map)this._fixedAttributeMetadata.get(attrQName = QualifiedName.getQualifiedName(attrNamespace, attrName))) != null && (metadataMap = (Map)valueMap.get(attrValue)) == null) {
            metadataMap = Collections.EMPTY_MAP;
        }
        return metadataMap;
    }

    public Collection<String> getPseudoXmlKeyIdentifiers() {
        Collection<String> identifers = Collections.emptyList();
        if (this._pxku != null) {
            identifers = this._pxku.getPseudoXmlKeyIdentifiers();
        }
        return identifers;
    }

    public Map getPseudoXmlKeyMetadataMap(String identifier) {
        Map metadataMap = Collections.EMPTY_MAP;
        if (this._pxku != null) {
            metadataMap = this._pxku.getMetadataMap(identifier);
        }
        return metadataMap;
    }

    private void _buildMetadataMaps(Node elementMetadataNode) {
        Element elementMetadataElement = (Element)elementMetadataNode;
        this._elementLocalName = elementMetadataElement.getAttributeNS(null, _ELEMENT_NAME_ATTR);
        try {
            XmlNameUtils.validateName(this._elementLocalName);
        }
        catch (Exception e) {
            _LOGGER.log(Level.INFO, "Illegal element name " + this._elementLocalName + " found in standalone metadata file for targetNamespace: " + this._targetNamespace);
            this._elementLocalName = _ERROR_LOCAL_NAME;
        }
        String alternateNamespace = null;
        Attr elementNamespaceAttr = elementMetadataElement.getAttributeNodeNS(null, _ELEMENT_NAMESPACE_ATTR);
        if (elementNamespaceAttr != null) {
            alternateNamespace = DomUtils.getTextNodeValue(elementNamespaceAttr);
        }
        if (alternateNamespace != null && alternateNamespace.length() == 0) {
            this._elementQualifiedName = QualifiedName.getQualifiedName(null, this._elementLocalName);
        } else if (alternateNamespace != null && alternateNamespace.length() > 0) {
            try {
                XmlNameUtils.validateNamespace(alternateNamespace);
            }
            catch (Exception e) {
                _LOGGER.log(Level.INFO, "Illegal value for elementNamespace attribute " + alternateNamespace + " found in standalone metadata file for targetNamespace: " + this._targetNamespace);
                alternateNamespace = "error:invalid-namespace";
            }
            this._elementQualifiedName = QualifiedName.getQualifiedName(alternateNamespace, this._elementLocalName);
        } else {
            this._elementQualifiedName = QualifiedName.getQualifiedName(this._targetNamespace, this._elementLocalName);
        }
        for (Node currNode = elementMetadataNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getNodeType() != 1) continue;
            String localName = currNode.getLocalName();
            if (localName.equals(ELEMENT_METADATA_NAME)) {
                OracleStandaloneMetadataFactory.addElementMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, this._elementMetadataMap);
                continue;
            }
            if (localName.equals("attributeMetadata")) {
                OracleStandaloneMetadataFactory.addAttributeMetadataToMap(this._targetNamespace, currNode, this._grammarMetadata, false, this._attributeMetadataMap);
                continue;
            }
            if (localName.equals(_INCLUDE_GROUP_NAME)) {
                this._addIncludedGroupToList(currNode);
                continue;
            }
            if (localName.equals(_FIXED_ATTRIBUTE_NAME)) {
                this._fixedAttributeMetadata = MetadataProviderUtils.processFixedAttributeElement((Element)currNode);
                continue;
            }
            if (localName.equals(_PSEUDO_XML_KEYS_NAME)) {
                this._pxku = new PseudoXmlKeyUtil((Element)currNode);
                continue;
            }
            MetadataProviderUtils.addMetadataToMap(this._metadataMap, (Element)currNode);
        }
    }

    private void _addIncludedGroupToList(Node includeGroupNode) {
        String groupName = ((Element)includeGroupNode).getAttribute(_NAME_ATTR);
        this._includedGroupNames.add(groupName);
    }
}

