/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.common.ConstrainingFacetImpl;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleConstrainingFacet;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;

public class OracleSimpleType
implements SimpleType {
    private static final Logger _LOGGER = Logger.getLogger(OracleSimpleType.class.getName());
    private OracleSchemaFactory _factory = null;
    private XSDSimpleType _xsdSimpleType = null;
    private volatile OracleSimpleType _builtInType = null;
    private volatile OracleSimpleType _primitiveType = null;
    private volatile OracleSimpleType _listItemType = null;
    private volatile List<SimpleType> _unionMemberTypes = null;
    private volatile Collection<ConstrainingFacet> _constrainingFacets = null;
    private volatile Annotation _annotation = null;

    public String getName() {
        String name = this._xsdSimpleType.getName();
        if (name != null && name.length() == 0) {
            name = null;
        }
        return name;
    }

    public String getTargetNamespace() {
        String tns = this._xsdSimpleType.getTargetNS();
        if (tns != null && tns.length() == 0) {
            return null;
        }
        return tns == null ? "http://www.w3.org/2001/XMLSchema" : tns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleType getBuiltInBaseType() {
        if (this._builtInType == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._builtInType == null) {
                    try {
                        XSDSimpleType builtInType;
                        String typeLocalName;
                        XSDSimpleType testType;
                        XSDSimpleType oldType = null;
                        Hashtable builtInTypes = XSDSimpleType.getBuiltInDatatypes();
                        for (testType = this._xsdSimpleType; testType != null && testType != oldType && ((typeLocalName = testType.getName()) == null || (builtInType = (XSDSimpleType)builtInTypes.get(typeLocalName)) == null || testType != builtInType); testType = testType.getBase()) {
                            oldType = testType;
                        }
                        if (testType != null) {
                            this._builtInType = this._factory.getSimpleTypeWrapper(testType);
                        }
                    }
                    catch (Exception e) {
                        this._builtInType = null;
                    }
                }
            }
        }
        return this._builtInType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleType getPrimitiveType() {
        if (this._primitiveType == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._primitiveType == null) {
                    try {
                        int primitiveIndex = this._xsdSimpleType.getBasicType();
                        String primitiveTypeName = XSDTypeConstants.sTypes[primitiveIndex];
                        Hashtable builtInTypes = XSDSimpleType.getBuiltInDatatypes();
                        XSDSimpleType xsdPrimitiveType = (XSDSimpleType)builtInTypes.get(primitiveTypeName);
                        this._primitiveType = this._factory.getSimpleTypeWrapper(xsdPrimitiveType);
                    }
                    catch (Exception e) {
                        this._primitiveType = null;
                    }
                }
            }
        }
        return this._primitiveType;
    }

    public int getVariety() {
        String xsdVariety = this._xsdSimpleType.getVariety();
        if ("atomic".equals(xsdVariety)) {
            return 0;
        }
        if ("list".equals(xsdVariety)) {
            return 1;
        }
        if ("union".equals(xsdVariety)) {
            return 2;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getConstrainingFacets() {
        if (this._constrainingFacets == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._constrainingFacets == null) {
                    List<Object> foundFacets = new ArrayList(3);
                    XSDConstrainingFacet[] xsdFacets = this._xsdSimpleType.getFacets();
                    if (xsdFacets != null) {
                        XSDConstrainingFacet wsFacet = null;
                        for (int i = 0; i < xsdFacets.length; ++i) {
                            XSDConstrainingFacet xsdFacet = xsdFacets[i];
                            if (xsdFacet == null) continue;
                            if (xsdFacet.getFacetId() == 12) {
                                wsFacet = xsdFacet;
                                continue;
                            }
                            foundFacets.add(new OracleConstrainingFacet(xsdFacet));
                        }
                        String bogusWSValue = this._xsdSimpleType.getWSFacetValue();
                        if (bogusWSValue == null || bogusWSValue.length() == 0) {
                            if (wsFacet != null) {
                                foundFacets.add(new OracleConstrainingFacet(wsFacet));
                            }
                        } else {
                            foundFacets.add(new ConstrainingFacetImpl("whitespace", 12, bogusWSValue, null));
                        }
                    }
                    if (foundFacets.isEmpty()) {
                        foundFacets = Collections.emptyList();
                    }
                    this._constrainingFacets = foundFacets;
                }
            }
        }
        return this._constrainingFacets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnionMemberTypes() {
        if (this._unionMemberTypes == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._unionMemberTypes == null) {
                    List<Object> foundMemberTypes = new ArrayList(2);
                    Vector xsdMembers = this._xsdSimpleType.getMemberTypes();
                    if (xsdMembers != null) {
                        int numMembers = xsdMembers.size();
                        for (int i = 0; i < numMembers; ++i) {
                            XSDSimpleType xsdMember = (XSDSimpleType)xsdMembers.get(i);
                            if (xsdMember == null) continue;
                            OracleSimpleType wrapper = this._factory.getSimpleTypeWrapper(xsdMember);
                            foundMemberTypes.add(wrapper);
                        }
                    }
                    if (foundMemberTypes.isEmpty()) {
                        foundMemberTypes = Collections.emptyList();
                    }
                    this._unionMemberTypes = foundMemberTypes;
                }
            }
        }
        return this._unionMemberTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleType getListItemType() {
        if (this._listItemType == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                XSDSimpleType xsdItemType;
                if (this._listItemType == null && (xsdItemType = this._xsdSimpleType.getItemType()) != null) {
                    OracleSimpleType wrapper;
                    this._listItemType = wrapper = this._factory.getSimpleTypeWrapper(xsdItemType);
                }
            }
        }
        return this._listItemType;
    }

    public void validateValue(String value) throws GrammarException {
        try {
            this._xsdSimpleType.validateValue(value);
        }
        catch (StringIndexOutOfBoundsException se) {
            LogRecord lr = new LogRecord(Level.WARNING, "Error validating value!");
            lr.setThrown(se);
            _LOGGER.log(lr);
        }
        catch (Exception e) {
            String message = TypeUtils.getSimpleTypeMessage(this);
            if (message == null || message.isEmpty()) {
                message = e.getMessage();
            }
            throw new GrammarException(message, e);
        }
    }

    public Object convertToJavaType(String value) throws GrammarException {
        return JavaTypeManager.getInstance().convertToJavaType(value, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._xsdSimpleType);
                }
            }
        }
        return this._annotation;
    }

    public String toString() {
        return this.getName();
    }

    OracleSimpleType(OracleSchemaFactory factory, XSDSimpleType xsdSimpleType) {
        this._factory = factory;
        this._xsdSimpleType = xsdSimpleType;
    }
}

