/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.ref;

import oracle.bali.xml.dom.ref.AttrNodeRef;
import oracle.bali.xml.dom.ref.DocumentRef;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.RegularNodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class NodeRefFactory {
    public static NodeRef getNodeRef(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return new AttrNodeRef((Attr)node);
        }
        if (node.getNodeType() == 9) {
            return DocumentRef.INSTANCE;
        }
        if (!DomUtils.isInDocumentHierarchy(node)) {
            throw new IllegalArgumentException("node " + node + " not in hierarchy!");
        }
        return new RegularNodeRef(node);
    }

    public static NodeRef getNodeRef(NodeRef parentRef, Node node) {
        if (node.getNodeType() == 2) {
            return NodeRefFactory.getAttrRef(parentRef, (Attr)node);
        }
        return new RegularNodeRef(parentRef, DomUtils.getChildIndex(node));
    }

    public static NodeRef getAttrRef(Node parentNode, Attr attr) {
        return NodeRefFactory.getAttrRef(NodeRefFactory.getNodeRef(parentNode), attr);
    }

    public static NodeRef getAttrRef(NodeRef parentRef, Attr attr) {
        return NodeRefFactory.getAttrRef(parentRef, attr.getNamespaceURI(), DomUtils.getLocalName(attr));
    }

    public static NodeRef getAttrRef(NodeRef parentRef, String namespace, String localName) {
        return new AttrNodeRef(parentRef, namespace, localName);
    }

    private NodeRefFactory() {
    }
}

