/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import javax.ide.extension.ExtensionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenerSupport;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.model.DefaultFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.view.View;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.ideri.navigator.NavigatorDockableFactory;
import oracle.ideri.navigator.ShowNavigatorController;
import oracle.ideri.navigator.dnd.ProjectNodeDropHelper;
import oracle.ideri.navigator.dnd.TransferableProject;
import oracle.ideri.navigator.dnd.WorkspaceNodeDropHelper;

public abstract class DefaultNavigatorManager
extends NavigatorManager {
    private DockableFactory _dockableFactory;
    private static ContextMenuListenerSupport shareContextMenuSupport;
    static final String GLOBAL_NAVIGATOR_ID = "navigator";

    static String getGlobalNavigatorID() {
        return GLOBAL_NAVIGATOR_ID;
    }

    protected static void registerSelectInNavigatorListeners() {
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorOpened(Editor editor) {
                Context context = editor.getContext();
                NavigatorWindow view = Ide.getLastActiveNavigator();
                if (view != null && context != null && context.getProperty("NavigatorWindow") == null) {
                    context.setProperty("NavigatorWindow", (Object)view.getId());
                    editor.setContext(context);
                }
            }

            public void editorActivated(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
            }
        });
        DefaultNavigatorManager.getSharedContextMenuListenerSupport().addContextMenuListener(new ContextMenuListener(){

            public void menuWillShow(ContextMenu menu) {
                Context context = menu.getContext();
                View view = context.getView();
                if (view instanceof NavigatorWindow) {
                    context.setProperty("NavigatorWindow", (Object)view.getId());
                }
            }

            public void menuWillHide(ContextMenu menu) {
            }

            public boolean handleDefaultAction(Context context) {
                View view = context.getView();
                if (view instanceof NavigatorWindow) {
                    context.setProperty("NavigatorWindow", (Object)view.getId());
                }
                return false;
            }
        }, null);
    }

    protected final IdeAction createShowAction() {
        IdeAction showAction = this.createShowNavigatorAction();
        showAction.addController((Controller)new ShowNavigatorController(){

            @Override
            protected DefaultNavigatorManager getNavigatorManager() {
                return DefaultNavigatorManager.this;
            }
        });
        return showAction;
    }

    protected boolean isToolbarVisible() {
        return super.isToolbarVisible();
    }

    protected NavigatorWindow getShowTarget(NavigatorWindow initial) {
        return initial;
    }

    protected abstract IdeAction createShowNavigatorAction();

    protected DockableFactory createDockableFactory() {
        return new NavigatorDockableFactory(this){

            @Override
            protected DockingParam createDockingParam() {
                return DefaultNavigatorManager.this.createNavigatorDockingParam();
            }
        };
    }

    protected DockingParam createNavigatorDockingParam() {
        return new DockingParam();
    }

    public ViewId getViewId(Context context) {
        Element folder;
        if (context != null && (folder = DefaultNavigatorManager.getFolderFromContext((Context)context)) != null) {
            return this.newViewId(folder);
        }
        return null;
    }

    protected final DockableView createDockableView(Context context, ViewId viewId) {
        if (viewId == null && (viewId = this.getViewId(context)) == null) {
            return null;
        }
        NavigatorWindow dockable = this.createNavigatorWindow(context, viewId);
        if (dockable instanceof DefaultNavigatorWindow) {
            DefaultNavigatorWindow navigator = (DefaultNavigatorWindow)dockable;
            navigator.setManager(this);
            this.initNavigatorWindow(navigator, context, viewId);
        }
        return dockable;
    }

    protected NavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new DefaultNavigatorWindow(context, viewId.getId());
    }

    protected void initNavigatorWindow(DefaultNavigatorWindow navigator, Context context, ViewId viewId) {
        this.initNavigatorWindowComparator(navigator);
        if (!this._isSystemNavigator(viewId)) {
            navigator.setType(1);
            navigator.setRootVisible(true);
            navigator.initSelection();
        }
        this.configureNavigator(navigator);
    }

    private boolean _isSystemNavigator(ViewId viewId) {
        int len;
        ViewId unhackedViewId;
        String viewName;
        if (this.isSystemNavigator(viewId)) {
            return true;
        }
        String factoryID = viewId.getType();
        return factoryID != null && factoryID.startsWith("_SUB_") && (viewName = viewId.getName()) != null && factoryID.startsWith("_SUB_") && this.isSystemNavigator(unhackedViewId = new ViewId(factoryID.substring(len = "_SUB_".length()), viewName.substring(len)));
    }

    protected void initNavigatorWindowComparator(DefaultNavigatorWindow navigator) {
        navigator.setComparator(DefaultFilter.folderFirstComparator);
    }

    protected final DockableFactory getDockableFactory() {
        if (this._dockableFactory == null) {
            this._dockableFactory = this.createDockableFactory();
        }
        return this._dockableFactory;
    }

    protected void configureNavigator(NavigatorWindow navigator) {
    }

    public ContextMenu getContextMenu() {
        NavigatorWindow navigatorWindow = this.getNavigatorWindow();
        assert (navigatorWindow instanceof DefaultNavigatorWindow);
        return ((DefaultNavigatorWindow)navigatorWindow).getContextMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContextMenuListenerSupport getSharedContextMenuListenerSupport() {
        boolean sharedContextMenuSupportInitialized = false;
        Class<DefaultNavigatorManager> clazz = DefaultNavigatorManager.class;
        synchronized (DefaultNavigatorManager.class) {
            ContextMenuListenersHook hook;
            if (shareContextMenuSupport == null) {
                shareContextMenuSupport = ContextMenuListenerSupport.createInstance();
                sharedContextMenuSupportInitialized = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (sharedContextMenuSupportInitialized && (hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT)) != null) {
                shareContextMenuSupport.addContextMenuListener(hook.getListener(GLOBAL_NAVIGATOR_ID), null);
            }
            return shareContextMenuSupport;
        }
    }

    protected final NavigatorWindow createNavigatorWindow(Folder rootFolder, boolean rootVisible, int defaultVisibility) {
        return this.createNavigatorWindow(rootFolder, null, null, rootVisible, defaultVisibility);
    }

    protected final NavigatorWindow createNavigatorWindow(Folder rootFolder, String tabName, String titleName, boolean rootVisible, int defaultVisibility) {
        Context context = Context.newIdeContext((Element)rootFolder);
        context.setProject(null);
        context.setWorkspace(null);
        ViewId id = this.getDefaultViewId();
        DefaultNavigatorWindow navWindow = (DefaultNavigatorWindow)this.createView(context, id);
        navWindow.setRootVisible(rootVisible);
        if (defaultVisibility != 0) {
            navWindow.setDefaultVisibility(defaultVisibility);
        }
        return navWindow;
    }

    public void addContextMenuListener(ContextMenuListener menuListener, Class cls) {
        DefaultNavigatorManager.getSharedContextMenuListenerSupport().addContextMenuListener(menuListener, cls);
    }

    public final void addContextMenuListener(ContextMenuListener menuListener, Class cls, boolean shared) {
        if (shared) {
            DefaultNavigatorManager.getSharedContextMenuListenerSupport().addContextMenuListener(menuListener, cls);
        } else {
            this.getContextMenu().addContextMenuListener(menuListener, cls);
        }
    }

    public void removeContextMenuListener(ContextMenuListener l) {
        this.getContextMenu().removeContextMenuListener(l);
    }

    public void registerExtension(Extension ext, Class cls) {
        DefaultNavigatorWindow.registerExtension(ext, cls);
    }

    NavigatorWindow createView(Context context, ViewId viewId) {
        return (NavigatorWindow)this.getNewView(context, viewId);
    }

    static {
        DragDropManager dndManager = DragDropManager.getInstance();
        TransferableProject projDragHelper = new TransferableProject();
        dndManager.registerDragHelperForInstance((DragHelper)projDragHelper, TransferableProject.DRAG_NODE_TYPE);
        ProjectNodeDropHelper projDropHelper = new ProjectNodeDropHelper();
        dndManager.registerDropHelperForInstance((DropHelper)projDropHelper, ProjectNodeDropHelper.DROP_NODE_TYPE);
        WorkspaceNodeDropHelper wkspDropHelper = new WorkspaceNodeDropHelper();
        dndManager.registerDropHelperForInstance((DropHelper)wkspDropHelper, WorkspaceNodeDropHelper.DROP_TARGET_TYPE);
        DefaultNavigatorManager.registerSelectInNavigatorListeners();
    }

    static final class NavigatorContextMenuListener
    implements ContextMenuListener {
        private final boolean shared;
        private final ContextMenuListener listener;

        private NavigatorContextMenuListener(ContextMenuListener listener, boolean shared) {
            this.listener = listener;
            this.shared = shared;
        }

        private static NavigatorContextMenuListener createInstance(ContextMenuListener listener, boolean shared) {
            return new NavigatorContextMenuListener(listener, shared);
        }

        public boolean isSharedContextMenuListener() {
            return this.shared;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            this.listener.menuWillShow(contextMenu);
        }

        public void menuWillHide(ContextMenu contextMenu) {
            this.listener.menuWillHide(contextMenu);
        }

        public boolean handleDefaultAction(Context context) {
            return this.listener.handleDefaultAction(context);
        }
    }
}

