/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.tk.spi;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEngine;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProvider;

public class LazyToolkitProvider
extends AbstractToolkitProvider {
    private final CustomMetaClass<ToolkitProvider> toolkitProviderClass;
    private String rule;
    WeakReference<ToolkitProvider> ref = null;

    public LazyToolkitProvider(MetaClass<ToolkitProvider> toolkitProviderClass, Class[] argTypes, Object[] args, String rule) {
        super(Toolkit.class);
        this.toolkitProviderClass = new CustomMetaClass<ToolkitProvider>(toolkitProviderClass, argTypes, args);
        this.rule = rule;
    }

    public LazyToolkitProvider(Class<? extends ToolkitProvider> toolkitProviderClass, Class[] argTypes, Object[] args, String rule) {
        this((MetaClass<ToolkitProvider>)new MetaClass(toolkitProviderClass.getClassLoader(), toolkitProviderClass.getName()), argTypes, args, rule);
    }

    @Override
    public AbstractToolkitBuilder create(ToolkitContext tkContext) throws ToolkitBuildException {
        if (this.rule != null) {
            Context ideContext = tkContext.getIdeContext();
            RuleEngine ruleEngine = RuleEngine.getInstance();
            if (!ruleEngine.evaluateRule(this.rule, ideContext)) {
                return null;
            }
        }
        try {
            if (this.toolkitProviderClass != null) {
                return this.getOrCreateToolkitProvider().create(tkContext);
            }
        }
        catch (ClassNotFoundException e) {
            this.reportClassInstantiationException(e);
        }
        catch (InstantiationException e) {
            this.reportClassInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            this.reportClassInstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            this.reportClassInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            this.reportClassInstantiationException(e);
        }
        return null;
    }

    private void reportClassInstantiationException(Exception e) {
        String cls = this.toolkitProviderClass.getClassName();
        throw new IllegalStateException("Error while instantiating toolkit class " + cls, e);
    }

    synchronized ToolkitProvider getOrCreateToolkitProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ToolkitProvider delegate = null;
        if (this.ref != null) {
            delegate = (ToolkitProvider)this.ref.get();
        }
        if (delegate == null) {
            delegate = this.toolkitProviderClass.newInstanceEx();
            this.ref = new WeakReference<ToolkitProvider>(delegate);
        }
        return delegate;
    }

    public String toString() {
        return super.toString() + "(" + this.toolkitProviderClass.getClassName() + ")";
    }
}

