/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.rules;

import java.util.Map;
import oracle.ide.Context;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public class ContextHasDeployPlatformType
extends RuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) {
        RuleFunctionParameter platformParam = parameters.get("platform-type");
        RuleFunctionParameter subTypesParam = parameters.get("include-sub-types");
        PlatformType platformType = null;
        boolean subTypes = subTypesParam == null || Boolean.getBoolean(subTypesParam.getValue());
        try {
            platformType = PlatformType.valueOf(platformParam.getValue());
        }
        catch (IllegalArgumentException e) {
            Assert.println((String)("Illegal value '" + platformParam.getValue() + "' in context-has-platform-type rule"));
            return false;
        }
        catch (NullPointerException e) {
            Assert.println((String)"Null value for platform-type in context-has-platform-type rule");
            return false;
        }
        Context context = ruleContext.getIdeContext();
        Platform platform = ShellAdapter.getInstance(context).getPlatform();
        if (platform == null) {
            return false;
        }
        if (subTypes) {
            return platform.getType().isExtensionOf(platformType);
        }
        return platform.getType().equals(platformType);
    }
}

