/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProvider;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;
import oracle.jdevimpl.deploy.tk.spi.LazyToolkitProvider;

class ToolkitProvidersHandler
extends BaseElementVisitor {
    static final ElementName EN_TOOLKIT_PROVIDERS = ToolkitProvidersHandler.e("toolkit-providers");
    private TkProviderClassHandler tkProviderClassHandler = new TkProviderClassHandler();
    static final String TOOLKIT_CLASS = "toolkit-class";
    static final String HEADLESS = "headless";
    static final String TOOLKIT_RULE = "rule";

    ToolkitProvidersHandler() {
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ToolkitProvidersHandler.e("provider-class"), (ElementVisitor)this.tkProviderClassHandler);
    }

    private class TkProviderClassHandler
    extends ElementVisitor {
        private TkProviderClassHandler() {
        }

        public void start(ElementStartContext context) {
            String rule;
            String headless;
            String interfaceClass = context.getAttributeValue("interface");
            if (ModelUtil.hasLength((String)interfaceClass)) {
                context.getScopeData().put(ToolkitProvidersHandler.TOOLKIT_CLASS, interfaceClass);
            }
            if (ModelUtil.hasLength((String)(headless = context.getAttributeValue(ToolkitProvidersHandler.HEADLESS)))) {
                context.getScopeData().put(ToolkitProvidersHandler.HEADLESS, headless.trim());
            }
            if (ModelUtil.hasLength((String)(rule = context.getAttributeValue(ToolkitProvidersHandler.TOOLKIT_RULE)))) {
                context.getScopeData().put(ToolkitProvidersHandler.TOOLKIT_RULE, rule);
            }
        }

        public void end(ElementEndContext context) {
            boolean add;
            String tkproviderClass = context.getText().trim();
            String toolkitInterface = (String)context.getScopeData().get(ToolkitProvidersHandler.TOOLKIT_CLASS);
            boolean headless = Boolean.parseBoolean((String)context.getScopeData().get(ToolkitProvidersHandler.HEADLESS));
            String rule = (String)context.getScopeData().get(ToolkitProvidersHandler.TOOLKIT_RULE);
            Assert.println((!ModelUtil.hasLength((String)rule) ? 1 : 0) != 0, (String)("WARNING: Missing 'rule' attribute on toolkit provider-class " + tkproviderClass + "[" + context.getExtension().getID() + "]"));
            ClassLoader cl = ElementVisitor.getClassLoader((ElementContext)context);
            MetaClass mc = new MetaClass(cl, tkproviderClass);
            LazyToolkitProvider provider = new LazyToolkitProvider((MetaClass<ToolkitProvider>)mc, null, null, rule);
            boolean createUI = Ide.getIdeArgs().getCreateUI();
            boolean bl = add = headless || createUI;
            if (add) {
                if (toolkitInterface != null) {
                    BaseElementVisitor.registerToolkit(toolkitInterface, provider);
                } else {
                    BaseElementVisitor.registerToolkit(provider);
                    Assert.println((String)(context.getExtension().getID() + ": Missing 'interface' attribute in toolkit-provider hook."));
                }
            }
        }

        boolean classExists(String className, ClassLoader cl) {
            try {
                cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

