/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdevimpl.deploy.hook.HookProfileInfo;
import oracle.jdevimpl.deploy.hook.ProfileSupportBase;

public class ProfileInfoElementsHandler
extends ProfileSupportBase
implements ElementVisitorFactory {
    private static final ElementName EN_PROFILE_CLASS = ProfileInfoElementsHandler.e("profile-class");
    private static final ElementName EN_PROFILE_ID = ProfileInfoElementsHandler.e("profile-id");
    private static final ElementName EN_SHORT_LABEL = ProfileInfoElementsHandler.e("short-label");
    private static final ElementName EN_LONG_LABEL = ProfileInfoElementsHandler.e("long-label");
    private static final ElementName EN_APP_LEVEL = ProfileInfoElementsHandler.e("application-level");
    private static final ElementName EN_PROJECT_LEVEL = ProfileInfoElementsHandler.e("project-level");

    public void end(ElementEndContext context) {
        HookProfileInfo info = (HookProfileInfo)context.getScopeData().get(HookProfileInfo.class.getName());
        assert (info != null);
        ElementName en = context.getElementName();
        String text = context.getText().trim();
        if (EN_PROFILE_CLASS.equals((Object)en)) {
            MetaClass profileClass = ProfileInfoElementsHandler.makeMetaClass((ElementContext)context, text);
            info.setProfileMetaClass((MetaClass<Profile>)profileClass);
        } else if (EN_PROFILE_ID.equals((Object)en)) {
            info.setId(text);
        } else if (EN_SHORT_LABEL.equals((Object)en)) {
            info.setShortLabel(text);
        } else if (EN_LONG_LABEL.equals((Object)en)) {
            info.setLongLabel(text);
        } else if (EN_APP_LEVEL.equals((Object)en)) {
            info.setApplicationLevel(Boolean.parseBoolean(text));
        } else if (EN_PROJECT_LEVEL.equals((Object)en)) {
            info.setProjectLevel(Boolean.parseBoolean(text));
        }
    }

    public ElementVisitor getVisitor(ElementName name) {
        return this;
    }
}

