/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileCreationException;
import oracle.jdeveloper.deploy.spi.profilesupport.CommandFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.DefaultProfileSupport;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileHashIO;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileInfo;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileRecognizer;

public class HookProfileSupport
extends DefaultProfileSupport {
    @Override
    protected synchronized void setCommandFactoryClass(MetaClass<CommandFactory> commandFactoryClass) {
        super.setCommandFactoryClass(commandFactoryClass);
    }

    @Override
    protected synchronized void setFactoryClass(MetaClass<ProfileFactory> factoryClass) {
        super.setFactoryClass(factoryClass);
    }

    @Override
    protected synchronized void setHashIOClass(MetaClass<ProfileHashIO> hashIOClass) {
        super.setHashIOClass(hashIOClass);
    }

    @Override
    protected synchronized void setProfileInfoClass(MetaClass<ProfileInfo> profileInfoClass) {
        super.setProfileInfoClass(profileInfoClass);
    }

    @Override
    protected synchronized void setRecognizerClass(MetaClass<ProfileRecognizer> recognizerClass) {
        super.setRecognizerClass(recognizerClass);
    }

    @Override
    protected synchronized void setProfileInfo(ProfileInfo info) {
        super.setProfileInfo(info);
    }

    @Override
    public synchronized ProfileFactory getProfileFactory() {
        ProfileFactory factory = super.getProfileFactory();
        if (factory == null) {
            factory = this.newProfileFactory();
        }
        return factory;
    }

    @Override
    public synchronized ProfileHashIO getHashIO() {
        ProfileHashIO io = super.getHashIO();
        if (io == null) {
            io = this.newProfileHashIO();
        }
        return io;
    }

    protected ProfileHashIO newProfileHashIO() {
        ProfileInfo info = this.getProfileInfo();
        if (info == null) {
            return null;
        }
        return new ReflectionBasedProfileHashIO(info);
    }

    protected ProfileFactory newProfileFactory() {
        ProfileInfo info = this.getProfileInfo();
        if (info == null) {
            return null;
        }
        return new ReflectionBasedProfileFactory(info);
    }

    private class ReflectionBasedProfileHashIO
    implements ProfileHashIO {
        final ProfileInfo profileInfo;

        private ReflectionBasedProfileHashIO(ProfileInfo profileInfo) {
            this.profileInfo = profileInfo;
        }

        @Override
        public Profile create(HashStructure hash, DataContainer dataContainer, Context context) {
            Profile profile = this.newProfile(hash);
            profile.setDataContainer(dataContainer);
            return profile;
        }

        @Override
        public HashStructure toHashStructure(Profile profile, Element element, Context context) {
            return profile.getHashStructure();
        }

        @Override
        public String getName(HashStructure hash) {
            return hash.getString(Profile.PROFILE_NAME);
        }

        private Profile newProfile(HashStructure hash) {
            Profile profile;
            Class<Profile> clazz = this.profileInfo.getProfileClass();
            assert (clazz != null);
            try {
                Constructor<Profile> ctor = clazz.getConstructor(HashStructure.class);
                profile = ctor.newInstance(hash);
            }
            catch (Exception e) {
                throw new ProfileCreationException(e);
            }
            return profile;
        }
    }

    private static class ReflectionBasedProfileFactory
    implements ProfileFactory {
        final ProfileInfo profileInfo;

        private ReflectionBasedProfileFactory(ProfileInfo profileInfo) {
            this.profileInfo = profileInfo;
        }

        @Override
        public Profile create(String name, DataContainer dataContainer, Context context) {
            Class<Profile> pc = this.profileInfo.getProfileClass();
            try {
                Constructor<Profile> ctor = pc.getConstructor(new Class[0]);
                Profile p = ctor.newInstance(new Object[0]);
                p.setName(name);
                p.setDataContainer(dataContainer);
                return p;
            }
            catch (NoSuchMethodException e) {
                this.throwProfileCreationException("Unable to get no-arg constructor for " + pc.getName());
            }
            catch (InstantiationException e) {
                this.throwProfileCreationException("Unable to instantiate instance of " + pc.getName());
            }
            catch (IllegalAccessException e) {
                this.throwProfileCreationException("Illegal access exception for " + pc.getName());
            }
            catch (InvocationTargetException e) {
                this.throwProfileCreationException("Invocation target exception for " + pc.getName());
            }
            return null;
        }

        private void throwProfileCreationException(String msg) {
            throw new ProfileCreationException(msg);
        }
    }
}

