/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdevimpl.deploy.fwk.SuperDeployer;

public class UpgradableDeployerFactory
implements DeployerFactory {
    private CustomMetaClass<DeployerFactory>[] factories_ = new CustomMetaClass[0];

    public UpgradableDeployerFactory(CustomMetaClass<DeployerFactory> factory) {
        if (factory != null) {
            this.addFactory(factory);
        }
    }

    @Override
    public Deployer newDeployer(int deploySequence, DeployShell shell) {
        Deployer deployer = null;
        int currentIndex = this.factories_.length - 1;
        deployer = this.searchFactories(currentIndex, deploySequence, shell);
        return deployer;
    }

    private Deployer searchFactories(int currentIndex, int deploySequence, DeployShell shell) {
        if (currentIndex < 0) {
            return null;
        }
        Deployer deployer = null;
        DeployerFactory factory = this.factories_[currentIndex].newInstance();
        if (factory != null) {
            deployer = factory.newDeployer(deploySequence, shell);
        }
        if (deployer == null) {
            deployer = this.searchFactories(currentIndex - 1, deploySequence, shell);
        } else if (this.isBatchDeployer(deployer)) {
            Deployer[] deployers = ((BatchDeployer)deployer).getDeployers();
            this.replaceSuperDeployers(deployers, deploySequence);
            for (int i = 0; i < deployers.length; ++i) {
                Deployer childDeployer;
                if (!this.isSuperDeployer(deployers[i]) || (childDeployer = this.searchFactories(currentIndex - 1, deploySequence, shell)) == null) continue;
                deployers[i] = childDeployer;
            }
        }
        return deployer;
    }

    boolean isSuperDeployer(Deployer deployer) {
        return deployer != null && deployer instanceof SuperDeployer;
    }

    public CustomMetaClass<DeployerFactory> downgradeFactory() {
        return this.removeFactory();
    }

    public void upgradeFactory(CustomMetaClass<DeployerFactory> factory) {
        this.addFactory(factory);
    }

    private void addFactory(CustomMetaClass<DeployerFactory> factory) {
        CustomMetaClass[] newArray = new CustomMetaClass[this.factories_.length + 1];
        System.arraycopy(this.factories_, 0, newArray, 0, this.factories_.length);
        this.factories_ = newArray;
        this.factories_[this.factories_.length - 1] = factory;
    }

    private CustomMetaClass<DeployerFactory> removeFactory() {
        Assert.check((this.factories_.length > 1 ? 1 : 0) != 0, (String)"Cannot remove factory. There are more downgrades than upgrades.");
        CustomMetaClass<DeployerFactory> factory = this.factories_[this.factories_.length - 1];
        CustomMetaClass[] newArray = new CustomMetaClass[this.factories_.length - 1];
        System.arraycopy(this.factories_, 0, newArray, 0, newArray.length);
        this.factories_ = newArray;
        return factory;
    }

    private boolean isDynamicDeployer(Deployer deployer) {
        return deployer instanceof DynamicDeployer;
    }

    private boolean isBatchDeployer(Deployer deployer) {
        return deployer instanceof BatchDeployer;
    }

    private void replaceSuperDeployers(Deployer[] deployers, int deploySequence) {
        boolean found = false;
        for (int i = 0; i < deployers.length; ++i) {
            if (!this.isDynamicDeployer(deployers[i]) || ((DynamicDeployer)deployers[i]).getSequenceId() != deploySequence) continue;
            if (found) {
                Assert.fail((String)"Batch deployer cannot split a single sequence into duplicate sequences");
            }
            deployers[i] = new SuperDeployer(deploySequence);
            found = true;
        }
    }
}

