/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.util.logging.Logger;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdevimpl.deploy.fwk.DeployMessages;
import oracle.jdevimpl.deploy.fwk.SequenceDeployer;
import oracle.jdevimpl.deploy.res.FwkArb;

public final class TopLevelDeployer
extends SequenceDeployer {
    long start_ = 0L;
    boolean deployed_ = false;
    private boolean initialized = false;
    private boolean released = false;

    public TopLevelDeployer(Deployer delegate) {
        super(DeploymentConstants.DEPLOYMENT_SEQUENCE, delegate);
    }

    @Override
    protected void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        super.deployImpl(deploySequenceId, shell);
        this.deployed_ = true;
    }

    @Override
    public void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        Counter c = Counter.findOrCreate(shell);
        ShellAdapter sa = ShellAdapter.getInstance(shell);
        if (c.increment() == 1 && !sa.isSuppressDeploymentStartFinishMessage()) {
            this.start_ = System.currentTimeMillis();
            sa.getLogger().info(DeployMessages.deploymentStarted());
            this.printTargetPlatform(shell);
        }
        super.prepareImpl(deploySequenceId, shell);
    }

    @Override
    protected void finishImpl(int deploySequenceId, DeployShell shell) {
        super.finishImpl(deploySequenceId, shell);
        Counter c = Counter.findOrCreate(shell);
        ShellAdapter sa = ShellAdapter.getInstance(shell);
        if (c.decrement() == 0 && !sa.isSuppressDeploymentStartFinishMessage()) {
            if (this.deployed_) {
                long end = System.currentTimeMillis();
                sa.getLogger().info(DeployMessages.deploymentElapsed(end - this.start_));
                sa.getLogger().info(DeployMessages.deploymentFinished());
            } else {
                shell.getLogger().severe(DeployMessages.deploymentIncomplete());
            }
        }
    }

    @Override
    protected void cancelImpl(int deploySequenceId, DeployShell shell) {
        super.cancelImpl(deploySequenceId, shell);
        ShellAdapter sa = ShellAdapter.getInstance(shell);
        if (!sa.isSuppressDeploymentStartFinishMessage()) {
            sa.getLogger().severe(DeployMessages.deploymentCanceled());
        }
    }

    private void printTargetPlatform(DeployShell dsh) {
        Platform platform = ShellAdapter.getInstance(dsh).getPlatform();
        Logger log = dsh.getLogger();
        if (platform != null) {
            log.info(FwkArb.format(9, "", platform.getLongLabel()));
            return;
        }
        log.info(FwkArb.getString(10));
    }

    static class Counter {
        static final String TOPLEVELDEPLOYER_KEY = "Deployment._topLevelDeployerCounter";
        int nesting_ = 0;

        Counter() {
        }

        static synchronized Counter findOrCreate(DeployShell shell) {
            ShellAdapter sa = ShellAdapter.getInstance(shell);
            Counter counter = (Counter)sa.find(TOPLEVELDEPLOYER_KEY);
            if (counter == null) {
                counter = new Counter();
                sa.put(TOPLEVELDEPLOYER_KEY, counter);
            }
            return counter;
        }

        int increment() {
            return ++this.nesting_;
        }

        int decrement() {
            return --this.nesting_;
        }
    }
}

