/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeploymentProfiles;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.common.AbstractHashDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;

public class DefaultProfileDependable
extends AbstractHashDependable
implements ProfileDependable {
    public static final String PROFILE_NAME_KEY = "profileName";
    private Profile profile_;

    public DefaultProfileDependable(Profile profile) {
        if (!ModelUtil.hasLength((String)profile.getName())) {
            throw new IllegalArgumentException("A Dependency can only be created to a named Profile");
        }
        this.setProfileName(profile.getName());
        if (profile.getDataContainer() != null) {
            this.setFolderURL(profile.getDataContainer().getURL());
        }
        this.setProfile(profile);
        this.setReload(false);
    }

    public DefaultProfileDependable(HashStructure hash) {
        super(hash);
    }

    @Override
    public Profile getProfile() {
        return (Profile)this.getSource();
    }

    @Override
    public Profile getSourceImpl() {
        return this.profile_;
    }

    protected void setProfile(Profile p) {
        this.profile_ = p;
    }

    @Override
    public Folder getSourceOwnerImpl() {
        Profile profile = this.getProfile();
        if (profile != null) {
            return profile.getDataContainer();
        }
        return null;
    }

    @Override
    public boolean cache() {
        String profileName = this._hash.getString(PROFILE_NAME_KEY);
        URL folderURL = this._hash.getURL("ownerURL");
        Assert.check((profileName != null ? 1 : 0) != 0, (String)"Profile name could not be found in dependable");
        Assert.check((folderURL != null ? 1 : 0) != 0, (String)"Folder not set in dependable");
        this.setProfile(null);
        if (URLFileSystem.exists((URL)folderURL)) {
            try {
                DataContainer folder = (DataContainer)NodeFactory.findOrCreate((URL)folderURL);
                Assert.check((boolean)(folder instanceof DataContainer), (String)"Profile should be contained in a datacontainer");
                Profile profile = DeploymentProfiles.getInstance(folder).getProfileByName(profileName);
                this.setProfile(profile);
                return profile != null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void setProfileName(String name) {
        String oldName = this.getProfileName();
        this._hash.putString(PROFILE_NAME_KEY, name);
        this.maybeSetReload(name, oldName);
    }

    protected String getProfileName() {
        return this._hash.getString(PROFILE_NAME_KEY);
    }

    protected void setFolderURL(URL url) {
        URL oldurl = this.getFolderURL();
        this._hash.putURL("ownerURL", url);
        this.maybeSetReload(url, oldurl);
    }

    protected URL getFolderURL() {
        return this._hash.getURL("ownerURL");
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        Profile profile = this.getProfile();
        if (profile == null) {
            return new ArrayList().iterator();
        }
        return profile.getDependencies();
    }

    @Override
    public <T> T getProfile(Class<T> clazz) {
        Profile profile = this.getProfile();
        return (T)(clazz.isAssignableFrom(profile.getClass()) ? profile : null);
    }

    @Override
    public DataContainer getDataContainer() {
        return (DataContainer)this.getSourceOwner();
    }

    @Override
    public boolean doesExist() {
        return this.getSource() != null;
    }
}

