/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import oracle.ide.util.Assert;
import oracle.javatools.util.Version;

public class PlatformVersion
extends Version {
    public PlatformVersion(String stringVersion) {
        super(stringVersion);
    }

    public int matchNumbers(Version other) {
        int i;
        if (other == null) {
            return i;
        }
        int[] thisDigits = this.toIntArray();
        int[] otherDigits = other.toIntArray();
        for (i = 0; i < otherDigits.length && i < thisDigits.length; ++i) {
            if (thisDigits[i] == otherDigits[i]) continue;
            return i;
        }
        if (i < thisDigits.length) {
            i *= -1;
        }
        return i;
    }

    public int getMajor() {
        Assert.check((this.toIntArray().length != 0 ? 1 : 0) != 0, (String)"Cannot determine major version");
        return this.toIntArray()[0];
    }

    public int getMinor() {
        Assert.check((this.toIntArray().length >= 2 ? 1 : 0) != 0, (String)"Cannot determine minor version");
        return this.toIntArray()[1];
    }

    public boolean isEqualOrGreaterThan(PlatformVersion other) {
        return this.equals((Object)other) || this.isGreaterThan(other);
    }

    public boolean isGreaterThan(PlatformVersion other) {
        int m = this.matchNumbers(other);
        if (m < 0) {
            return true;
        }
        int[] thisDigits = this.toIntArray();
        int[] otherDigits = other.toIntArray();
        for (int i = m; i < thisDigits.length && i < otherDigits.length; ++i) {
            if (thisDigits[i] <= otherDigits[i]) continue;
            return true;
        }
        return thisDigits.length > otherDigits.length;
    }

    public boolean isLessThan(PlatformVersion other) {
        return !this.isEqualOrGreaterThan(other);
    }

    public boolean isEqualTo(PlatformVersion other) {
        return this.equals((Object)other);
    }
}

