/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandReader;
import oracle.jdeveloper.deploy.spi.DeployCommandFactory;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;

public class DeployCommandFactory
implements ToolkitFactory {
    private static DeployCommandFactory instance_ = null;

    public static synchronized DeployCommandFactory getInstance() {
        if (instance_ == null) {
            instance_ = new DeployCommandFactory();
        }
        return instance_;
    }

    public DeployCommand create(Element element, Context context) throws CreationException {
        return this.create(element, context, "Deployment.defaultDeployment");
    }

    public DeployCommand create(Context context) throws CreationException {
        return this.create(context.getElement(), context, "Deployment.defaultDeployment");
    }

    public DeployCommand create(Context context, Object command) throws CreationException {
        return this.create(context.getElement(), context, command);
    }

    public DeployCommand create(Element element, Context context, Object command) throws CreationException {
        Context ctx = new Context(context);
        DeployCommandFactory.SpiData spi = new DeployCommandFactory.SpiData(ctx);
        spi.setCommand(command);
        try {
            oracle.jdeveloper.deploy.spi.DeployCommandFactory factory = ToolkitFactory.Utils.narrowBuildFirst(element, ctx, oracle.jdeveloper.deploy.spi.DeployCommandFactory.class);
            DeployCommand deployCommand = factory.createCommand();
            return deployCommand;
        }
        catch (ToolkitBuildException e) {
            String msg = String.format("Cannot create deploy command for %s", command);
            throw new CreationException(msg, e);
        }
    }

    public DeployCommand create(HashStructure hash, Context context) throws CreationException {
        try {
            HashDeployCommandReader reader = ToolkitFactory.Utils.narrowBuildFirst(context.getElement(), context, HashDeployCommandReader.class);
            return reader.read();
        }
        catch (ToolkitBuildException e) {
            String className = DeployCommandState.getCommandClassName(hash);
            String msg = String.format("Cannot create deploy command for %s", className);
            throw new CreationException(msg, e);
        }
    }

    public class CreationException
    extends ToolkitBuildException {
        CreationException(String msg, ToolkitBuildException e) {
            super(msg, e);
        }
    }
}

