/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchFieldBorder;

final class FindIncrementalGhost
implements ActionInvoker,
DocumentListener,
AncestorListener {
    private static final boolean RESTORE = true;
    private static final boolean NO_RESTORE = false;
    private static final boolean REQUEST_FOCUS = true;
    private GhostPalette ghostPanel;
    private Context searchContext;
    private JTextField searchField;
    private JLabel messageLabel;
    private Direction searchDirection;
    private int anchorOffset;
    private Rectangle anchorRect;
    private int lastFoundOffset;
    private int originalOffset;
    private Rectangle originalRect;
    private MultiKeyHandler keyHandler;
    private FindController controller;
    private boolean beepedForNotFound;
    private boolean beepedForEndBuffer;
    private static final String FORWARD_ACTION = "isearch-forward";
    private static final String BACKWARD_ACTION = "isearch-backward";
    private static final String OK_ACTION = "isearch-ok";
    private static final String CANCEL_ACTION = "isearch-cancel";
    private static final int FROM_ANCHOR = 1;
    private static final int FROM_CURRENT = 2;
    private static final int FROM_NEXT = 3;
    private static final int MINIMUM_LENGTH_TO_HIGHLIGHT = 2;
    private Point lastLocation = null;
    private Dimension lastSize = null;

    FindIncrementalGhost(FindController controller) {
        this.controller = controller;
    }

    public void performISearchForward(Context context) {
        this.showDialog(context, Direction.FORWARD);
    }

    public void performISearchBackward(Context context) {
        this.showDialog(context, Direction.BACKWARD);
    }

    private void showDialog(Context context, Direction direction) {
        BasicEditorPane editor = ((BasicEditorPaneContainer)context.getView()).getFocusedEditorPane();
        if (this.ghostPanel != null && this.ghostPanel.isShowing() && this.searchField != null) {
            if (direction == this.searchDirection) {
                this.searchField.requestFocus();
                return;
            }
            this.hideDialog(false, false);
        }
        this.ghostPanel = new GhostPalette((JComponent)editor);
        this.ghostPanel.setHideOnLoseFocus(true);
        this.ghostPanel.addAncestorListener((AncestorListener)this);
        this.ghostPanel.setMinimumSize(new Dimension(180, 74));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.ghostPanel, direction == Direction.FORWARD ? "f1_increfindforward_html" : "f1_increfindbackward_html");
        Bundle.get("ISEARCH_LABEL");
        this.searchField = new JTextField(30);
        this.messageLabel = new JLabel();
        this.clearMessage();
        this.messageLabel.setHorizontalTextPosition(2);
        this.messageLabel.putClientProperty(UIConstants.INSTRUCTION_LABEL, true);
        JPanel searchBorderPanel = new JPanel(new BorderLayout());
        SearchFieldBorder fieldBorder = new SearchFieldBorder();
        searchBorderPanel.setBorder((Border)fieldBorder);
        fieldBorder.setForeground(UIConstants.getColor((String)"ghost.panel.shadow", (UIConstants.Look)UIConstants.Look.DARK));
        this.searchField.setBorder(null);
        searchBorderPanel.add(this.searchField);
        JPanel p = new JPanel(new BorderLayout(0, 2));
        p.add((Component)searchBorderPanel, "North");
        p.add((Component)this.messageLabel, "South");
        this.ghostPanel.setLayout((LayoutManager)new BorderLayout());
        this.ghostPanel.add((Component)p);
        if (this.lastLocation != null) {
            this.ghostPanel.setLocation(this.lastLocation);
        } else {
            Point editorOrigin = editor.getLocationOnScreen();
            Rectangle visibleRect = new Rectangle();
            editor.computeVisibleRect(visibleRect);
            int xPos = editorOrigin.x;
            int yPos = editorOrigin.y + visibleRect.y + visibleRect.height + 10;
            Dimension screenSize = editor.getToolkit().getScreenSize();
            int dialogHeight = this.ghostPanel.getHeight();
            int dialogWidth = this.ghostPanel.getWidth();
            int FUDGE_FACTOR = 30;
            yPos = Math.min(yPos, screenSize.height - dialogHeight - 30);
            xPos = Math.min(xPos, screenSize.width - dialogWidth - 30);
            this.ghostPanel.setLocation(xPos, yPos);
        }
        if (this.originalRect == null) {
            this.originalRect = new Rectangle();
            this.anchorRect = new Rectangle();
        }
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions ksOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap ksMap = ksOptions.getGlobalKeyMap();
        Integer iSearchForwardCmdId = new Integer(26);
        List iSearchForwardKeyStrokes = ksMap.getKeyStrokesFor(iSearchForwardCmdId);
        Integer iSearchBackwardCmdId = new Integer(27);
        List iSearchBackwardKeyStrokes = ksMap.getKeyStrokesFor(iSearchBackwardCmdId);
        if (iSearchForwardKeyStrokes.size() == 0 || iSearchBackwardKeyStrokes.size() == 0) {
            String missingShortcut = this.getMissingShortcutMessage();
            JOptionPane.showMessageDialog((Component)editor, missingShortcut);
            return;
        }
        MultiKeymap multiKeymap = new MultiKeymap();
        int numForward = iSearchForwardKeyStrokes.size();
        for (int i = 0; i < numForward; ++i) {
            KeyStrokes ks = (KeyStrokes)iSearchForwardKeyStrokes.get(i);
            int numKeys = ks.getLength();
            KeyStroke[] keys = new KeyStroke[numKeys];
            for (int j = 0; j < numKeys; ++j) {
                keys[j] = ks.getKeyStroke(j);
            }
            multiKeymap.put(keys, numKeys, FORWARD_ACTION);
        }
        int numBackward = iSearchBackwardKeyStrokes.size();
        for (int i = 0; i < numBackward; ++i) {
            KeyStrokes ks = (KeyStrokes)iSearchBackwardKeyStrokes.get(i);
            int numKeys = ks.getLength();
            KeyStroke[] keys = new KeyStroke[numKeys];
            for (int j = 0; j < numKeys; ++j) {
                keys[j] = ks.getKeyStroke(j);
            }
            multiKeymap.put(keys, numKeys, BACKWARD_ACTION);
        }
        KeyStroke downKey = KeyStroke.getKeyStroke("DOWN");
        KeyStroke upKey = KeyStroke.getKeyStroke("UP");
        multiKeymap.put(downKey, FORWARD_ACTION);
        multiKeymap.put(upKey, BACKWARD_ACTION);
        KeyStroke enterKey = KeyStroke.getKeyStroke("ENTER");
        KeyStroke escapeKey = KeyStroke.getKeyStroke("ESCAPE");
        multiKeymap.put(enterKey, OK_ACTION);
        multiKeymap.put(escapeKey, CANCEL_ACTION);
        this.keyHandler = new MultiKeyHandler(multiKeymap);
        this.keyHandler.install((Component)this.searchField, (ActionInvoker)this);
        this.searchContext = context;
        editor.computeVisibleRect(this.originalRect);
        this.originalOffset = editor.getCaretPosition();
        editor.computeVisibleRect(this.anchorRect);
        this.anchorOffset = this.originalOffset;
        this.lastFoundOffset = -1;
        String editorText = Utilities.getCurrentWord((BasicEditorPane)editor);
        if (editorText != null) {
            this.searchField.setText(editorText);
        }
        this.searchField.selectAll();
        this.setDirection(direction);
        Document document = this.searchField.getDocument();
        document.addDocumentListener(this);
        this.clearMessage();
        this.ghostPanel.pack();
        if (this.lastSize != null) {
            this.ghostPanel.setSize(this.lastSize);
        }
        this.ghostPanel.show(false, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FindIncrementalGhost.this.searchField != null && FindIncrementalGhost.this.searchField.isShowing()) {
                    FindIncrementalGhost.this.searchField.requestFocus();
                }
            }
        });
        this.beepedForNotFound = false;
        this.beepedForEndBuffer = false;
    }

    private void hideDialog(boolean restoreOffset, boolean requestFocus) {
        if (this.ghostPanel == null) {
            throw new IllegalStateException("Cannot hide null dialog");
        }
        if (this.ghostPanel.isVisible()) {
            this.searchField.selectAll();
            this.ghostPanel.fadeInOut(false);
            if (requestFocus) {
                ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane().requestFocus();
            }
        } else {
            this.cleanUp(restoreOffset, requestFocus);
        }
    }

    private void cleanUp(boolean restoreOffset, boolean requestFocus) {
        BasicEditorPane editor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
        this.detatchSearchEditor(restoreOffset, requestFocus);
        this.lastLocation = this.ghostPanel.getLocation();
        this.lastSize = this.ghostPanel.getSize();
        Document document = this.searchField.getDocument();
        document.removeDocumentListener(this);
        Finder.clearHighlights((BasicEditorPane)editor);
        this.ghostPanel = null;
        this.searchField = null;
        this.keyHandler.deinstall();
        this.keyHandler = null;
    }

    private void detatchSearchEditor(boolean restoreOffset, boolean requestFocus) {
        BasicEditorPane searchEditor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
        if (searchEditor == null) {
            return;
        }
        if (restoreOffset) {
            searchEditor.scrollRectToVisible(this.originalRect);
            searchEditor.setCaretPosition(this.originalOffset);
        } else {
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(searchEditor);
            if (findToolbarController != null) {
                findToolbarController.navigate(searchEditor.getCaretPosition(), 0);
            } else {
                searchEditor.select(searchEditor.getCaretPosition(), searchEditor.getCaretPosition());
                searchEditor.ensureCaretVisible();
            }
        }
        if (this.controller != null) {
            String text = this.searchField.getText();
            this.controller.updateSearchText(text);
            FindController.getFindOptions().updateHistory(true, text);
        }
        if (requestFocus) {
            searchEditor.requestFocus();
        }
        this.searchContext = null;
    }

    private boolean containsUpperCase(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    private void doSearch(int fromAnchor) {
        Find find;
        int startOffset;
        this.clearMessage();
        String searchText = this.searchField.getText();
        BasicEditorPane searchEditor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
        Document document = searchEditor.getDocument();
        int documentEnd = document.getLength() - 1;
        if (searchText.length() == 0) {
            searchEditor.scrollRectToVisible(this.anchorRect);
            searchEditor.setCaretPosition(this.anchorOffset);
            this.lastFoundOffset = -1;
            Finder.clearHighlights((BasicEditorPane)((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane());
            return;
        }
        boolean matchCase = this.containsUpperCase(searchText);
        boolean searchForward = this.searchDirection == Direction.FORWARD;
        boolean wrapAround = false;
        boolean highlightOccurrences = searchText.length() >= 2;
        switch (fromAnchor) {
            case 1: {
                startOffset = this.anchorOffset;
                break;
            }
            case 2: {
                if (this.lastFoundOffset == -1) {
                    startOffset = this.anchorOffset;
                    break;
                }
                if (this.searchDirection == Direction.FORWARD) {
                    startOffset = this.lastFoundOffset;
                    break;
                }
                int selectionStart = searchEditor.getSelectionStart();
                int selectionEnd = searchEditor.getSelectionEnd();
                int oldLength = selectionEnd - selectionStart;
                int newLength = searchText.length();
                startOffset = selectionEnd + (newLength - oldLength);
                startOffset = Math.max(0, startOffset);
                startOffset = Math.min(startOffset, documentEnd);
                break;
            }
            case 3: {
                startOffset = this.lastFoundOffset == -1 ? this.anchorOffset : (this.searchDirection == Direction.FORWARD ? searchEditor.getSelectionEnd() : searchEditor.getSelectionStart());
                break;
            }
            default: {
                throw new IllegalStateException("unknown from: " + fromAnchor);
            }
        }
        boolean notFound = false;
        boolean wrappedAround = false;
        BasicEditorPane editor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
        FindCriteria criteria = new FindCriteria(searchText);
        criteria.setLocation(startOffset);
        criteria.setDirection(searchForward ? FindCriteria.Direction.FORWARD : FindCriteria.Direction.BACKWARD);
        criteria.setMatchCase(matchCase);
        criteria.setWrap(wrapAround);
        criteria.setWholeWord(false);
        criteria.setHighlight(highlightOccurrences);
        FindResult result = Finder.find((BasicEditorPane)editor, (FindCriteria)criteria);
        Find find2 = find = result == null ? null : result.getFind();
        if (find == null) {
            criteria.setWrap(true);
            criteria.setHighlight(false);
            criteria.setLocation(this.searchDirection == Direction.FORWARD ? 0 : documentEnd);
            notFound = true;
            result = Finder.find((BasicEditorPane)editor, (FindCriteria)criteria);
            find = result == null ? null : result.getFind();
            wrappedAround = true;
        }
        if (find != null) {
            if (wrappedAround && !this.beepedForEndBuffer) {
                this.beepedForEndBuffer = true;
                searchEditor.getToolkit().beep();
                String message = this.searchDirection == Direction.FORWARD ? this.getEndBufferMessage() : this.getStartBufferMessage();
                this.showMessage(message);
                wrappedAround = false;
            } else {
                Finder.highlight((BasicEditorPane)editor, (List)result.getFinds());
                searchEditor.setCaretPositionCenter(find.getStartOffset());
                searchEditor.moveCaretPositionCenter(find.getEndOffset());
                this.lastFoundOffset = find.getStartOffset();
                this.beepedForEndBuffer = false;
            }
            this.beepedForNotFound = false;
            notFound = false;
        }
        if (notFound) {
            if (!this.beepedForNotFound) {
                searchEditor.getToolkit().beep();
            }
            this.showMessage(this.getNotFoundMessage());
            this.beepedForNotFound = true;
        } else if (wrappedAround) {
            this.showMessage(this.getWrappedMessage());
        }
    }

    private void searchForward() {
        if (this.searchDirection == Direction.BACKWARD) {
            this.setDirection(Direction.FORWARD);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane searchEditor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
                this.anchorOffset = this.lastFoundOffset;
                searchEditor.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
        }
        this.doSearch(3);
    }

    private void searchBackward() {
        if (this.searchDirection == Direction.FORWARD) {
            this.setDirection(Direction.BACKWARD);
            if (this.lastFoundOffset != -1) {
                BasicEditorPane searchEditor = ((BasicEditorPaneContainer)this.searchContext.getView()).getFocusedEditorPane();
                this.anchorOffset = searchEditor.getSelectionEnd();
                searchEditor.computeVisibleRect(this.anchorRect);
            }
            this.clearMessage();
        }
        this.doSearch(3);
    }

    private void setDirection(Direction direction) {
        this.searchDirection = direction;
        String title = null;
        switch (direction) {
            case FORWARD: {
                title = Bundle.get("ISEARCH_FORWARD_TITLE");
                break;
            }
            case BACKWARD: {
                title = Bundle.get("ISEARCH_BACKWARD_TITLE");
                break;
            }
            default: {
                throw new IllegalStateException("unknown direction: " + (Object)((Object)direction));
            }
        }
        this.ghostPanel.setTitle(title);
    }

    private String getNotFoundMessage() {
        return Bundle.get("ISEARCH_MESSAGE_NOT_FOUND");
    }

    private String getWrappedMessage() {
        return Bundle.get("ISEARCH_MESSAGE_WRAPPED");
    }

    private String getEndBufferMessage() {
        return Bundle.get("ISEARCH_END_OF_BUFFER");
    }

    private String getStartBufferMessage() {
        return Bundle.get("ISEARCH_START_OF_BUFFER");
    }

    private String getMissingShortcutMessage() {
        return Bundle.get("ISEARCH_MESSAGE_MISSING_SHORTCUTS");
    }

    private void showMessage(String message) {
        this.messageLabel.setText(message);
    }

    private void clearMessage() {
        this.messageLabel.setText(" ");
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.beepedForEndBuffer = false;
        this.doSearch(2);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public void invokeAction(String actionKey) {
        if (actionKey == FORWARD_ACTION) {
            this.searchForward();
        } else if (actionKey == BACKWARD_ACTION) {
            this.searchBackward();
        } else if (actionKey == OK_ACTION) {
            this.hideDialog(false, true);
        } else if (actionKey == CANCEL_ACTION) {
            this.hideDialog(true, true);
        } else {
            throw new IllegalStateException("unknown action: " + actionKey);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.ghostPanel != null) {
            this.ghostPanel.removeAncestorListener((AncestorListener)this);
            this.cleanUp(false, false);
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

