/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeImpl;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.MemoryFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Ordering;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class FileUtil {
    private static final RequestProcessor REFRESH_RP = new RequestProcessor("FileUtil-Refresh-All");
    private static RequestProcessor.Task refreshTask = null;
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    static final Set<String> transientAttributes = new HashSet<String>();
    private static final Map<FileObject, Boolean> archiveFileCache;
    private static FileSystem diskFileSystem;
    private static Reference<Map<String, String>> normalizedRef;

    static String toDebugString(File file) {
        if (file == null) {
            return "NULL-ref";
        }
        return file.getPath() + "(" + file.getClass() + ")";
    }

    static boolean assertNormalized(File path) {
        return FileUtil.assertNormalized(path, false);
    }

    static boolean assertNormalized(File path, boolean forceIgnoreCase) {
        block2: {
            File np;
            block3: {
                if (path == null) break block2;
                np = null;
                if ($assertionsDisabled || path.getClass().getName().startsWith("sun.awt.shell") || !forceIgnoreCase && path.equals(np = FileUtil.normalizeFileCached(path))) break block2;
                if (!forceIgnoreCase) break block3;
                np = FileUtil.normalizeFileCached(path);
                if (path.getPath().equalsIgnoreCase(np.getPath())) break block2;
            }
            throw new AssertionError((Object)("Need to normalize " + FileUtil.toDebugString(path) + " was " + FileUtil.toDebugString(np)));
        }
        return true;
    }

    private static FileSystem getDiskFileSystemFor(File ... files) {
        FileSystem fs = FileUtil.getDiskFileSystem();
        if (fs == null) {
            for (File file : files) {
                FileObject fo = FileUtil.toFileObject(file);
                fs = FileUtil.getDiskFileSystem();
                if (fs != null) break;
            }
        }
        return fs;
    }

    private FileUtil() {
    }

    public static void refreshFor(File ... files) {
        FileSystem fs = FileUtil.getDiskFileSystemFor(files);
        if (fs != null) {
            try {
                fs.getRoot().setAttribute("request_for_refreshing_files_be_aware_this_is_not_public_api", files);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        RequestProcessor.Task taskToWaitFor;
        RequestProcessor requestProcessor = REFRESH_RP;
        synchronized (requestProcessor) {
            if (refreshTask != null) {
                refreshTask.cancel();
            } else {
                refreshTask = REFRESH_RP.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOG.fine("refreshAll - started");
                        FileUtil.refreshFor(File.listRoots());
                        try {
                            FileUtil.getConfigRoot().getFileSystem().refresh(true);
                        }
                        catch (FileStateInvalidException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            LOG.fine("refreshAll - finished");
                            RequestProcessor requestProcessor = REFRESH_RP;
                            synchronized (requestProcessor) {
                                refreshTask = null;
                            }
                        }
                    }
                });
            }
            taskToWaitFor = refreshTask;
            refreshTask.schedule(0);
            LOG.fine("refreshAll - scheduled");
        }
        taskToWaitFor.waitFinished();
        LOG.fine("refreshAll - finished");
    }

    public static void addFileChangeListener(FileChangeListener fcl) {
        FileSystem fs = FileUtil.getDiskFileSystem();
        if (fs == null) {
            fs = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fs != null) {
            fs.addFileChangeListener(fcl);
        }
    }

    public static void removeFileChangeListener(FileChangeListener fcl) {
        FileSystem fs = FileUtil.getDiskFileSystem();
        if (fs == null) {
            fs = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fs != null) {
            fs.removeFileChangeListener(fcl);
        }
    }

    public static void addFileChangeListener(FileChangeListener listener, File path) {
        FileChangeImpl.addFileChangeListenerImpl(LOG, listener, path);
    }

    public static void removeFileChangeListener(FileChangeListener listener, File path) {
        FileChangeImpl.removeFileChangeListenerImpl(LOG, listener, path);
    }

    public static void addRecursiveListener(FileChangeListener listener, File path) {
        FileUtil.addRecursiveListener(listener, path, null, null);
    }

    public static void addRecursiveListener(FileChangeListener listener, File path, Callable<Boolean> stop) {
        FileUtil.addRecursiveListener(listener, path, null, stop);
    }

    public static void addRecursiveListener(FileChangeListener listener, File path, FileFilter recurseInto, Callable<Boolean> stop) {
        FileChangeImpl.addRecursiveListener(listener, path, recurseInto, stop);
    }

    public static void removeRecursiveListener(FileChangeListener listener, File path) {
        FileChangeImpl.removeRecursiveListener(listener, path);
    }

    public static final void runAtomicAction(FileSystem.AtomicAction atomicCode) throws IOException {
        Repository.getDefault().getDefaultFileSystem().runAtomicAction(atomicCode);
    }

    public static final void runAtomicAction(final Runnable atomicCode) {
        FileSystem.AtomicAction action = new FileSystem.AtomicAction(){

            @Override
            public void run() throws IOException {
                atomicCode.run();
            }
        };
        try {
            FileUtil.runAtomicAction(action);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static FileObject createFolder(File folder) throws IOException {
        File existingFolder;
        for (existingFolder = folder; existingFolder != null && !existingFolder.isDirectory(); existingFolder = existingFolder.getParentFile()) {
        }
        if (existingFolder == null) {
            throw new IOException(folder.getAbsolutePath());
        }
        FileObject retval = null;
        FileObject folderFo = FileUtil.toFileObject(existingFolder);
        assert (folderFo != null) : existingFolder.getAbsolutePath();
        String relativePath = FileUtil.getRelativePath(existingFolder, folder);
        try {
            retval = FileUtil.createFolder(folderFo, relativePath);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (retval == null || !retval.isValid()) {
            folderFo.getFileSystem().refresh(false);
            retval = FileUtil.createFolder(folderFo, relativePath);
        }
        assert (retval != null);
        return retval;
    }

    public static FileObject createData(File data) throws IOException {
        File folder;
        for (folder = data; folder != null && !folder.isDirectory(); folder = folder.getParentFile()) {
        }
        if (folder == null) {
            throw new IOException(data.getAbsolutePath());
        }
        FileObject retval = null;
        FileObject folderFo = FileUtil.toFileObject(folder);
        assert (folderFo != null) : folder.getAbsolutePath();
        String relativePath = FileUtil.getRelativePath(folder, data);
        try {
            retval = FileUtil.createData(folderFo, relativePath);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (retval == null || !retval.isValid()) {
            folderFo.getFileSystem().refresh(false);
            retval = FileUtil.createData(folderFo, relativePath);
        }
        assert (retval != null);
        return retval;
    }

    private static String getRelativePath(File dir, File file) {
        File tempFile;
        Stack<String> stack = new Stack<String>();
        for (tempFile = file; tempFile != null && !tempFile.equals(dir); tempFile = tempFile.getParentFile()) {
            stack.push(tempFile.getName());
        }
        assert (tempFile != null) : file.getAbsolutePath() + "not found in " + dir.getAbsolutePath();
        StringBuilder retval = new StringBuilder();
        while (!stack.isEmpty()) {
            retval.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            retval.append('/');
        }
        return retval.toString();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER = new byte[65536];
        int len;
        while ((len = is.read(BUFFER)) != -1) {
            os.write(BUFFER, 0, len);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        FileObject dest = destFolder.createData(newName, newExt);
        FileLock lock = null;
        InputStream bufIn = null;
        OutputStream bufOut = null;
        try {
            lock = dest.lock();
            bufIn = source.getInputStream();
            bufOut = dest instanceof AbstractFileObject ? ((AbstractFileObject)dest).getOutputStream(lock, false) : dest.getOutputStream(lock);
            FileUtil.copy(bufIn, bufOut);
            FileUtil.copyAttributes(source, dest);
        }
        finally {
            if (bufIn != null) {
                bufIn.close();
            }
            if (bufOut != null) {
                bufOut.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return dest;
    }

    public static FileSystem createMemoryFileSystem() {
        return new MemoryFileSystem();
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName, String newExt) throws IOException {
        return source.copy(destFolder, newName, newExt);
    }

    public static FileObject copyFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        return FileUtil.copyFile(source, destFolder, newName, source.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject moveFile(FileObject source, FileObject destFolder, String newName) throws IOException {
        FileLock lock = null;
        try {
            lock = source.lock();
            FileObject fileObject = source.move(lock, destFolder, newName, source.getExt());
            return fileObject;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static FileObject createFolder(FileObject folder, String name) throws IOException {
        String separators = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer st = new StringTokenizer(name, separators);
        while (st.hasMoreElements()) {
            FileObject f;
            block4: {
                name = st.nextToken();
                if (name.length() <= 0) continue;
                f = folder.getFileObject(name);
                if (f == null) {
                    try {
                        LOG.finest("createFolder - before create folder if not exists.");
                        f = folder.createFolder(name);
                    }
                    catch (IOException ex) {
                        folder.refresh();
                        f = folder.getFileObject(name);
                        if (f != null) break block4;
                        throw ex;
                    }
                }
            }
            folder = f;
        }
        return folder;
    }

    public static FileObject createData(FileObject folder, String name) throws IOException {
        FileObject data;
        block10: {
            String ext;
            String fname;
            String dataname;
            Parameters.notNull((CharSequence)"folder", (Object)folder);
            Parameters.notNull((CharSequence)"name", (Object)name);
            int index = name.lastIndexOf(47);
            if (index >= name.length()) {
                throw new IOException("Wrong file name.");
            }
            if (index != -1) {
                String foldername = name.substring(0, index);
                dataname = name.substring(index + 1);
                folder = FileUtil.createFolder(folder, foldername);
                assert (folder != null);
            } else {
                dataname = name;
            }
            if ((index = dataname.lastIndexOf(46)) != -1) {
                fname = dataname.substring(0, index);
                ext = dataname.substring(index + 1);
            } else {
                fname = dataname;
                ext = "";
            }
            data = folder.getFileObject(fname, ext);
            if (data == null) {
                try {
                    data = folder.createData(fname, ext);
                    assert (data != null) : "FileObject.createData cannot return null; called on " + folder + " + " + fname + " + " + ext;
                }
                catch (SyncFailedException ex) {
                    folder.refresh();
                    data = folder.getFileObject(fname, ext);
                    if (data != null) break block10;
                    throw ex;
                }
            }
        }
        return data;
    }

    public static File toFile(FileObject fo) {
        File retVal = (File)fo.getAttribute("java.io.File");
        if (retVal == null) {
            URL fileURL = URLMapper.findURL(fo, 0);
            if (fileURL == null || !"file".equals(fileURL.getProtocol())) {
                fileURL = URLMapper.findURL(fo, 1);
            }
            if (fileURL != null && "file".equals(fileURL.getProtocol())) {
                retVal = BaseUtilities.toFile((URI)URI.create(fileURL.toExternalForm()));
            }
        }
        assert (FileUtil.assertNormalized(retVal, BaseUtilities.isMac()));
        return retVal;
    }

    public static FileObject toFileObject(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        if (file.getPath().equals("\\\\")) {
            return null;
        }
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts) {
            File normFile = FileUtil.normalizeFile(file);
            if (!file.equals(normFile)) {
                String msg = "Parameter file was not normalized. Was " + FileUtil.toDebugString(file) + " instead of " + FileUtil.toDebugString(normFile);
                LOG.log(Level.WARNING, msg);
                LOG.log(Level.INFO, msg, new IllegalArgumentException(msg));
            }
            file = normFile;
        }
        FileObject retVal = null;
        try {
            URL url = BaseUtilities.toURI((File)file).toURL();
            retVal = URLMapper.findFileObject(url);
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        if (retVal != null && FileUtil.getDiskFileSystem() == null) {
            try {
                FileSystem fs = retVal.getFileSystem();
                FileUtil.setDiskFileSystem(fs);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return retVal;
    }

    @Deprecated
    public static FileObject[] fromFile(File file) {
        FileObject[] retVal;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + FileUtil.toDebugString(file) + " instead of " + FileUtil.toDebugString(FileUtil.normalizeFile(file)));
        }
        try {
            URL url = BaseUtilities.toURI((File)file).toURL();
            retVal = URLMapper.findFileObjects(url);
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        return retVal;
    }

    public static void copyAttributes(FileObject source, FileObject dest) throws IOException {
        Enumeration<String> attrKeys = source.getAttributes();
        while (attrKeys.hasMoreElements()) {
            AtomicBoolean isRawValue;
            Object value;
            String key = attrKeys.nextElement();
            if (transientAttributes.contains(key) || FileUtil.isTransient(source, key) || (value = XMLMapAttr.getRawAttribute(source, key, isRawValue = new AtomicBoolean())) == null || value instanceof MultiFileObject.VoidValue) continue;
            if (isRawValue.get() && value instanceof Method) {
                dest.setAttribute("methodvalue:" + key, value);
                continue;
            }
            if (isRawValue.get() && value instanceof Class) {
                dest.setAttribute("newvalue:" + key, value);
                continue;
            }
            dest.setAttribute(key, value);
        }
    }

    static boolean isTransient(FileObject fo, String attrName) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fo, attrName);
    }

    @Deprecated
    public static void extractJar(final FileObject fo, final InputStream is) throws IOException {
        FileSystem fs = fo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            @Override
            public void run() throws IOException {
                FileUtil.extractJarImpl(fo, is);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarImpl(FileObject fo, InputStream is) throws IOException {
        JarEntry je;
        HashMap<String, DefaultAttributes.Table> attributes = new HashMap<String, DefaultAttributes.Table>(7);
        JarInputStream jis = new JarInputStream(is);
        while ((je = jis.getNextJarEntry()) != null) {
            String name = je.getName();
            if (name.toLowerCase().startsWith("meta-inf/")) continue;
            if (je.isDirectory()) {
                FileUtil.createFolder(fo, name);
                continue;
            }
            if (DefaultAttributes.acceptName(name)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jis, name);
                attributes.put(name, table);
                continue;
            }
            FileObject fd = FileUtil.createData(fo, name);
            FileLock lock = fd.lock();
            try (OutputStream os = fd.getOutputStream(lock);){
                FileUtil.copy(jis, os);
            }
            finally {
                lock.releaseLock();
            }
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String fileName = (String)entry.getKey();
            int last = fileName.lastIndexOf(47);
            String dirName = last != -1 ? fileName.substring(0, last + 1) : "";
            String prefix = fo.isRoot() ? dirName : fo.getPath() + '/' + dirName;
            DefaultAttributes.Table t = (DefaultAttributes.Table)entry.getValue();
            for (String orig : t.keySet()) {
                String fn = prefix + orig;
                FileObject obj = fo.getFileSystem().findResource(fn);
                if (obj == null) continue;
                Enumeration<String> attrEnum = t.attrs(orig);
                while (attrEnum.hasMoreElements()) {
                    String attrName = attrEnum.nextElement();
                    Object value = t.getAttr(orig, attrName);
                    if (value == null) continue;
                    obj.setAttribute(attrName, value);
                }
            }
        }
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String findFreeFileName(FileObject folder, String name, String ext) {
        if (FileUtil.checkFreeName(folder, name, ext)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, ext)) {
            ++i;
        }
        return destName;
    }

    public static String findFreeFolderName(FileObject folder, String name) {
        if (FileUtil.checkFreeName(folder, name, null)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!FileUtil.checkFreeName(folder, destName = name + "_" + i, null)) {
            ++i;
        }
        return destName;
    }

    public static String getRelativePath(FileObject folder, FileObject fo) {
        if (!FileUtil.isParentOf(folder, fo) && folder != fo) {
            return null;
        }
        String result = fo.getPath().substring(folder.getPath().length());
        if (result.startsWith("/") && !result.startsWith("//")) {
            result = result.substring(1);
        }
        return result;
    }

    private static boolean checkFreeName(FileObject fo, String name, String ext) {
        if (BaseUtilities.isWindows() || BaseUtilities.getOperatingSystem() == 2048 || BaseUtilities.isMac()) {
            Enumeration<? extends FileObject> en = fo.getChildren(false);
            while (en.hasMoreElements()) {
                fo = en.nextElement();
                String n = fo.getName();
                String e = fo.getExt();
                if (!n.equalsIgnoreCase(name)) continue;
                if (!(ext != null && ext.trim().length() != 0 || e != null && e.trim().length() != 0)) {
                    return fo.isVirtual();
                }
                if (ext == null || e == null || !ext.equalsIgnoreCase(e)) continue;
                return fo.isVirtual();
            }
            return true;
        }
        if (ext == null) {
            if ((fo = fo.getFileObject(name)) == null) {
                return true;
            }
            return fo.isVirtual();
        }
        if ((fo = fo.getFileObject(name, ext)) == null) {
            return true;
        }
        return fo.isVirtual();
    }

    public static FileObject findBrother(FileObject fo, String ext) {
        if (fo == null) {
            return null;
        }
        FileObject parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getFileObject(fo.getName(), ext);
    }

    @Deprecated
    public static String getMIMEType(String ext) {
        assert (false) : "FileUtil.getMIMEType(String extension) is deprecated. Please, use FileUtil.getMIMEType(FileObject).";
        if (ext.toLowerCase().equals("xml")) {
            return "text/xml";
        }
        return null;
    }

    public static String getMIMEType(FileObject fo) {
        return MIMESupport.findMIMEType(fo, new String[0]);
    }

    public static String getMIMEType(FileObject fo, String ... withinMIMETypes) {
        Parameters.notNull((CharSequence)"withinMIMETypes", (Object)withinMIMETypes);
        return MIMESupport.findMIMEType(fo, withinMIMETypes);
    }

    public static void setMIMEType(String extension, String mimeType) {
        Parameters.notEmpty((CharSequence)"extension", (CharSequence)extension);
        HashMap<String, Set<String>> mimeToExtensions = new HashMap<String, Set<String>>();
        FileObject userDefinedResolverFO = MIMEResolverImpl.getUserDefinedResolver();
        if (userDefinedResolverFO != null) {
            mimeToExtensions.putAll(MIMEResolverImpl.getMIMEToExtensions(userDefinedResolverFO));
            for (Set extensions : mimeToExtensions.values()) {
                extensions.remove(extension);
            }
        }
        if (mimeType != null) {
            Set previousExtensions = (Set)mimeToExtensions.get(mimeType);
            if (previousExtensions != null) {
                previousExtensions.add(extension);
            } else {
                mimeToExtensions.put(mimeType, Collections.singleton(extension));
            }
        }
        if (MIMEResolverImpl.storeUserDefinedResolver(mimeToExtensions)) {
            MIMESupport.resetCache();
        }
        MIMESupport.freeCaches();
    }

    public static List<String> getMIMETypeExtensions(String mimeType) {
        Parameters.notEmpty((CharSequence)"mimeType", (CharSequence)mimeType);
        HashMap<String, String> extensionToMime = new HashMap<String, String>();
        for (FileObject fileObject : MIMEResolverImpl.getOrderedResolvers()) {
            Map<String, Set<String>> mimeToExtensions = MIMEResolverImpl.getMIMEToExtensions(fileObject);
            for (Map.Entry<String, Set<String>> entry : mimeToExtensions.entrySet()) {
                String mimeKey = entry.getKey();
                Set<String> extensions = entry.getValue();
                for (String extension : extensions) {
                    extensionToMime.put(extension, mimeKey);
                }
            }
        }
        ArrayList<String> registeredExtensions = new ArrayList<String>();
        for (Map.Entry entry : extensionToMime.entrySet()) {
            if (!((String)entry.getValue()).equals(mimeType)) continue;
            registeredExtensions.add((String)entry.getKey());
        }
        return registeredExtensions;
    }

    @Deprecated
    public static URLStreamHandler nbfsURLStreamHandler() {
        return new FileURL.Handler();
    }

    public static boolean isParentOf(FileObject folder, FileObject fo) {
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        if (folder.isData()) {
            return false;
        }
        try {
            if (folder.getFileSystem() != fo.getFileSystem()) {
                return false;
            }
        }
        catch (FileStateInvalidException e) {
            return false;
        }
        for (FileObject parent = fo.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(folder)) continue;
            return true;
        }
        return false;
    }

    public static FileChangeListener weakFileChangeListener(FileChangeListener l, Object source) {
        return (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)l, (Object)source);
    }

    public static FileStatusListener weakFileStatusListener(FileStatusListener l, Object source) {
        return (FileStatusListener)WeakListeners.create(FileStatusListener.class, (EventListener)l, (Object)source);
    }

    public static String getFileDisplayName(FileObject fo) {
        String displayName = null;
        File f = FileUtil.toFile(fo);
        if (f != null) {
            displayName = f.getAbsolutePath();
        } else {
            FileObject archiveFile = FileUtil.getArchiveFile(fo);
            if (archiveFile != null) {
                displayName = FileUtil.getArchiveDisplayName(fo, archiveFile);
            }
        }
        if (displayName == null) {
            try {
                displayName = fo.isRoot() ? fo.getFileSystem().getDisplayName() : NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)fo.getPath(), (Object)fo.getFileSystem().getDisplayName());
            }
            catch (FileStateInvalidException e) {
                displayName = fo.getPath();
            }
        }
        return displayName;
    }

    private static String getArchiveDisplayName(FileObject fo, FileObject archiveFile) {
        String displayName = null;
        File f = FileUtil.toFile(archiveFile);
        if (f != null) {
            String archivDisplayName = f.getAbsolutePath();
            if (fo.isRoot()) {
                displayName = archivDisplayName;
            } else {
                String entryPath = fo.getPath();
                displayName = NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)entryPath, (Object)archivDisplayName);
            }
        }
        return displayName;
    }

    public static String normalizePath(String path) {
        Map<String, String> normalizedPaths = FileUtil.getNormalizedFilesMap();
        String normalized = normalizedPaths.get(path);
        if (normalized == null) {
            File ret = FileUtil.normalizeFileImpl(new File(path));
            normalized = ret.getPath();
            normalizedPaths.put(path, normalized);
        }
        return normalized;
    }

    public static File normalizeFile(File file) {
        File ret = FileUtil.normalizeFileCached(file);
        assert (FileUtil.assertNormalized(ret));
        return ret;
    }

    private static File normalizeFileCached(File file) {
        File ret;
        String unnormalized;
        Map<String, String> normalizedPaths = FileUtil.getNormalizedFilesMap();
        String normalized = normalizedPaths.get(unnormalized = file.getPath());
        if (normalized != null && normalized.equalsIgnoreCase(unnormalized) && !normalized.equals(unnormalized)) {
            normalized = null;
        }
        if (normalized == null) {
            ret = FileUtil.normalizeFileImpl(file);
            assert (!ret.getName().equals(".")) : "Original file " + file + " normalized: " + ret;
            normalizedPaths.put(unnormalized, ret.getPath());
        } else {
            ret = normalized.equals(unnormalized) ? file : new File(normalized);
        }
        return ret;
    }

    private static File normalizeFileImpl(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        LOG.log(Level.FINE, "FileUtil.normalizeFile for {0}", file);
        long now = System.currentTimeMillis();
        File retFile = BaseUtilities.isWindows() || BaseUtilities.getOperatingSystem() == 2048 ? FileUtil.normalizeFileOnWindows(file) : (BaseUtilities.isMac() ? FileUtil.normalizeFileOnMac(file) : FileUtil.normalizeFileOnUnixAlike(file));
        File ret = file.getPath().equals(retFile.getPath()) ? file : retFile;
        long took = System.currentTimeMillis() - now;
        if (took > 500L) {
            LOG.log(Level.WARNING, "FileUtil.normalizeFile({0}) took {1} ms. Result is {2}", new Object[]{file, took, ret});
        }
        return ret;
    }

    private static File normalizeFileOnUnixAlike(File file) {
        file = BaseUtilities.toFile((URI)BaseUtilities.toURI((File)file).normalize()).getAbsoluteFile();
        while (file.getAbsolutePath().startsWith("/../")) {
            file = new File(file.getAbsolutePath().substring(3));
        }
        if (file.getAbsolutePath().equals("/..")) {
            file = new File("/");
        }
        return file;
    }

    private static File normalizeFileOnMac(File file) {
        File retVal = file;
        try {
            boolean isSymLink;
            File absoluteFile = BaseUtilities.toFile((URI)BaseUtilities.toURI((File)file).normalize());
            File canonicalFile = file.getCanonicalFile();
            String absolutePath = absoluteFile.getAbsolutePath();
            if (absolutePath.equals("/..")) {
                absolutePath = "/";
                absoluteFile = new File("/");
            }
            boolean bl = isSymLink = !canonicalFile.getAbsolutePath().equalsIgnoreCase(absolutePath);
            retVal = isSymLink ? FileUtil.normalizeSymLinkOnMac(absoluteFile) : canonicalFile;
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, "Normalization failed on file " + file, ioe);
            retVal = file.getAbsoluteFile();
        }
        return retVal;
    }

    private static File normalizeSymLinkOnMac(File file) throws IOException {
        File retVal;
        File pureCanonicalFile = retVal = File.listRoots()[0];
        String pattern = File.separator + ".." + File.separator;
        String tmpFileName = file.getAbsolutePath();
        int index = tmpFileName.lastIndexOf(pattern);
        if (index > -1) {
            tmpFileName = tmpFileName.substring(index + pattern.length());
        }
        String fileName = tmpFileName;
        StringTokenizer fileSegments = new StringTokenizer(fileName, File.separator);
        while (fileSegments.hasMoreTokens()) {
            boolean isSymLink;
            File absolutelyEndingFile = new File(pureCanonicalFile, fileSegments.nextToken());
            boolean bl = isSymLink = !(pureCanonicalFile = absolutelyEndingFile.getCanonicalFile()).getAbsolutePath().equalsIgnoreCase(absolutelyEndingFile.getAbsolutePath());
            if (isSymLink) {
                retVal = new File(retVal, absolutelyEndingFile.getName());
                continue;
            }
            retVal = new File(retVal, pureCanonicalFile.getName());
        }
        return retVal;
    }

    private static File normalizeFileOnWindows(File file) {
        File retVal;
        block9: {
            retVal = null;
            if (file.getClass().getName().startsWith("sun.awt.shell")) {
                return file;
            }
            try {
                retVal = file.getCanonicalFile();
                if (retVal.getName().equals(".")) {
                    retVal = retVal.getCanonicalFile();
                }
            }
            catch (IOException e) {
                String path = file.getPath();
                if (!path.equals("\\\\") && !"\\\\".equals(file.getParent())) {
                    LOG.log(Level.FINE, path, e);
                }
                if (path.endsWith(".")) {
                    path = path.substring(0, path.length() - 1);
                    retVal = new File(path);
                }
                if (path.length() <= 3 || !path.endsWith("\\")) break block9;
                path = path.substring(0, path.length() - 1);
                retVal = new File(path);
            }
        }
        if ((BaseUtilities.getOperatingSystem() & 0x40000) != 0) {
            String absolutePath;
            if (retVal == null) {
                retVal = file.getAbsoluteFile();
            }
            if ((absolutePath = retVal.getAbsolutePath()).contains(":\\Documents and Settings")) {
                absolutePath = absolutePath.replaceFirst("Documents and Settings", "Users");
                absolutePath = absolutePath.replaceFirst("My Documents", "Documents");
                absolutePath = absolutePath.replaceFirst("My Pictures", "Pictures");
                absolutePath = absolutePath.replaceFirst("My Music", "Music");
                retVal = new File(absolutePath);
            }
        }
        return retVal != null ? retVal : file.getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getNormalizedFilesMap() {
        Map<String, String> map = normalizedRef.get();
        if (map != null) return map;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            map = normalizedRef.get();
            if (map != null) return map;
            map = new ConcurrentHashMap<String, String>();
            normalizedRef = new SoftReference<Map<String, String>>(map);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    static void freeCaches() {
        normalizedRef.clear();
    }

    public static FileObject getArchiveRoot(FileObject fo) {
        URL archiveURL = URLMapper.findURL(fo, 1);
        if (archiveURL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveRoot(archiveURL));
    }

    public static URL getArchiveRoot(URL url) {
        try {
            return new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileObject getArchiveFile(FileObject fo) {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        try {
            FileSystem fs = fo.getFileSystem();
            if (fs instanceof JarFileSystem) {
                File jarFile = ((JarFileSystem)fs).getJarFile();
                return FileUtil.toFileObject(jarFile);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public static URL getArchiveFile(URL url) {
        String path;
        int index;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            String jarPath = null;
            try {
                jarPath = path.substring(0, index);
                if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                    jarPath = jarPath.replaceFirst("file://", "file:////");
                }
                return new URL(jarPath);
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.WARNING, "Invalid URL ({0}): {1}, jarPath: {2}", new Object[]{mue.getMessage(), url.toExternalForm(), jarPath});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isArchiveFile(FileObject fo) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fo);
        if (!fo.isValid()) {
            return FileUtil.isArchiveFile(fo.getPath());
        }
        if (fo.isVirtual()) {
            return FileUtil.isArchiveFile(fo.getPath());
        }
        if (fo.isFolder()) {
            return false;
        }
        Boolean b = archiveFileCache.get(fo);
        if (b != null) return b;
        try (InputStream in = fo.getInputStream();){
            byte[] buffer = new byte[4];
            int len = in.read(buffer, 0, 4);
            if (len != 4) {
                boolean bl = false;
                return bl;
            }
            b = Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer);
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, null, ioe);
        }
        if (b == null) {
            b = FileUtil.isArchiveFile(fo.getPath());
        }
        archiveFileCache.put(fo, b);
        return b;
    }

    public static boolean isArchiveFile(URL url) {
        Parameters.notNull((CharSequence)"url", (Object)url);
        if ("jar".equals(url.getProtocol())) {
            return false;
        }
        FileObject fo = URLMapper.findFileObject(url);
        if (fo != null && !fo.isVirtual()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "isArchiveFile_FILE_RESOLVED", fo);
            }
            return FileUtil.isArchiveFile(fo);
        }
        return FileUtil.isArchiveFile(url.getPath());
    }

    public static URL urlForArchiveOrDir(File entry) {
        try {
            URL u;
            boolean isDir;
            boolean wasDir;
            do {
                wasDir = entry.isDirectory();
                LOG.finest("urlForArchiveOrDir:toURI:entry");
                u = BaseUtilities.toURI((File)entry).toURL();
            } while (wasDir ^ (isDir = entry.isDirectory()));
            if (FileUtil.isArchiveFile(u) || entry.isFile() && entry.length() < 4L) {
                return FileUtil.getArchiveRoot(u);
            }
            if (isDir) {
                assert (u.toExternalForm().endsWith("/"));
                return u;
            }
            if (!entry.exists()) {
                if (!u.toString().endsWith("/")) {
                    u = new URL(u + "/");
                }
                return u;
            }
            return null;
        }
        catch (MalformedURLException x) {
            assert (false) : x;
            return null;
        }
    }

    public static File archiveOrDirForURL(URL entry) {
        String u = entry.toString();
        if (u.startsWith("jar:file:") && u.endsWith("!/")) {
            return BaseUtilities.toFile((URI)URI.create(u.substring(4, u.length() - 2)));
        }
        if (u.startsWith("file:")) {
            return BaseUtilities.toFile((URI)URI.create(u));
        }
        return null;
    }

    @Deprecated
    public static void preventFileChooserSymlinkTraversal(JFileChooser chooser, File currentDirectory) {
        chooser.setCurrentDirectory(currentDirectory);
    }

    public static List<FileObject> getOrder(Collection<FileObject> children, boolean logWarnings) throws IllegalArgumentException {
        return Ordering.getOrder(children, logWarnings);
    }

    public static void setOrder(List<FileObject> children) throws IllegalArgumentException, IOException {
        Ordering.setOrder(children);
    }

    public static boolean affectsOrder(FileAttributeEvent event) {
        return Ordering.affectsOrder(event);
    }

    public static FileObject getConfigFile(String path) {
        Parameters.notNull((CharSequence)"path", (Object)path);
        return Repository.getDefault().getDefaultFileSystem().findResource(path);
    }

    public static <T> T getConfigObject(String path, Class<T> type) {
        FileObject fo = FileUtil.getConfigFile(path);
        if (fo == null || fo.isFolder()) {
            return null;
        }
        return (T)NamedServicesProvider.getConfigObject((String)path, type);
    }

    public static FileObject getConfigRoot() {
        return FileUtil.getConfigFile("");
    }

    private static File wrapFileNoCanonicalize(File f) {
        if (f instanceof NonCanonicalizingFile) {
            return f;
        }
        if (f != null) {
            return new NonCanonicalizingFile(f);
        }
        return null;
    }

    private static File[] wrapFilesNoCanonicalize(File[] fs) {
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                fs[i] = FileUtil.wrapFileNoCanonicalize(fs[i]);
            }
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getDiskFileSystem() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return diskFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setDiskFileSystem(FileSystem fs) {
        Object o = fs.getRoot().getAttribute("SupportsRefreshForNoPublicAPI");
        if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) return;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            diskFileSystem = fs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean isArchiveFile(String path) {
        int index = path.lastIndexOf(46);
        return index != -1 && index > path.lastIndexOf(47) + 1;
    }

    static boolean isRecursiveSymlink(FileObject fileObject) {
        Path path;
        File file = (File)fileObject.getAttribute("java.io.File");
        if (file == null) {
            return false;
        }
        try {
            path = file.toPath();
        }
        catch (RuntimeException e) {
            LOG.log(Level.INFO, "Cannot get path for {0}", file);
            LOG.log(Level.FINE, null, e);
            return false;
        }
        if (Files.isSymbolicLink(path)) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException {
                        Path target = Files.readSymbolicLink(path);
                        if (!target.isAbsolute()) {
                            target = path.resolve(target);
                        }
                        target = target.toRealPath(new LinkOption[0]);
                        for (Path ancestor = path.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                            if (!target.equals(ancestor)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                LOG.log(Level.INFO, "Cannot read symbolic link {0}", path);
                LOG.log(Level.FINE, null, ex.getException());
            }
            catch (SecurityException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        return false;
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("templateCategory");
        transientAttributes.add("instantiatingIterator");
        transientAttributes.add("instantiatingWizardURL");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        transientAttributes.add("displayName");
        transientAttributes.add("iconBase");
        transientAttributes.add("position");
        transientAttributes.add("weight");
        archiveFileCache = new WeakHashMap<FileObject, Boolean>();
        normalizedRef = new SoftReference(new ConcurrentHashMap());
    }

    private static final class NonCanonicalizingFile
    extends File {
        public NonCanonicalizingFile(File orig) {
            this(orig.getPath());
        }

        private NonCanonicalizingFile(String path) {
            super(path);
        }

        private NonCanonicalizingFile(URI uri) {
            super(uri);
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return FileUtil.wrapFileNoCanonicalize(FileUtil.normalizeFile(super.getAbsoluteFile()));
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return FileUtil.normalizeFile(super.getAbsoluteFile()).getAbsolutePath();
        }

        @Override
        public File getParentFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getParentFile());
        }

        @Override
        public File getAbsoluteFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getAbsoluteFile());
        }

        @Override
        public File[] listFiles() {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles());
        }

        @Override
        public File[] listFiles(FileFilter filter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(filter));
        }

        @Override
        public File[] listFiles(FilenameFilter filter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(filter));
        }
    }
}

