/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorFactory;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactory;
import oracle.bali.inspector.editor.PaintableEditorComponent;
import oracle.bali.inspector.editor.ReadOnlyEditorComponent;
import oracle.bali.inspector.editor.TextFieldEditorFactory;

public final class EditorComponentFactoryRegistry {
    private final List<EditorComponentFactory> registry = new ArrayList<EditorComponentFactory>();
    private final ComboBoxEditorFactory comboBoxEditorFactory = new ComboBoxEditorFactory();
    private TextFieldEditorFactory textFieldEditorFactory = new TextFieldEditorFactory();
    private EditorComponentFactory defaultEditorFactory = null;

    public EditorComponentFactory defaultFactory() {
        return this.defaultEditorFactory != null ? this.defaultEditorFactory : this.textFieldEditorFactory;
    }

    TextFieldEditorFactory textFieldEditorFactory() {
        return this.textFieldEditorFactory;
    }

    ComboBoxEditorFactory comboBoxEditorFactory() {
        return this.comboBoxEditorFactory;
    }

    public void addDefaultEditorFactory(EditorComponentFactory factory) {
        this.defaultEditorFactory = factory;
        if (this.defaultEditorFactory instanceof TextFieldEditorFactory) {
            this.textFieldEditorFactory = (TextFieldEditorFactory)this.defaultEditorFactory;
        }
    }

    public void register(EditorComponentFactory factory) {
        if (this.registry.contains(factory)) {
            return;
        }
        this.registry.add(0, factory);
    }

    public Component createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo editorComponentInfo = propertyEditor.getEditorComponentInfo();
        if (editorComponentInfo == null) {
            return this.createFromDefaultFactory(propertyEditor);
        }
        EditorComponentFactory factory = this.factoryFor(editorComponentInfo);
        if (factory == null) {
            return this.createFromDefaultFactory(propertyEditor);
        }
        return factory.createInlineEditor(propertyEditor);
    }

    public Component updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo editorComponentInfo = propertyEditor.getEditorComponentInfo();
        if (editorComponentInfo == null) {
            return this.updateFromDefaultFactory(current, propertyEditor);
        }
        for (EditorComponentFactory factory : this.registry) {
            Component updatedEditor;
            if (!factory.canCreateEditorFrom(editorComponentInfo) && !factory.canCreateEditorFrom(editorComponentInfo.initialValue()) || (updatedEditor = factory.updateInlineEditor(current, propertyEditor)) == null) continue;
            return updatedEditor;
        }
        return this.updateFromDefaultFactory(current, propertyEditor);
    }

    private Component createFromDefaultFactory(PropertyEditorFactory2 propertyEditor) {
        return this.defaultFactory().createInlineEditor(propertyEditor);
    }

    private Component updateFromDefaultFactory(Component current, PropertyEditorFactory2 propertyEditor) {
        return this.defaultFactory().updateInlineEditor(current, propertyEditor);
    }

    public Component createPaintableEditor(PropertyEditorFactory2 propertyEditor, boolean writable) {
        return new PaintableEditorComponent(propertyEditor, writable);
    }

    public Component updatePaintableEditor(Component currentEditor, PropertyEditorFactory2 propertyEditor, boolean writable) {
        if (currentEditor instanceof PaintableEditorComponent) {
            PaintableEditorComponent editor = (PaintableEditorComponent)currentEditor;
            editor.update(propertyEditor);
            return editor;
        }
        return null;
    }

    public Component createReadOnlyEditor(PropertyEditorFactory2 propertyEditor) {
        Component editor;
        if (propertyEditor.hasInlineEditor() && (editor = this.createInlineEditor(propertyEditor)) instanceof JTextComponent) {
            return ReadOnlyEditorComponent.decorate((JTextComponent)editor);
        }
        return this.createReadOnlyEditor(propertyEditor.getAsText());
    }

    @Deprecated
    public Component createReadOnlyEditor(String text) {
        return new ReadOnlyEditorComponent(text);
    }

    public Component updateReadOnlyEditor(Component currentEditor, PropertyEditorFactory2 propertyEditor) {
        return this.updateReadOnlyEditor(currentEditor, propertyEditor.getAsText());
    }

    public Component updateReadOnlyEditor(Component currentEditor, String text) {
        if (!(currentEditor instanceof JTextComponent)) {
            return null;
        }
        JTextComponent readOnly = ReadOnlyEditorComponent.decorate((JTextComponent)currentEditor);
        readOnly.setText(text);
        return readOnly;
    }

    public Component updateWritableEditor(Component currentEditor, String text) {
        if (!(currentEditor instanceof JTextComponent)) {
            return null;
        }
        JTextComponent writable = ReadOnlyEditorComponent.undecorate((JTextComponent)currentEditor);
        writable.setText(text);
        return writable;
    }

    private EditorComponentFactory factoryFor(EditorComponentInfo editorComponentInfo) {
        for (EditorComponentFactory factory : this.registry) {
            if (!factory.canCreateEditorFrom(editorComponentInfo) && !factory.canCreateEditorFrom(editorComponentInfo.initialValue())) continue;
            return factory;
        }
        return null;
    }

    public static EditorComponentFactoryRegistry instance() {
        return EditorComponentFactoryRegistrySingleton.instance;
    }

    private EditorComponentFactoryRegistry() {
        this.register(new MappedEditorFactory());
        this.register(this.comboBoxEditorFactory());
    }

    public void unregisterAllEditorFactories() {
        this.registry.clear();
    }

    public EditorComponentFactory[] getArrayCopyOfEditorFactories() {
        return this.registry.toArray(new EditorComponentFactory[this.registry.size()]);
    }

    private static class EditorComponentFactoryRegistrySingleton {
        static EditorComponentFactoryRegistry instance = new EditorComponentFactoryRegistry();

        private EditorComponentFactoryRegistrySingleton() {
        }
    }
}

