/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util.reflect;

import java.lang.reflect.Method;

public class IdeMethodInvoker<T> {
    private final T m_instance;

    public IdeMethodInvoker(T instance) {
        this.m_instance = instance;
    }

    public Object invoke(String methodName, Object ... params) {
        Method method = IdeMethodInvoker.findMethod(methodName, this.m_instance.getClass().getMethods(), params);
        if (method == null) {
            method = IdeMethodInvoker.findMethod(methodName, this.m_instance.getClass().getDeclaredMethods(), params);
        }
        if (method != null) {
            try {
                method.setAccessible(true);
                return method.invoke(this.m_instance, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(methodName + " was not found for " + this.m_instance.getClass());
    }

    private static Method findMethod(String methodName, Method[] methods, Object ... params) {
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || params == null || params.length != method.getParameterTypes().length) continue;
            boolean methodMatches = true;
            for (int i = 0; i < params.length && methodMatches; ++i) {
                Class<?> parameterType = method.getParameterTypes()[i];
                if (params[i] != null) {
                    Class<?> parameterValue = params[i].getClass();
                    if (parameterType.isAssignableFrom(parameterValue) || parameterType.isPrimitive() || parameterValue.isPrimitive()) continue;
                    methodMatches = false;
                    continue;
                }
                if (!parameterType.isPrimitive()) continue;
                methodMatches = false;
            }
            if (!methodMatches) continue;
            return method;
        }
        return null;
    }
}

