/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WeakCache<K, V> {
    private HashMap<K, WeakReference<V>> cache = new HashMap();
    private boolean keyRetained = false;

    public void setKeyRetained(boolean retained) {
        this.keyRetained = retained;
    }

    public boolean isKeyRetained() {
        return this.keyRetained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            WeakReference<V> ref = this.cache.get(key);
            if (ref != null) {
                Object data = ref.get();
                if (data != null) {
                    return (V)data;
                }
                if (!this.keyRetained) {
                    this.cache.remove(key);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        WeakReference<V> oldValue;
        WeakReference<V> ref = new WeakReference<V>(value);
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            oldValue = this.cache.put(key, ref);
        }
        return oldValue != null ? (V)oldValue.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        WeakReference<V> oldValue;
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            oldValue = this.cache.remove(key);
        }
        return oldValue != null ? (V)oldValue.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keys() {
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            return new HashSet<K>(this.cache.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<V> iterator() {
        ArrayList l = new ArrayList();
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            Iterator<WeakReference<V>> iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                WeakReference<V> ref = iter.next();
                Object o = ref.get();
                if (o == null) {
                    iter.remove();
                    continue;
                }
                l.add(o);
            }
        }
        return Collections.unmodifiableList(l).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry<K, V>> entries() {
        ArrayList<Entry<K, V>> entries = new ArrayList<Entry<K, V>>();
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            for (Map.Entry<K, WeakReference<V>> entry : this.cache.entrySet()) {
                Object value = entry.getValue().get();
                if (value == null) continue;
                entries.add(new Entry(entry.getKey(), value));
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<K, WeakReference<V>> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.clear();
        }
    }

    public static class Entry<K, V> {
        final K m_Key;
        final V m_Value;

        public Entry(K key, V value) {
            this.m_Key = key;
            this.m_Value = value;
        }

        public Object getKey() {
            return this.m_Key;
        }

        public Object getValue() {
            return this.m_Value;
        }
    }
}

