/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class MacroExpander {
    private char[] startDelim_;
    private char[] endDelim_;
    private boolean recursiveParse_;
    private boolean sanitizedMacroValues_;

    public MacroExpander() {
        this("${", "}", true, false);
    }

    public MacroExpander(String startDelim, String endDelim, boolean recursiveParse, boolean sanitizedMacroKeys) {
        this.startDelim_ = startDelim.toCharArray();
        this.endDelim_ = endDelim.toCharArray();
        this.setRecursiveParse(recursiveParse);
        this.setSanitizedMacroKeys(sanitizedMacroKeys);
    }

    public String expand(String macro, Map<String, String> macroValues) {
        if (macro == null) {
            throw new IllegalArgumentException("Macro cannot be null");
        }
        Stack result = new Stack();
        FifoQueue input = new FifoQueue(macro);
        int startDelims = 0;
        while (!input.isEmpty()) {
            result.push(input.get(1));
            if (result.peek(this.startDelim_)) {
                ++startDelims;
            }
            if (!result.peek(this.endDelim_)) continue;
            if (startDelims == 0) {
                throw new IllegalArgumentException("Missing delimiter in macro: " + result.toString());
            }
            char[] token = result.pop(this.startDelim_);
            --startDelims;
            char[] value = this.lookup(token, macroValues);
            if (this.recursiveParse_) {
                if (value == null) {
                    throw new NoSuchElementException("Macro " + new String(token) + " could not be resolved: " + result.toString());
                }
                input.pushBack(value);
                continue;
            }
            if (value == null) {
                result.push(token);
                continue;
            }
            result.push(value);
        }
        if (startDelims != 0) {
            throw new IllegalArgumentException("Missing ending delimiter in macro");
        }
        return result.toString();
    }

    private char[] lookup(char[] token, Map<String, String> macroValues) {
        String key;
        if (this.sanitizedMacroValues_) {
            int keyLen = token.length - this.startDelim_.length - this.endDelim_.length;
            key = new String(token, this.startDelim_.length, keyLen);
        } else {
            key = new String(token);
        }
        String value = macroValues.get(key);
        if (value == null) {
            return null;
        }
        return value.toCharArray();
    }

    public void setRecursiveParse(boolean recursiveParse) {
        this.recursiveParse_ = recursiveParse;
    }

    public boolean isRecursiveParse() {
        return this.recursiveParse_;
    }

    public void setSanitizedMacroKeys(boolean sanitizedMacroKeys) {
        this.sanitizedMacroValues_ = sanitizedMacroKeys;
    }

    public boolean isSanitizedMacroKeys() {
        return this.sanitizedMacroValues_;
    }

    private static class FifoQueue {
        final LinkedList<Character> impl = new LinkedList();

        FifoQueue(String s) {
            this.add(s);
        }

        void add(char[] c) {
            for (int i = 0; i < c.length; ++i) {
                this.impl.add(new Character(c[i]));
            }
        }

        void add(String s) {
            this.add(s.toCharArray());
        }

        void pushBack(char[] c) {
            for (int i = c.length - 1; i >= 0; --i) {
                this.impl.addFirst(Character.valueOf(c[i]));
            }
        }

        char[] get(int c) {
            int i;
            char[] ret = new char[c];
            try {
                for (i = 0; i < c; ++i) {
                    ret[i] = this.impl.removeFirst().charValue();
                }
            }
            catch (NoSuchElementException e) {
                char[] newRet = new char[i];
                System.arraycopy(ret, 0, newRet, 0, i);
                ret = newRet;
            }
            return ret;
        }

        boolean isEmpty() {
            return this.impl.isEmpty();
        }
    }

    private static class Stack {
        ArrayList<Character> impl = new ArrayList();
        private int ptr = 0;

        private Stack() {
        }

        private boolean peek(char[] c, int offset) {
            int i;
            for (i = 0; offset + i < this.ptr && i < c.length && c[i] == this.impl.get(offset + i).charValue(); ++i) {
            }
            return i == c.length;
        }

        private boolean peek(char[] c) {
            return c.length <= this.ptr ? this.peek(c, this.ptr - c.length) : false;
        }

        private char[] pop(char[] pattern) {
            assert (this.ptr != 0);
            for (int i = this.ptr - 1; i >= 0; --i) {
                if (!this.peek(pattern, i)) continue;
                return this.pop(i);
            }
            throw new IndexOutOfBoundsException("Pattern " + pattern + " not found on stack");
        }

        private char[] pop(int i) {
            char[] ret = new char[this.ptr - i];
            for (int j = i; j < this.ptr; ++j) {
                ret[j - i] = this.impl.get(j).charValue();
            }
            this.ptr = i;
            return ret;
        }

        private void push(char[] c) {
            if (this.ptr + c.length > this.impl.size()) {
                this.impl.ensureCapacity((this.impl.size() + c.length) * 2);
            }
            for (int i = 0; i < c.length; ++i) {
                if (this.ptr < this.impl.size()) {
                    this.impl.set(this.ptr, Character.valueOf(c[i]));
                } else {
                    this.impl.add(Character.valueOf(c[i]));
                }
                ++this.ptr;
            }
        }

        public String toString() {
            return new String(this.pop(0));
        }
    }
}

