/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<? extends T> _currentIterator;
    private Iterator<Iterator<? extends T>> _iterators;

    public CompositeIterator(Iterator<? extends T> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public CompositeIterator(Collection<Iterator<? extends T>> iterators) {
        this._iterators = iterators.iterator();
        this._currentIterator = this._iterators.hasNext() ? this._iterators.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this._currentIterator != null && this._currentIterator.hasNext();
    }

    @Override
    public T next() {
        if (this._currentIterator == null) {
            throw new NoSuchElementException();
        }
        T value = this._currentIterator.next();
        this.advance();
        return value;
    }

    private void advance() {
        if (this._currentIterator.hasNext()) {
            return;
        }
        while (this._iterators.hasNext()) {
            this._currentIterator = this._iterators.next();
            if (!this._currentIterator.hasNext()) continue;
            break;
        }
    }

    @Override
    public void remove() {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.remove();
    }
}

