/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.CodeBlockSymbol;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.CompoundStatement;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionWrapper;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.Nameable;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.javatools.parser.plsql.old.symbol.TypeSymbol;
import oracle.javatools.parser.plsql.old.symbol.VariableSymbol;
import oracle.javatools.parser.util.SimpleStack;

public class PlsqlSymbolFactory
implements PlsqlSyntaxCodes {
    private SimpleStack freeWrappers = new SimpleStack();

    private ExpressionWrapper getRefurbishedWrapper(int syntaxCode) {
        int nFreeExpressions = this.freeWrappers.size();
        if (nFreeExpressions > 0) {
            int index = nFreeExpressions - 1;
            ExpressionWrapper reused = (ExpressionWrapper)this.freeWrappers.pop();
            reused.refurbish(syntaxCode);
            return reused;
        }
        return null;
    }

    private ExpressionWrapper getNewExpressionWrapper(int syntaxCode) {
        ExpressionWrapper refurbished = this.getRefurbishedWrapper(syntaxCode);
        if (refurbished != null) {
            return refurbished;
        }
        ExpressionWrapper newGuy = new ExpressionWrapper(syntaxCode, this);
        return newGuy;
    }

    void reclaimWrapper(ExpressionWrapper e) {
        this.freeWrappers.push(e);
    }

    public PlsqlSymbol createAndFinishErrorSymbol(SyntaxToken token, CommonRoot root) {
        ErrorSymbol newSymbol = new ErrorSymbol(token.getContextString());
        newSymbol.parent = root;
        newSymbol.startOffset = token.getStartOffset();
        newSymbol.endOffset = token.getEndOffset();
        newSymbol.dataValue = token.getDataValue();
        root.addError(newSymbol);
        return newSymbol;
    }

    public PlsqlSymbol createSymbol(SyntaxToken token, PlsqlSymbol parent) {
        return this.createSymbol(token.getCode(), token.getStartOffset(), token.getEndOffset(), parent);
    }

    public PlsqlSymbol createSymbol(int syntaxCode, int startOffset, int endOffset, PlsqlSymbol parent) {
        PlsqlSymbol symbol;
        switch (syntaxCode) {
            case 600: {
                symbol = this.getNewExpressionWrapper(syntaxCode);
                if (parent.code != 10) break;
                ((CommonRoot)parent).setRoot((ErrorReporter)((Object)symbol));
                break;
            }
            case 610: 
            case 750: 
            case 760: {
                symbol = new ExpressionList(syntaxCode, this);
                break;
            }
            case 630: 
            case 711: 
            case 712: 
            case 713: {
                symbol = new ExpressionSymbol(syntaxCode, this);
                break;
            }
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 1010: {
                symbol = new TypeSymbol(syntaxCode);
                break;
            }
            case 601: 
            case 631: 
            case 632: 
            case 752: 
            case 753: 
            case 1002: 
            case 1003: {
                symbol = new NameSymbol(syntaxCode);
                break;
            }
            case 350: {
                symbol = new CodeBlockSymbol(syntaxCode);
                break;
            }
            case 330: 
            case 331: 
            case 351: 
            case 352: {
                symbol = new CompoundStatement(syntaxCode);
                break;
            }
            case 250: 
            case 311: 
            case 312: 
            case 313: 
            case 332: {
                symbol = new Statement(syntaxCode);
                break;
            }
            case 110: {
                symbol = new PackageSymbol(syntaxCode);
                break;
            }
            case 140: 
            case 150: {
                symbol = new FunctionSymbol(syntaxCode);
                break;
            }
            case 200: {
                symbol = new CodeBlockSymbol(syntaxCode);
                break;
            }
            case 156: 
            case 510: 
            case 550: {
                symbol = new VariableSymbol(syntaxCode);
                break;
            }
            case 10: {
                symbol = new CommonRoot();
                break;
            }
            case 25: {
                symbol = new RootSymbol();
                if (parent.code != 10) break;
                ((CommonRoot)parent).setRoot((RootSymbol)symbol);
                break;
            }
            default: {
                symbol = new PlsqlSymbol(syntaxCode);
            }
        }
        symbol.parent = parent;
        symbol.startOffset = startOffset;
        symbol.endOffset = endOffset;
        return symbol;
    }

    public boolean forceFinishSymbol(PlsqlSymbol symbol, int endOffset, ReadTextBuffer buffer) {
        try {
            symbol.endOffset = endOffset;
            this.finishSymbol(symbol, buffer);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void finishSymbol(PlsqlSymbol symbol, SyntaxToken token, ReadTextBuffer buffer) {
        symbol.endOffset = token.getEndOffset();
        symbol.dataValue = token.getDataValue();
        this.finishSymbol(symbol, buffer);
    }

    public void finishSymbol(PlsqlSymbol symbol, ReadTextBuffer buffer) {
        try {
            PlsqlSymbol parent = symbol.parent;
            switch (symbol.code) {
                case 511: 
                case 512: 
                case 513: 
                case 514: 
                case 1010: {
                    if (parent.code == 150) {
                        ((FunctionSymbol)parent).setReturnType((TypeSymbol)symbol);
                    } else if (parent instanceof VariableSymbol) {
                        ((VariableSymbol)parent).useType((TypeSymbol)symbol);
                        ((TypeSymbol)symbol).recordName(buffer);
                    }
                    ((TypeSymbol)symbol).recordName(buffer);
                    break;
                }
                case 601: 
                case 631: 
                case 632: 
                case 752: 
                case 753: 
                case 1002: 
                case 1003: {
                    if (parent instanceof Nameable) {
                        ((Nameable)((Object)parent)).setName((NameSymbol)symbol);
                    } else if (parent.code == 352) {
                        ((CompoundStatement)parent).setVariableName((NameSymbol)symbol);
                    }
                    ((NameSymbol)symbol).recordName(buffer);
                    break;
                }
                case 550: {
                    ((CodeBlockSymbol)parent).addVariable((VariableSymbol)symbol);
                    break;
                }
                case 510: {
                    ((CodeBlockSymbol)parent).addType((VariableSymbol)symbol);
                    break;
                }
                case 156: {
                    if (!(parent.parent instanceof FunctionSymbol)) break;
                    ((FunctionSymbol)parent.parent).addParameter((VariableSymbol)symbol);
                    break;
                }
                case 200: {
                    if (parent.code == 25 || !(parent instanceof Statement)) break;
                    ((Statement)parent).setBlock((CodeBlockSymbol)symbol);
                    break;
                }
                case 350: {
                    if (!(parent instanceof Statement)) break;
                    ((Statement)parent).setBlock((CodeBlockSymbol)symbol);
                    break;
                }
                case 311: 
                case 312: 
                case 313: 
                case 330: 
                case 351: 
                case 352: {
                    PlsqlSymbol p = parent;
                    while (p != null && !(p instanceof CodeBlockSymbol)) {
                        p = p.parent;
                    }
                    if (p == null) break;
                    ((CodeBlockSymbol)p).addStatement((Statement)symbol);
                    break;
                }
                case 331: 
                case 332: {
                    ((CompoundStatement)parent).addElseClause((Statement)symbol);
                    break;
                }
            }
            symbol.doneParsing();
        }
        catch (ClassCastException e) {
            try {
                symbol.parent.internalError("I'm the parent");
            }
            catch (Exception exception) {
                // empty catch block
            }
            symbol.internalError("Class cast exception during finishSymbol");
        }
        catch (NullPointerException npe) {
            symbol.reportSyntaxError(PlsqlSyntaxRecognizer.SYNTAXERR_SKIPPING);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

