/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import java.util.EnumSet;
import java.util.HashSet;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

public class AssignableFilter
implements JavaFilter {
    private final JavaType target;
    private final EnumSet<Require> requires;
    private final HashSet hits = new HashSet(10);
    private final HashSet misses = new HashSet();

    @Override
    public final boolean accepts(JavaElement element) {
        if (!(element instanceof JavaHasType)) {
            return false;
        }
        boolean isType = element instanceof JavaType;
        boolean reqType = true;
        if (this.requires.contains((Object)Require.INSTANCE)) {
            reqType = false;
        } else if (this.requires.contains((Object)Require.TYPE) || this.requires.contains((Object)Require.EXACT_TYPE)) {
            reqType = true;
        }
        if (isType != reqType) {
            return false;
        }
        JavaHasType ht = (JavaHasType)element;
        JavaType subject = ht.getResolvedType();
        if (subject == null) {
            return false;
        }
        if (this.hits.contains(subject)) {
            return true;
        }
        if (this.misses.contains(subject)) {
            return false;
        }
        boolean accepted = this.acceptsImpl(subject);
        if (accepted) {
            this.hits.add(subject);
        } else {
            this.misses.add(subject);
        }
        return accepted;
    }

    private boolean acceptsImpl(JavaType subject) {
        if (this.target == null) {
            return subject == null;
        }
        if (this.requires.contains((Object)Require.IS_INTERFACE) && !subject.isInterface()) {
            return false;
        }
        if (subject.isPrimitive()) {
            if (this.requires.contains((Object)Require.NOT_PRIMITIVE)) {
                return false;
            }
            PrimitiveType primitiveType = (PrimitiveType)subject;
            if (this.requires.contains((Object)Require.NOT_NULL) && primitiveType.isNull()) {
                return false;
            }
        }
        if (this.requires.contains((Object)Require.EXACT_TYPE)) {
            return this.target.equals(subject);
        }
        if (this.requires.contains((Object)Require.REVERSE)) {
            return subject.isAssignableFrom(this.target);
        }
        return this.target.isAssignableFrom(subject);
    }

    public AssignableFilter(JavaType target) {
        this(target, EnumSet.noneOf(Require.class));
    }

    public AssignableFilter(JavaType target, EnumSet<Require> requires) {
        this.target = target;
        this.requires = requires;
        if (requires == null) {
            throw new IllegalArgumentException();
        }
    }

    public JavaType getTarget() {
        return this.target;
    }

    public static enum Require {
        INSTANCE,
        TYPE,
        EXACT_TYPE,
        REVERSE,
        NOT_NULL,
        NOT_PRIMITIVE,
        IS_INTERFACE;

    }
}

